/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.resource.beans.spi.ManagedBean;

public class FilterDefinition
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String filterName;
    private final @UnknownKeyFor @NonNull @Initialized String defaultFilterCondition;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JdbcMapping> explicitParamJaMappings = new HashMap<String, JdbcMapping>();
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ManagedBean<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>>> parameterResolverMap = new HashMap();
    private final @UnknownKeyFor @NonNull @Initialized boolean autoEnabled;

    public FilterDefinition(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String defaultCondition, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JdbcMapping> explicitParamJaMappings) {
        this(name, defaultCondition, false, explicitParamJaMappings, Collections.emptyMap());
    }

    public FilterDefinition(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String defaultCondition, @UnknownKeyFor @NonNull @Initialized boolean autoEnabled, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JdbcMapping> explicitParamJaMappings, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ManagedBean<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?>>> parameterResolverMap) {
        this.filterName = name;
        this.defaultFilterCondition = defaultCondition;
        if (explicitParamJaMappings != null) {
            this.explicitParamJaMappings.putAll(explicitParamJaMappings);
        }
        if (parameterResolverMap != null) {
            this.parameterResolverMap.putAll(parameterResolverMap);
        }
        this.autoEnabled = autoEnabled;
    }

    public @UnknownKeyFor @NonNull @Initialized String getFilterName() {
        return this.filterName;
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> getParameterNames() {
        Set<String> keys = this.explicitParamJaMappings.keySet();
        return keys;
    }

    public @Nullable @UnknownKeyFor @Initialized JdbcMapping getParameterJdbcMapping(@UnknownKeyFor @NonNull @Initialized String parameterName) {
        return this.explicitParamJaMappings.get(parameterName);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Supplier<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> getParameterResolver(@UnknownKeyFor @NonNull @Initialized String parameterName) {
        ManagedBean<Supplier<?>> resolver = this.parameterResolverMap.get(parameterName);
        return resolver == null ? null : resolver.getBeanInstance();
    }

    public @UnknownKeyFor @NonNull @Initialized String getDefaultFilterCondition() {
        return this.defaultFilterCondition;
    }

    public @UnknownKeyFor @NonNull @Initialized Object processArgument(@UnknownKeyFor @NonNull @Initialized Object value) {
        return value;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAutoEnabled() {
        return this.autoEnabled;
    }
}

