/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import jakarta.persistence.PersistenceException;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.stream.StreamSource;
import org.hibernate.boot.archive.internal.ArchiveHelper;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.configuration.spi.JaxbPersistenceImpl;
import org.hibernate.boot.jaxb.internal.ConfigurationBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.jpa.boot.internal.ParsedPersistenceXmlDescriptor;
import org.hibernate.jpa.internal.util.ConfigurationHelper;

public class PersistenceXmlParser {
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(PersistenceXmlParser.class);
    private final ClassLoaderService classLoaderService;
    private final PersistenceUnitTransactionType defaultTransactionType;
    private final Map<String, ParsedPersistenceXmlDescriptor> persistenceUnits;

    public static List<ParsedPersistenceXmlDescriptor> locatePersistenceUnits(Map<?, ?> integration) {
        PersistenceXmlParser parser = new PersistenceXmlParser(ClassLoaderServiceImpl.fromConfigSettings(integration), PersistenceUnitTransactionType.RESOURCE_LOCAL);
        parser.doResolve(integration);
        return new ArrayList<ParsedPersistenceXmlDescriptor>(parser.persistenceUnits.values());
    }

    public static ParsedPersistenceXmlDescriptor locateIndividualPersistenceUnit(URL persistenceXmlUrl) {
        return PersistenceXmlParser.locateIndividualPersistenceUnit(persistenceXmlUrl, Collections.emptyMap());
    }

    public static ParsedPersistenceXmlDescriptor locateIndividualPersistenceUnit(URL persistenceXmlUrl, Map<?, ?> integration) {
        return PersistenceXmlParser.locateIndividualPersistenceUnit(persistenceXmlUrl, PersistenceUnitTransactionType.RESOURCE_LOCAL, integration);
    }

    public static ParsedPersistenceXmlDescriptor locateIndividualPersistenceUnit(URL persistenceXmlUrl, PersistenceUnitTransactionType transactionType, Map<?, ?> integration) {
        PersistenceXmlParser parser = new PersistenceXmlParser(ClassLoaderServiceImpl.fromConfigSettings(integration), transactionType);
        parser.parsePersistenceXml(persistenceXmlUrl, integration);
        assert (parser.persistenceUnits.size() == 1);
        return parser.persistenceUnits.values().iterator().next();
    }

    public static ParsedPersistenceXmlDescriptor locateNamedPersistenceUnit(URL persistenceXmlUrl, String name) {
        return PersistenceXmlParser.locateNamedPersistenceUnit(persistenceXmlUrl, name, Collections.emptyMap());
    }

    public static ParsedPersistenceXmlDescriptor locateNamedPersistenceUnit(URL persistenceXmlUrl, String name, Map<?, ?> integration) {
        return PersistenceXmlParser.locateNamedPersistenceUnit(persistenceXmlUrl, name, PersistenceUnitTransactionType.RESOURCE_LOCAL, integration);
    }

    public static ParsedPersistenceXmlDescriptor locateNamedPersistenceUnit(URL persistenceXmlUrl, String name, PersistenceUnitTransactionType transactionType, Map<?, ?> integration) {
        assert (StringHelper.isNotEmpty(name));
        PersistenceXmlParser parser = new PersistenceXmlParser(ClassLoaderServiceImpl.fromConfigSettings(integration), transactionType);
        parser.parsePersistenceXml(persistenceXmlUrl, integration);
        assert (parser.persistenceUnits.containsKey(name));
        return parser.persistenceUnits.get(name);
    }

    public static Map<String, ParsedPersistenceXmlDescriptor> parse(URL persistenceXmlUrl, PersistenceUnitTransactionType transactionType) {
        return PersistenceXmlParser.parse(persistenceXmlUrl, transactionType, Collections.emptyMap());
    }

    public static Map<String, ParsedPersistenceXmlDescriptor> parse(URL persistenceXmlUrl, PersistenceUnitTransactionType transactionType, Map<?, ?> integration) {
        PersistenceXmlParser parser = new PersistenceXmlParser(ClassLoaderServiceImpl.fromConfigSettings(integration), transactionType);
        parser.parsePersistenceXml(persistenceXmlUrl, integration);
        return parser.persistenceUnits;
    }

    protected PersistenceXmlParser(ClassLoaderService classLoaderService, PersistenceUnitTransactionType defaultTransactionType) {
        this.classLoaderService = classLoaderService;
        this.defaultTransactionType = defaultTransactionType;
        this.persistenceUnits = new ConcurrentHashMap<String, ParsedPersistenceXmlDescriptor>();
    }

    protected List<ParsedPersistenceXmlDescriptor> getResolvedPersistenceUnits() {
        return new ArrayList<ParsedPersistenceXmlDescriptor>(this.persistenceUnits.values());
    }

    private void doResolve(Map<?, ?> integration) {
        List<URL> xmlUrls = this.classLoaderService.locateResources("META-INF/persistence.xml");
        if (xmlUrls.isEmpty()) {
            LOG.unableToFindPersistenceXmlInClasspath();
        } else {
            this.parsePersistenceXml(xmlUrls, integration);
        }
    }

    private void parsePersistenceXml(List<URL> xmlUrls, Map<?, ?> integration) {
        for (URL xmlUrl : xmlUrls) {
            this.parsePersistenceXml(xmlUrl, integration);
        }
    }

    protected void parsePersistenceXml(URL xmlUrl, Map<?, ?> integration) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("Attempting to parse persistence.xml file : %s", xmlUrl.toExternalForm());
        }
        URL persistenceUnitRootUrl = ArchiveHelper.getJarURLFromURLEntry(xmlUrl, "/META-INF/persistence.xml");
        JaxbPersistenceImpl jaxbPersistence = this.loadUrlWithJaxb(xmlUrl);
        List<JaxbPersistenceImpl.JaxbPersistenceUnitImpl> jaxbPersistenceUnits = jaxbPersistence.getPersistenceUnit();
        for (int i = 0; i < jaxbPersistenceUnits.size(); ++i) {
            JaxbPersistenceImpl.JaxbPersistenceUnitImpl jaxbPersistenceUnit = jaxbPersistenceUnits.get(i);
            if (this.persistenceUnits.containsKey(jaxbPersistenceUnit.getName())) {
                LOG.duplicatedPersistenceUnitName(jaxbPersistenceUnit.getName());
                continue;
            }
            ParsedPersistenceXmlDescriptor persistenceUnitDescriptor = new ParsedPersistenceXmlDescriptor(persistenceUnitRootUrl);
            this.bindPersistenceUnit(jaxbPersistenceUnit, persistenceUnitDescriptor);
            this.applyIntegrationOverrides(integration, persistenceUnitDescriptor);
            this.persistenceUnits.put(persistenceUnitDescriptor.getName(), persistenceUnitDescriptor);
        }
    }

    private void bindPersistenceUnit(JaxbPersistenceImpl.JaxbPersistenceUnitImpl jaxbPersistenceUnit, ParsedPersistenceXmlDescriptor persistenceUnitDescriptor) {
        PersistenceUnitTransactionType transactionType;
        String name = jaxbPersistenceUnit.getName();
        if (StringHelper.isNotEmpty(name)) {
            LOG.tracef("Persistence unit name from persistence.xml : %s", name);
            persistenceUnitDescriptor.setName(name);
        }
        if ((transactionType = jaxbPersistenceUnit.getTransactionType()) != null) {
            persistenceUnitDescriptor.setTransactionType(transactionType);
        }
        persistenceUnitDescriptor.setProviderClassName(jaxbPersistenceUnit.getProvider());
        persistenceUnitDescriptor.setNonJtaDataSource(jaxbPersistenceUnit.getNonJtaDataSource());
        persistenceUnitDescriptor.setJtaDataSource(jaxbPersistenceUnit.getJtaDataSource());
        persistenceUnitDescriptor.setSharedCacheMode(jaxbPersistenceUnit.getSharedCacheMode());
        persistenceUnitDescriptor.setValidationMode(jaxbPersistenceUnit.getValidationMode());
        persistenceUnitDescriptor.setExcludeUnlistedClasses(this.handleBoolean(jaxbPersistenceUnit.isExcludeUnlistedClasses(), false));
        persistenceUnitDescriptor.addClasses(jaxbPersistenceUnit.getClasses());
        persistenceUnitDescriptor.addMappingFiles(jaxbPersistenceUnit.getMappingFiles());
        persistenceUnitDescriptor.addJarFileUrls(jaxbPersistenceUnit.getJarFiles());
        JaxbPersistenceImpl.JaxbPersistenceUnitImpl.JaxbPropertiesImpl propertyContainer = jaxbPersistenceUnit.getPropertyContainer();
        if (propertyContainer != null) {
            for (JaxbPersistenceImpl.JaxbPersistenceUnitImpl.JaxbPropertiesImpl.JaxbPropertyImpl property : propertyContainer.getProperties()) {
                persistenceUnitDescriptor.getProperties().put(property.getName(), property.getValue());
            }
        }
    }

    private boolean handleBoolean(Boolean incoming, boolean fallback) {
        if (incoming != null) {
            return incoming;
        }
        return fallback;
    }

    private void applyIntegrationOverrides(Map<?, ?> integration, ParsedPersistenceXmlDescriptor persistenceUnitDescriptor) {
        if (integration.containsKey("jakarta.persistence.provider")) {
            persistenceUnitDescriptor.setProviderClassName((String)integration.get("jakarta.persistence.provider"));
        } else if (integration.containsKey("javax.persistence.provider")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.provider", "jakarta.persistence.provider");
            persistenceUnitDescriptor.setProviderClassName((String)integration.get("javax.persistence.provider"));
        }
        if (integration.containsKey("javax.persistence.transactionType")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.transactionType", "jakarta.persistence.transactionType");
            transactionType = (String)integration.get("javax.persistence.transactionType");
            persistenceUnitDescriptor.setTransactionType(PersistenceXmlParser.parseTransactionType(transactionType));
        } else if (integration.containsKey("jakarta.persistence.transactionType")) {
            transactionType = (String)integration.get("jakarta.persistence.transactionType");
            persistenceUnitDescriptor.setTransactionType(PersistenceXmlParser.parseTransactionType(transactionType));
        }
        if (integration.containsKey("javax.persistence.jtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.jtaDataSource", "jakarta.persistence.jtaDataSource");
            persistenceUnitDescriptor.setJtaDataSource(integration.get("javax.persistence.jtaDataSource"));
        } else if (integration.containsKey("jakarta.persistence.jtaDataSource")) {
            persistenceUnitDescriptor.setJtaDataSource(integration.get("jakarta.persistence.jtaDataSource"));
        }
        if (integration.containsKey("javax.persistence.nonJtaDataSource")) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("javax.persistence.nonJtaDataSource", "jakarta.persistence.nonJtaDataSource");
            persistenceUnitDescriptor.setNonJtaDataSource(integration.get("javax.persistence.nonJtaDataSource"));
        } else if (integration.containsKey("jakarta.persistence.nonJtaDataSource")) {
            persistenceUnitDescriptor.setNonJtaDataSource(integration.get("jakarta.persistence.nonJtaDataSource"));
        }
        this.applyTransactionTypeOverride(persistenceUnitDescriptor);
        Properties properties = persistenceUnitDescriptor.getProperties();
        ConfigurationHelper.overrideProperties(properties, integration);
    }

    private void applyTransactionTypeOverride(ParsedPersistenceXmlDescriptor persistenceUnitDescriptor) {
        if (persistenceUnitDescriptor.getTransactionType() != null) {
            return;
        }
        if (persistenceUnitDescriptor.getJtaDataSource() != null) {
            persistenceUnitDescriptor.setTransactionType(PersistenceUnitTransactionType.JTA);
        } else if (persistenceUnitDescriptor.getNonJtaDataSource() != null) {
            persistenceUnitDescriptor.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
        } else {
            persistenceUnitDescriptor.setTransactionType(this.defaultTransactionType);
        }
    }

    private static PersistenceUnitTransactionType parseTransactionType(String value) {
        if (StringHelper.isEmpty(value)) {
            return null;
        }
        if (value.equalsIgnoreCase("JTA")) {
            return PersistenceUnitTransactionType.JTA;
        }
        if (value.equalsIgnoreCase("RESOURCE_LOCAL")) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        throw new PersistenceException("Unknown persistence unit transaction type : " + value);
    }

    private JaxbPersistenceImpl loadUrlWithJaxb(URL xmlUrl) {
        JaxbPersistenceImpl jaxbPersistenceImpl;
        block11: {
            String resourceName = xmlUrl.toExternalForm();
            URLConnection conn = xmlUrl.openConnection();
            conn.setUseCaches(false);
            InputStream inputStream = conn.getInputStream();
            try {
                StreamSource inputSource = new StreamSource(inputStream);
                ConfigurationBinder configurationBinder = new ConfigurationBinder(this.classLoaderService);
                Binding binding = configurationBinder.bind(inputSource, new Origin(SourceType.URL, resourceName));
                jaxbPersistenceImpl = (JaxbPersistenceImpl)binding.getRoot();
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Unable to obtain input stream from [" + resourceName + "]", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    throw new PersistenceException("Unable to access [" + resourceName + "]", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return jaxbPersistenceImpl;
    }
}

