/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.spi.LoadState;
import java.io.Serializable;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.jboss.logging.Logger;

public class PersistenceUnitUtilImpl
implements PersistenceUnitUtil,
Serializable {
    private static final Logger log = Logger.getLogger(PersistenceUnitUtilImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final transient PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();

    public PersistenceUnitUtilImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean isLoaded(Object entity, String attributeName) {
        log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
        switch (PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache)) {
            case LOADED: {
                return true;
            }
            case NOT_LOADED: {
                return false;
            }
        }
        return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
    }

    public <E> boolean isLoaded(E entity, Attribute<? super E, ?> attribute) {
        return Hibernate.isPropertyInitialized(entity, attribute.getName());
    }

    public boolean isLoaded(Object entity) {
        log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
        return PersistenceUtilHelper.getLoadState(entity) != LoadState.NOT_LOADED;
    }

    public void load(Object entity, String attributeName) {
        Hibernate.initializeProperty(entity, attributeName);
    }

    public <E> void load(E entity, Attribute<? super E, ?> attribute) {
        this.load(entity, attribute.getName());
    }

    public void load(Object entity) {
        Hibernate.initialize(entity);
    }

    public boolean isInstance(Object entity, Class<?> entityClass) {
        return entityClass.isAssignableFrom(Hibernate.getClassLazy(entity));
    }

    public <T> Class<? extends T> getClass(T entity) {
        return Hibernate.getClassLazy(entity);
    }

    public Object getIdentifier(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Passed entity cannot be null");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            return lazyInitializer.getInternalIdentifier();
        }
        if (ManagedTypeHelper.isManagedEntity(entity)) {
            EntityEntry entityEntry = ManagedTypeHelper.asManagedEntity(entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                return entityEntry.getId();
            }
            log.debug((Object)"jakarta.persistence.PersistenceUnitUtil.getIdentifier may not be able to read identifier of a detached entity");
            return this.getIdentifierFromPersister(entity);
        }
        log.debug((Object)"jakarta.persistence.PersistenceUnitUtil.getIdentifier is only intended to work with enhanced entities (although Hibernate also adapts this support to its proxies); however the passed entity was not enhanced (nor a proxy).. may not be able to read identifier");
        return this.getIdentifierFromPersister(entity);
    }

    public Object getVersion(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Passed entity cannot be null");
        }
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(entity);
        if (lazyInitializer != null) {
            return this.getVersionFromPersister(lazyInitializer.getImplementation());
        }
        if (ManagedTypeHelper.isManagedEntity(entity)) {
            EntityEntry entityEntry = ManagedTypeHelper.asManagedEntity(entity).$$_hibernate_getEntityEntry();
            if (entityEntry != null) {
                return entityEntry.getVersion();
            }
            return this.getVersionFromPersister(entity);
        }
        return this.getVersionFromPersister(entity);
    }

    private Object getIdentifierFromPersister(Object entity) {
        EntityPersister persister;
        Class<Object> entityClass = Hibernate.getClass(entity);
        try {
            persister = this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityClass);
            if (persister == null) {
                throw new IllegalArgumentException(entityClass.getName() + " is not an entity");
            }
        }
        catch (MappingException ex) {
            throw new IllegalArgumentException(entityClass.getName() + " is not an entity", (Throwable)((Object)ex));
        }
        return persister.getIdentifier(entity, null);
    }

    private Object getVersionFromPersister(Object entity) {
        EntityPersister persister;
        Class<Object> entityClass = Hibernate.getClass(entity);
        try {
            persister = this.sessionFactory.getRuntimeMetamodels().getMappingMetamodel().getEntityDescriptor(entityClass);
            if (persister == null) {
                throw new IllegalArgumentException(entityClass.getName() + " is not an entity");
            }
        }
        catch (MappingException ex) {
            throw new IllegalArgumentException(entityClass.getName() + " is not an entity", (Throwable)((Object)ex));
        }
        return persister.getVersion(entity);
    }
}

