/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.criteria.internal;

import java.io.Serializable;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.hql.spi.SqmQueryImplementor;
import org.hibernate.query.named.AbstractNamedQueryMemento;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.SqmSelectionQuery;
import org.hibernate.query.sqm.internal.QuerySqmImpl;
import org.hibernate.query.sqm.internal.SqmSelectionQueryImpl;
import org.hibernate.query.sqm.spi.NamedSqmQueryMemento;
import org.hibernate.query.sqm.tree.SqmStatement;

public class NamedCriteriaQueryMementoImpl<E>
extends AbstractNamedQueryMemento<E>
implements NamedSqmQueryMemento<E>,
Serializable {
    private final SqmStatement<E> sqmStatement;
    private final Integer firstResult;
    private final Integer maxResults;
    private final LockOptions lockOptions;
    private final Map<String, String> parameterTypes;

    public NamedCriteriaQueryMementoImpl(String name, @Nullable Class<E> resultType, SqmStatement<E> sqmStatement, Integer firstResult, Integer maxResults, Boolean cacheable, String cacheRegion, CacheMode cacheMode, FlushMode flushMode, Boolean readOnly, LockOptions lockOptions, Integer timeout, Integer fetchSize, String comment, Map<String, String> parameterTypes, Map<String, Object> hints) {
        super(name, resultType, cacheable, cacheRegion, cacheMode, flushMode, readOnly, timeout, fetchSize, comment, hints);
        this.sqmStatement = sqmStatement;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.lockOptions = lockOptions;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public void validate(QueryEngine queryEngine) {
    }

    @Override
    public <T> SqmQueryImplementor<T> toQuery(SharedSessionContractImplementor session, Class<T> resultType) {
        return new QuerySqmImpl<T>(this, resultType, session);
    }

    @Override
    public SqmQueryImplementor<E> toQuery(SharedSessionContractImplementor session) {
        return this.toQuery(session, this.getResultType());
    }

    @Override
    public <T> SqmSelectionQuery<T> toSelectionQuery(Class<T> resultType, SharedSessionContractImplementor session) {
        return new SqmSelectionQueryImpl<T>(this, resultType, session);
    }

    @Override
    public String getHqlString() {
        return "<criteria>";
    }

    @Override
    public SqmStatement<E> getSqmStatement() {
        return this.sqmStatement;
    }

    @Override
    public Integer getFirstResult() {
        return this.firstResult;
    }

    @Override
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public Map<String, String> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public NamedSqmQueryMemento<E> makeCopy(String name) {
        return new NamedCriteriaQueryMementoImpl(name, this.getResultType(), this.sqmStatement, this.firstResult, this.maxResults, this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.lockOptions, this.getTimeout(), this.getFetchSize(), this.getComment(), this.parameterTypes, this.getHints());
    }
}

