/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.JoinType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmJoinable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractSqmAttributeJoin<L, R>
extends AbstractSqmJoin<L, R>
implements SqmAttributeJoin<L, R> {
    private boolean fetched;

    public AbstractSqmAttributeJoin(SqmFrom<?, L> lhs, SqmJoinable joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        this(lhs, joinedNavigable.createNavigablePath(lhs, alias), joinedNavigable, alias == "{implicit}" ? null : alias, joinType, fetched, nodeBuilder);
    }

    protected AbstractSqmAttributeJoin(SqmFrom<?, L> lhs, NavigablePath navigablePath, SqmJoinable joinedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(navigablePath, (SqmPathSource)((Object)joinedNavigable), lhs, alias, joinType, nodeBuilder);
        this.fetched = fetched;
        this.validateFetchAlias(alias);
    }

    @Override
    public SqmFrom<?, L> getLhs() {
        return super.getLhs();
    }

    @Override
    public JavaType<R> getNodeJavaType() {
        return this.getJavaTypeDescriptor();
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public SqmAttributeJoin<L, R> alias(String name) {
        this.validateFetchAlias(name);
        return (SqmAttributeJoin)super.alias(name);
    }

    @Override
    public void clearFetched() {
        this.fetched = false;
    }

    private void validateFetchAlias(String alias) {
        if (this.fetched && alias != null && this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not permit specifying an alias for fetch joins.");
        }
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedAttributeJoin(this);
    }

    @Override
    public PersistentAttribute<? super L, ?> getAttribute() {
        return (PersistentAttribute)((Object)this.getReferencedPathSource());
    }

    @Override
    public SqmAttributeJoin<L, R> on(JpaExpression<Boolean> restriction) {
        return (SqmAttributeJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmAttributeJoin<L, R> on(JpaPredicate ... restrictions) {
        return (SqmAttributeJoin)super.on(restrictions);
    }

    @Override
    public SqmFrom<?, L> getParent() {
        return this.getLhs();
    }

    @Override
    public JoinType getJoinType() {
        return this.getSqmJoinType().getCorrespondingJpaJoinType();
    }

    @Override
    public abstract <S extends R> SqmTreatedAttributeJoin<L, R, S> treatAs(Class<S> var1);

    @Override
    public abstract <S extends R> SqmTreatedAttributeJoin<L, R, S> treatAs(EntityDomainType<S> var1);

    @Override
    public abstract <S extends R> SqmTreatedAttributeJoin<L, R, S> treatAs(Class<S> var1, String var2);

    @Override
    public abstract <S extends R> SqmTreatedAttributeJoin<L, R, S> treatAs(EntityDomainType<S> var1, String var2);

    @Override
    public abstract <S extends R> SqmTreatedAttributeJoin<L, R, S> treatAs(Class<S> var1, String var2, boolean var3);

    @Override
    public abstract <S extends R> SqmTreatedAttributeJoin<L, R, S> treatAs(EntityDomainType<S> var1, String var2, boolean var3);
}

