/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Map;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaMapJoin;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmNode;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPluralJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedMapJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.spi.NavigablePath;

public class SqmMapJoin<L, K, V>
extends AbstractSqmPluralJoin<L, Map<K, V>, V>
implements JpaMapJoin<L, K, V> {
    public SqmMapJoin(SqmFrom<?, L> lhs, MapPersistentAttribute<L, K, V> pluralValuedNavigable, String alias, SqmJoinType sqmJoinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, pluralValuedNavigable, alias, sqmJoinType, fetched, nodeBuilder);
    }

    protected SqmMapJoin(SqmFrom<?, L> lhs, NavigablePath navigablePath, MapPersistentAttribute<L, K, V> pluralValuedNavigable, String alias, SqmJoinType joinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, navigablePath, pluralValuedNavigable, alias, joinType, fetched, nodeBuilder);
    }

    @Override
    public SqmMapJoin<L, K, V> copy(SqmCopyContext context) {
        SqmMapJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmNode lhsCopy = this.getLhs().copy(context);
        SqmMapJoin<L, K, V> path = context.registerCopy(this, new SqmMapJoin<L, K, V>(lhsCopy, this.getNavigablePathCopy((SqmPath<?>)lhsCopy), this.getAttribute(), this.getExplicitAlias(), this.getSqmJoinType(), context.copyFetchedFlag() && this.isFetched(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public MapPersistentAttribute<L, K, V> getModel() {
        return (MapPersistentAttribute)super.getModel();
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitMapJoin(this);
    }

    @Override
    public MapPersistentAttribute<L, K, V> getAttribute() {
        return this.getModel();
    }

    public SqmPath<K> key() {
        SqmPathSource keyPathSource = this.getAttribute().getKeyPathSource();
        return this.resolvePath(keyPathSource.getPathName(), keyPathSource);
    }

    public SqmPath<V> value() {
        SqmPathSource elementPathSource = this.getAttribute().getElementPathSource();
        return this.resolvePath(elementPathSource.getPathName(), elementPathSource);
    }

    public Expression<Map.Entry<K, V>> entry() {
        return new SqmMapEntryReference(this, this.nodeBuilder());
    }

    @Override
    public SqmMapJoin<L, K, V> on(JpaExpression<Boolean> restriction) {
        return (SqmMapJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmMapJoin<L, K, V> on(Expression<Boolean> restriction) {
        return (SqmMapJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmMapJoin<L, K, V> on(JpaPredicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    @Override
    public SqmMapJoin<L, K, V> on(Predicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    public SqmCorrelatedMapJoin<L, K, V> createCorrelation() {
        return new SqmCorrelatedMapJoin(this);
    }

    public <S extends V> SqmTreatedMapJoin<L, K, V, S> treatAs(Class<S> treatJavaType) {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    public <S extends V> SqmTreatedMapJoin<L, K, V, S> treatAs(EntityDomainType<S> treatTarget) {
        return this.treatAs((EntityDomainType)treatTarget, (String)null);
    }

    public <S extends V> SqmTreatedMapJoin<L, K, V, S> treatAs(Class<S> treatJavaType, String alias) {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType), alias);
    }

    public <S extends V> SqmTreatedMapJoin<L, K, V, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        SqmTreatedMapJoin treat = (SqmTreatedMapJoin)this.findTreat(treatTarget, alias);
        if (treat == null) {
            return this.addTreat(new SqmTreatedMapJoin(this, treatTarget, alias));
        }
        return treat;
    }

    public <S extends V> SqmTreatedMapJoin<L, K, V, S> treatAs(Class<S> treatJavaType, String alias, boolean fetched) {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType), alias, fetched);
    }

    public <S extends V> SqmTreatedMapJoin<L, K, V, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        SqmTreatedMapJoin treat = (SqmTreatedMapJoin)this.findTreat(treatTarget, alias);
        if (treat == null) {
            return this.addTreat(new SqmTreatedMapJoin(this, treatTarget, alias));
        }
        return treat;
    }

    public SqmMapJoin<L, K, V> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmMapJoin<L, K, V>(creationProcessingState.getPathRegistry().findFromByPath(this.getLhs().getNavigablePath()), this.getAttribute(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), (NodeBuilder)this.nodeBuilder());
    }
}

