/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedSingularJoin<O, T, S extends T>
extends SqmSingularJoin<O, S>
implements SqmTreatedAttributeJoin<O, T, S> {
    private final SqmSingularJoin<O, T> wrappedPath;
    private final EntityDomainType<S> treatTarget;

    public SqmTreatedSingularJoin(SqmSingularJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedSingularJoin(SqmSingularJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedSingularJoin(NavigablePath navigablePath, SqmSingularJoin<O, T> wrappedPath, EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedSingularJoin<O, T, S> copy(SqmCopyContext context) {
        SqmTreatedSingularJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedSingularJoin<O, T, S> path = context.registerCopy(this, new SqmTreatedSingularJoin<O, T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmSingularJoin<O, T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public EntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public EntityDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<?> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public SqmAttributeJoin<O, S> makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmTreatedSingularJoin<O, T, S>(this.wrappedPath, this.treatTarget, this.getAlias());
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append("treat(");
        this.wrappedPath.appendHqlString(sb);
        sb.append(" as ");
        sb.append(this.treatTarget.getName());
        sb.append(')');
    }

    @Override
    public <S1 extends S> SqmTreatedSingularJoin<O, S, S1> treatAs(Class<S1> treatJavaType) {
        return (SqmTreatedSingularJoin)super.treatAs(treatJavaType);
    }

    @Override
    public <S1 extends S> SqmTreatedSingularJoin<O, S, S1> treatAs(EntityDomainType<S1> treatTarget) {
        return (SqmTreatedSingularJoin)super.treatAs(treatTarget);
    }

    @Override
    public <S1 extends S> SqmTreatedSingularJoin<O, S, S1> treatAs(Class<S1> treatJavaType, String alias) {
        return (SqmTreatedSingularJoin)super.treatAs(treatJavaType, alias);
    }

    @Override
    public <S1 extends S> SqmTreatedSingularJoin<O, S, S1> treatAs(EntityDomainType<S1> treatTarget, String alias) {
        return (SqmTreatedSingularJoin)super.treatAs(treatTarget, alias);
    }

    @Override
    public SqmTreatedSingularJoin<O, T, S> on(JpaExpression<Boolean> restriction) {
        return (SqmTreatedSingularJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmTreatedSingularJoin<O, T, S> on(JpaPredicate ... restrictions) {
        return (SqmTreatedSingularJoin)super.on(restrictions);
    }

    @Override
    public SqmTreatedSingularJoin<O, T, S> on(Expression<Boolean> restriction) {
        return (SqmTreatedSingularJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmTreatedSingularJoin<O, T, S> on(Predicate ... restrictions) {
        return (SqmTreatedSingularJoin)super.on(restrictions);
    }
}

