/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.EntityType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaCriteriaInsertValues;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaValues;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.ValueBindJpaCriteriaParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.AbstractSqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmConflictClause;
import org.hibernate.query.sqm.tree.insert.SqmValues;

public class SqmInsertValuesStatement<T>
extends AbstractSqmInsertStatement<T>
implements JpaCriteriaInsertValues<T> {
    private @Nullable List<SqmValues> valuesList;

    public SqmInsertValuesStatement(SqmRoot<T> targetRoot, NodeBuilder nodeBuilder) {
        super(targetRoot, SqmQuerySource.HQL, nodeBuilder);
    }

    public SqmInsertValuesStatement(Class<T> targetEntity, NodeBuilder nodeBuilder) {
        super(new SqmRoot(nodeBuilder.getDomainModel().entity(targetEntity), null, false, nodeBuilder), SqmQuerySource.CRITERIA, nodeBuilder);
    }

    private SqmInsertValuesStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target, List<SqmPath<?>> insertionTargetPaths, SqmConflictClause<T> conflictClause, List<SqmValues> valuesList) {
        super(builder, querySource, parameters, cteStatements, target, insertionTargetPaths, conflictClause);
        this.valuesList = valuesList;
    }

    @Override
    public SqmInsertValuesStatement<T> copy(SqmCopyContext context) {
        ArrayList<SqmValues> valuesList;
        SqmInsertValuesStatement existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        if (this.valuesList == null) {
            valuesList = null;
        } else {
            valuesList = new ArrayList<SqmValues>(this.valuesList.size());
            for (SqmValues sqmValues : this.valuesList) {
                valuesList.add(sqmValues.copy(context));
            }
        }
        return context.registerCopy(this, new SqmInsertValuesStatement<T>(this.nodeBuilder(), this.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context), this.copyInsertionTargetPaths(context), this.getConflictClause() == null ? null : ((SqmConflictClause)this.getConflictClause()).copy(context), (List<SqmValues>)valuesList));
    }

    public SqmInsertValuesStatement<T> copyWithoutValues(SqmCopyContext context) {
        return context.registerCopy(this, new SqmInsertValuesStatement<T>(this.nodeBuilder(), this.getQuerySource(), this.copyParameters(context), this.copyCteStatements(context), ((SqmRoot)this.getTarget()).copy(context), this.copyInsertionTargetPaths(context), this.getConflictClause() == null ? null : ((SqmConflictClause)this.getConflictClause()).copy(context), null));
    }

    public List<SqmValues> getValuesList() {
        return this.valuesList == null ? Collections.emptyList() : Collections.unmodifiableList(this.valuesList);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitInsertValuesStatement(this);
    }

    @Override
    public <U> Subquery<U> subquery(EntityType<U> type) {
        throw new UnsupportedOperationException("INSERT query cannot be sub-query");
    }

    @Override
    public JpaPredicate getRestriction() {
        return null;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        assert (this.getQuerySource() == SqmQuerySource.CRITERIA);
        return this.getSqmParameters().stream().filter(parameterExpression -> !(parameterExpression instanceof ValueBindJpaCriteriaParameter)).collect(Collectors.toSet());
    }

    @Override
    public SqmInsertValuesStatement<T> setInsertionTargetPaths(Path<?> ... insertionTargetPaths) {
        super.setInsertionTargetPaths((Path[])insertionTargetPaths);
        return this;
    }

    @Override
    public SqmInsertValuesStatement<T> setInsertionTargetPaths(List<? extends Path<?>> insertionTargetPaths) {
        super.setInsertionTargetPaths((List)insertionTargetPaths);
        return this;
    }

    @Override
    public SqmInsertValuesStatement<T> values(JpaValues ... values) {
        return this.values(Arrays.asList(values));
    }

    @Override
    public SqmInsertValuesStatement<T> values(List<? extends JpaValues> values) {
        this.valuesList = values;
        return this;
    }

    @Override
    public SqmInsertValuesStatement<T> onConflict(JpaConflictClause<T> conflictClause) {
        super.onConflict(conflictClause);
        return this;
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        assert (this.valuesList != null);
        super.appendHqlString(sb);
        sb.append(" values (");
        SqmInsertValuesStatement.appendValues(this.valuesList.get(0), sb);
        for (int i = 1; i < this.valuesList.size(); ++i) {
            sb.append(", ");
            SqmInsertValuesStatement.appendValues(this.valuesList.get(i), sb);
        }
        sb.append(')');
        JpaConflictClause conflictClause = this.getConflictClause();
        if (conflictClause != null) {
            ((SqmConflictClause)conflictClause).appendHqlString(sb);
        }
    }

    private static void appendValues(SqmValues sqmValues, StringBuilder sb) {
        List<SqmExpression<?>> expressions = sqmValues.getExpressions();
        sb.append('(');
        expressions.get(0).appendHqlString(sb);
        for (int i = 1; i < expressions.size(); ++i) {
            sb.append(", ");
            expressions.get(i).appendHqlString(sb);
        }
        sb.append(')');
    }
}

