/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hibernate.CacheMode;
import org.hibernate.LockOptions;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.TupleTransformer;
import org.hibernate.sql.exec.SqlExecLogger;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.jdbc.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.ResultSetAccess;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, R> T executeQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        PersistenceContext persistenceContext = executionContext.getSession().getPersistenceContext();
        boolean defaultReadOnlyOrig = persistenceContext.isDefaultReadOnly();
        Boolean readOnly = executionContext.getQueryOptions().isReadOnly();
        if (readOnly != null) {
            persistenceContext.setDefaultReadOnly(readOnly);
        }
        try {
            T t = this.doExecuteQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, domainResultType, statementCreator, resultsConsumer);
            return t;
        }
        finally {
            if (readOnly != null) {
                persistenceContext.setDefaultReadOnly(defaultReadOnlyOrig);
            }
        }
    }

    private <T, R> T doExecuteQuery(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, final ExecutionContext executionContext, RowTransformer<R> rowTransformer, Class<R> domainResultType, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        boolean stats;
        DeferredResultSetAccess deferredResultSetAccess = new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator);
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(executionContext.getQueryIdentifier(deferredResultSetAccess.getFinalSql()), jdbcSelect, resultsConsumer.canResultsBeCached(), executionContext, deferredResultSetAccess);
        if (rowTransformer == null) {
            TupleTransformer<?> tupleTransformer = executionContext.getQueryOptions().getTupleTransformer();
            if (tupleTransformer == null) {
                rowTransformer = RowTransformerStandardImpl.instance();
            } else {
                List<DomainResult<?>> domainResults = jdbcValues.getValuesMapping().getDomainResults();
                String[] aliases = new String[domainResults.size()];
                for (int i = 0; i < domainResults.size(); ++i) {
                    aliases[i] = domainResults.get(i).getResultVariable();
                }
                rowTransformer = new RowTransformerTupleTransformerAdapter(aliases, tupleTransformer);
            }
        }
        SharedSessionContractImplementor session = executionContext.getSession();
        long startTime = 0L;
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (executionContext.hasQueryExecutionToBeAddedToStatistics() && jdbcValues instanceof JdbcValuesResultSetImpl) {
            stats = statistics.isStatisticsEnabled();
            if (stats) {
                startTime = System.nanoTime();
            }
        } else {
            stats = false;
        }
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return executionContext.getEntityInstance();
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Object getEffectiveOptionalId() {
                return executionContext.getEntityId();
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl valuesProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
        RowReader<R> rowReader = ResultsHelper.createRowReader(executionContext, deferredResultSetAccess.usesFollowOnLocking() ? LockOptions.NONE : executionContext.getQueryOptions().getLockOptions(), rowTransformer, domainResultType, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(valuesProcessingState, executionContext, rowReader, jdbcValues);
        rowReader.getInitializersList().startLoading(rowProcessingState);
        T result = resultsConsumer.consume(jdbcValues, session, processingOptions, valuesProcessingState, rowProcessingState, rowReader);
        if (stats) {
            long endTime = System.nanoTime();
            long milliseconds = TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
            statistics.queryExecuted(executionContext.getQueryIdentifier(jdbcSelect.getSqlString()), this.getResultSize(result), milliseconds);
        }
        return result;
    }

    private <T> int getResultSize(T result) {
        if (result instanceof List) {
            return ((List)result).size();
        }
        return -1;
    }

    public JdbcValues resolveJdbcValuesSource(String queryIdentifier, JdbcOperationQuerySelect jdbcSelect, boolean canBeCached, ExecutionContext executionContext, ResultSetAccess resultSetAccess) {
        List<?> cachedResults;
        QueryKey queryResultsCacheKey;
        boolean cacheable;
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        boolean queryCacheEnabled = factory.getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        JdbcValuesMappingProducer mappingProducer = jdbcSelect.getJdbcValuesMappingProducer();
        boolean bl = cacheable = queryCacheEnabled && canBeCached && executionContext.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
        if (cacheable && cacheMode.isGetEnabled()) {
            SqlExecLogger.SQL_EXEC_LOGGER.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", cacheMode.name());
            Set<String> querySpaces = jdbcSelect.getAffectedTableNames();
            if (querySpaces == null || querySpaces.size() == 0) {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("Unexpected querySpaces is empty", new Object[0]);
            } else {
                SqlExecLogger.SQL_EXEC_LOGGER.tracef("querySpaces is `%s`", querySpaces);
            }
            QueryResultsCache queryCache = factory.getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSqlString(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session);
            cachedResults = queryCache.get(queryResultsCacheKey, querySpaces, session);
            StatisticsImplementor statistics = factory.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                if (cachedResults == null) {
                    statistics.queryCacheMiss(queryIdentifier, queryCache.getRegion().getName());
                } else {
                    statistics.queryCacheHit(queryIdentifier, queryCache.getRegion().getName());
                }
            }
        } else {
            SqlExecLogger.SQL_EXEC_LOGGER.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", queryCacheEnabled, cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = cacheable && cacheMode.isPutEnabled() ? QueryKey.from(jdbcSelect.getSqlString(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), session) : null;
        }
        if (cachedResults == null) {
            JdbcValuesMetadata metadataForCache;
            JdbcValuesMapping jdbcValuesMapping;
            if (queryResultsCacheKey == null) {
                jdbcValuesMapping = mappingProducer.resolve(resultSetAccess, session.getLoadQueryInfluencers(), factory);
                metadataForCache = null;
            } else {
                CapturingJdbcValuesMetadata capturingMetadata = new CapturingJdbcValuesMetadata(resultSetAccess);
                jdbcValuesMapping = mappingProducer.resolve(capturingMetadata, session.getLoadQueryInfluencers(), factory);
                metadataForCache = capturingMetadata.resolveMetadataForCache();
            }
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, queryIdentifier, executionContext.getQueryOptions(), jdbcValuesMapping, metadataForCache, executionContext);
        }
        JdbcValuesMapping jdbcValuesMapping = cachedResults.isEmpty() || !(cachedResults.get(0) instanceof JdbcValuesMetadata) ? mappingProducer.resolve(resultSetAccess, session.getLoadQueryInfluencers(), factory) : mappingProducer.resolve((JdbcValuesMetadata)cachedResults.get(0), session.getLoadQueryInfluencers(), factory);
        return new JdbcValuesCacheHit(cachedResults, jdbcValuesMapping);
    }

    public static class CapturingJdbcValuesMetadata
    implements JdbcValuesMetadata {
        private final ResultSetAccess resultSetAccess;
        private String[] columnNames;
        private BasicType<?>[] types;

        public CapturingJdbcValuesMetadata(ResultSetAccess resultSetAccess) {
            this.resultSetAccess = resultSetAccess;
        }

        private void initializeArrays() {
            int columnCount = this.resultSetAccess.getColumnCount();
            this.columnNames = new String[columnCount];
            this.types = new BasicType[columnCount];
        }

        @Override
        public int getColumnCount() {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                position = this.resultSetAccess.resolveColumnPosition(columnName);
                this.columnNames[position - 1] = columnName;
            } else {
                position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
                if (position == 0) {
                    position = this.resultSetAccess.resolveColumnPosition(columnName);
                    this.columnNames[position - 1] = columnName;
                }
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name;
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            if (this.columnNames == null) {
                this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
            } else {
                name = this.columnNames[position - 1];
                if (name == null) {
                    this.columnNames[position - 1] = name = this.resultSetAccess.resolveColumnName(position);
                }
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            if (this.columnNames == null) {
                this.initializeArrays();
            }
            BasicType<J> basicType = this.resultSetAccess.resolveType(position, explicitJavaType, typeConfiguration);
            this.types[position - 1] = basicType;
            return basicType;
        }

        public JdbcValuesMetadata resolveMetadataForCache() {
            if (this.columnNames == null) {
                return null;
            }
            return new CachedJdbcValuesMetadata(this.columnNames, this.types);
        }
    }

    private static class CachedJdbcValuesMetadata
    implements JdbcValuesMetadata,
    Serializable {
        private final String[] columnNames;
        private final BasicType<?>[] types;

        public CachedJdbcValuesMetadata(String[] columnNames, BasicType<?>[] types) {
            this.columnNames = columnNames;
            this.types = types;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int resolveColumnPosition(String columnName) {
            int position = ArrayHelper.indexOf(this.columnNames, columnName) + 1;
            if (position == 0) {
                throw new IllegalStateException("Unexpected resolving of unavailable column: " + columnName);
            }
            return position;
        }

        @Override
        public String resolveColumnName(int position) {
            String name = this.columnNames[position - 1];
            if (name == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            return name;
        }

        @Override
        public <J> BasicType<J> resolveType(int position, JavaType<J> explicitJavaType, TypeConfiguration typeConfiguration) {
            BasicType<?> type = this.types[position - 1];
            if (type == null) {
                throw new IllegalStateException("Unexpected resolving of unavailable column at position: " + position);
            }
            if (explicitJavaType == null || type.getJavaTypeDescriptor() == explicitJavaType) {
                return type;
            }
            return typeConfiguration.getBasicTypeRegistry().resolve(explicitJavaType, type.getJdbcType());
        }
    }
}

