/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.BitSet;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

public abstract class AbstractNonJoinedEntityFetch
implements EntityFetch,
InitializerProducer<AbstractNonJoinedEntityFetch> {
    private final NavigablePath navigablePath;
    private final ToOneAttributeMapping fetchedModelPart;
    private final FetchParent fetchParent;
    private final DomainResult<?> keyResult;
    private final BasicFetch<?> discriminatorFetch;
    private final boolean selectByUniqueKey;

    public AbstractNonJoinedEntityFetch(NavigablePath navigablePath, ToOneAttributeMapping fetchedModelPart, FetchParent fetchParent, DomainResult<?> keyResult, boolean selectDiscriminator, boolean selectByUniqueKey, DomainResultCreationState creationState) {
        this.navigablePath = navigablePath;
        this.fetchedModelPart = fetchedModelPart;
        this.fetchParent = fetchParent;
        this.keyResult = keyResult;
        this.discriminatorFetch = selectDiscriminator ? creationState.visitDiscriminatorFetch(this) : null;
        this.selectByUniqueKey = selectByUniqueKey;
    }

    protected AbstractNonJoinedEntityFetch(NavigablePath navigablePath, ToOneAttributeMapping fetchedModelPart, FetchParent fetchParent, DomainResult<?> keyResult, BasicFetch<?> discriminatorFetch, boolean selectByUniqueKey) {
        this.navigablePath = navigablePath;
        this.fetchedModelPart = fetchedModelPart;
        this.fetchParent = fetchParent;
        this.keyResult = keyResult;
        this.discriminatorFetch = discriminatorFetch;
        this.selectByUniqueKey = selectByUniqueKey;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ToOneAttributeMapping getFetchedMapping() {
        return this.fetchedModelPart;
    }

    @Override
    public ToOneAttributeMapping getEntityValuedModelPart() {
        return this.fetchedModelPart;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public ImmutableFetchList getFetches() {
        return ImmutableFetchList.EMPTY;
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return null;
    }

    @Override
    public boolean hasJoinFetches() {
        return false;
    }

    @Override
    public boolean containsCollectionFetches() {
        return false;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        if (this.keyResult != null) {
            this.keyResult.collectValueIndexesToCache(valueIndexes);
        }
        if (this.discriminatorFetch != null) {
            this.discriminatorFetch.collectValueIndexesToCache(valueIndexes);
        }
    }

    @Override
    public EntityMappingType getReferencedMappingType() {
        return this.fetchedModelPart.getEntityMappingType();
    }

    public DomainResult<?> getKeyResult() {
        return this.keyResult;
    }

    public BasicFetch<?> getDiscriminatorFetch() {
        return this.discriminatorFetch;
    }

    public boolean isSelectByUniqueKey() {
        return this.selectByUniqueKey;
    }

    @Override
    public DomainResultAssembler<?> createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        EntityInitializer entityInitializer = creationState.resolveInitializer(this, parentAccess, this).asEntityInitializer();
        assert (entityInitializer != null);
        return this.buildEntityAssembler(entityInitializer);
    }

    public EntityInitializer createInitializer(AbstractNonJoinedEntityFetch resultGraphNode, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer(parentAccess, creationState);
    }

    @Override
    public abstract EntityInitializer createInitializer(FetchParentAccess var1, AssemblerCreationState var2);

    protected EntityAssembler buildEntityAssembler(EntityInitializer entityInitializer) {
        return new EntityAssembler(this.getFetchedMapping().getJavaType(), entityInitializer);
    }
}

