/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManagerFactory;
import java.io.Closeable;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.naming.Referenceable;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.graph.RootGraph;
import org.hibernate.internal.TransactionManagement;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.relational.SchemaManager;
import org.hibernate.stat.Statistics;

public interface SessionFactory
extends EntityManagerFactory,
Referenceable,
Serializable,
Closeable {
    public String getJndiName();

    public SessionBuilder withOptions();

    public Session openSession() throws HibernateException;

    public Session getCurrentSession() throws HibernateException;

    public StatelessSessionBuilder withStatelessOptions();

    public StatelessSession openStatelessSession();

    public StatelessSession openStatelessSession(Connection var1);

    default public void inSession(Consumer<Session> action) {
        try (Session session = this.openSession();){
            action.accept(session);
        }
    }

    default public void inStatelessSession(Consumer<StatelessSession> action) {
        try (StatelessSession session = this.openStatelessSession();){
            action.accept(session);
        }
    }

    default public void inTransaction(Consumer<Session> action) {
        this.inSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    default public void inStatelessTransaction(Consumer<StatelessSession> action) {
        this.inStatelessSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    default public <R> R fromSession(Function<Session, R> action) {
        try (Session session = this.openSession();){
            R r = action.apply(session);
            return r;
        }
    }

    default public <R> R fromStatelessSession(Function<StatelessSession, R> action) {
        try (StatelessSession session = this.openStatelessSession();){
            R r = action.apply(session);
            return r;
        }
    }

    default public <R> R fromTransaction(Function<Session, R> action) {
        return (R)this.fromSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    default public <R> R fromStatelessTransaction(Function<StatelessSession, R> action) {
        return (R)this.fromStatelessSession(session -> TransactionManagement.manageTransaction(session, session.beginTransaction(), action));
    }

    public Statistics getStatistics();

    public SchemaManager getSchemaManager();

    public HibernateCriteriaBuilder getCriteriaBuilder();

    @Override
    public void close() throws HibernateException;

    public boolean isClosed();

    public Cache getCache();

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> var1);

    public RootGraph<?> findEntityGraphByName(String var1);

    public Set<String> getDefinedFilterNames();

    @Deprecated(since="6.2")
    public FilterDefinition getFilterDefinition(String var1) throws HibernateException;

    public Set<String> getDefinedFetchProfileNames();

    default public boolean containsFetchProfileDefinition(String name) {
        return this.getDefinedFilterNames().contains(name);
    }

    @Deprecated(since="6.2")
    public SessionFactoryOptions getSessionFactoryOptions();
}

