/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import jakarta.persistence.ConstraintMode;
import jakarta.persistence.FetchType;
import jakarta.persistence.TemporalType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.Discriminatable;
import org.hibernate.boot.jaxb.hbm.spi.EntityInfo;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmAnyAssociationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmArrayType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmAuxiliaryDatabaseObjectType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBagCollectionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCacheInclusionEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmClassRenameType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmCompositeKeyManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmConfigParameterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDynamicComponentType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchProfileType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchStyleEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchStyleWithSubselectEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterAliasMappingType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterParameterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFilterType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmGeneratorSpecificationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdBagCollectionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdentifierGeneratorDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIndexType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmJoinedSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmKeyType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyWithExtraEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmLazyWithNoProxyEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmListIndexType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmListType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToAnyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToManyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmManyToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmMapKeyBasicType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmMapType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedNativeQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryPropertyReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNotFoundEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOnDeleteEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOneToManyCollectionElementType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOneToOneType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmOuterJoinEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPolymorphismEnum;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPrimitiveArrayType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmPropertiesType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmQueryParamType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmResultSetMappingType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSecondaryTableType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSetType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSimpleIdType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSubclassEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSynchronizeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmTimestampAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmToolingHintContainer;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmUnionSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmVersionAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.PluralAttributeInfo;
import org.hibernate.boot.jaxb.hbm.spi.ResultSetMappingContainer;
import org.hibernate.boot.jaxb.hbm.spi.ToolingHintContainer;
import org.hibernate.boot.jaxb.hbm.transform.ColumnAndFormulaSource;
import org.hibernate.boot.jaxb.hbm.transform.ColumnAndFormulaTarget;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaults;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsBasicImpl;
import org.hibernate.boot.jaxb.hbm.transform.ColumnDefaultsInsertableNonUpdateableImpl;
import org.hibernate.boot.jaxb.hbm.transform.HbmTransformationLogging;
import org.hibernate.boot.jaxb.hbm.transform.SourceColumnAdapter;
import org.hibernate.boot.jaxb.hbm.transform.SourceColumnAdapterJaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapter;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapterJaxbColumn;
import org.hibernate.boot.jaxb.hbm.transform.TargetColumnAdapterJaxbJoinColumn;
import org.hibernate.boot.jaxb.hbm.transform.TransformationPreprocessor;
import org.hibernate.boot.jaxb.hbm.transform.TransformationState;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyDiscriminatorValueMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingDiscriminatorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCascadeTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCheckConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCustomSqlImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDatabaseObjectImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDatabaseObjectScopeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorFormulaImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmptyTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFetchProfileImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFieldResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterDefImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbForeignKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGeneratedValueImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGenericIdGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbHbmFilterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbHqlImportImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdClassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMapKeyColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNaturalIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToOneImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOrderColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitMetadataImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralFetchModeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPrimaryKeyJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPropertyRefImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryParamTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSecondaryTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSingularAssociationAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSingularFetchModeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSqlResultSetMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSynchronizedTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTransientImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbVersionImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.jboss.logging.Logger;

public class HbmXmlTransformer {
    private final Origin origin;
    private final JaxbHbmHibernateMapping hbmXmlMapping;
    private final JaxbEntityMappingsImpl ormRoot;
    private final TransformationState transformationState;
    private final UnsupportedFeatureHandling unsupportedFeatureHandling;
    private final Map<String, JaxbEmbeddableImpl> jaxbEmbeddableByClassName = new HashMap<String, JaxbEmbeddableImpl>();
    private String currentTableName = "";
    private int counter = 1;

    public static List<Binding<JaxbEntityMappingsImpl>> transform(List<Binding<JaxbHbmHibernateMapping>> hbmXmlBindings, UnsupportedFeatureHandling unsupportedFeatureHandling) {
        TransformationState transformationState = new TransformationState(hbmXmlBindings);
        TransformationPreprocessor.preprocessHbmXml(hbmXmlBindings, transformationState);
        for (int i = 0; i < hbmXmlBindings.size(); ++i) {
            Binding<JaxbHbmHibernateMapping> hbmJaxbBinding = hbmXmlBindings.get(i);
            Binding<JaxbEntityMappingsImpl> mappingJaxbBinding = transformationState.getMappingBindings().get(i);
            HbmXmlTransformer hbmXmlTransformer = new HbmXmlTransformer(hbmJaxbBinding, mappingJaxbBinding, transformationState, unsupportedFeatureHandling);
            hbmXmlTransformer.doTransform();
        }
        return transformationState.getMappingBindings();
    }

    private HbmXmlTransformer(Binding<JaxbHbmHibernateMapping> hbmJaxbBinding, Binding<JaxbEntityMappingsImpl> mappingJaxbBinding, TransformationState transformationState, UnsupportedFeatureHandling unsupportedFeatureHandling) {
        this.origin = hbmJaxbBinding.getOrigin();
        this.hbmXmlMapping = hbmJaxbBinding.getRoot();
        this.ormRoot = mappingJaxbBinding.getRoot();
        this.transformationState = transformationState;
        this.unsupportedFeatureHandling = unsupportedFeatureHandling;
    }

    private void doTransform() {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.tracef("Starting hbm.xml transformation - `%s`", (Object)this.origin);
        JaxbPersistenceUnitMetadataImpl metadata = new JaxbPersistenceUnitMetadataImpl();
        this.ormRoot.setPersistenceUnitMetadata(metadata);
        this.transfer(this.hbmXmlMapping::getPackage, this.ormRoot::setPackage);
        this.transfer(this.hbmXmlMapping::getCatalog, this.ormRoot::setCatalog);
        this.transfer(this.hbmXmlMapping::getSchema, this.ormRoot::setSchema);
        this.transfer(this.hbmXmlMapping::getDefaultAccess, this.ormRoot::setAttributeAccessor);
        this.transfer(this.hbmXmlMapping::getDefaultCascade, this.ormRoot::setDefaultCascade);
        this.transfer(this.hbmXmlMapping::isDefaultLazy, this.ormRoot::setDefaultLazy);
        this.transferIdentifierGenerators();
        this.transferTypeDefs();
        this.transferFilterDefinitions();
        this.transferImports();
        this.transferEntities();
        this.transferResultSetMappings();
        this.transferNamedQueries();
        this.transferNamedNativeQueries();
        this.transferFetchProfiles();
        this.transferDatabaseObjects();
        if (HbmTransformationLogging.TRANSFORMATION_LOGGER.isDebugEnabled()) {
            HbmXmlTransformer.dumpTransformed(this.origin, this.ormRoot);
        }
    }

    private static void dumpTransformed(Origin origin, JaxbEntityMappingsImpl ormRoot) {
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{JaxbEntityMappingsImpl.class});
            Marshaller marshaller = ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal((Object)ormRoot, (Writer)stringWriter);
            HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Transformed hbm.xml (%s):\n%s", (Object)origin, (Object)stringWriter.toString());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void transfer(Supplier<T> source, Consumer<T> target) {
        T value = source.get();
        if (value != null) {
            target.accept(value);
        }
    }

    private void handleUnsupportedContent(String description) {
        this.handleUnsupported("Transformation of hbm.xml `%s` encountered unsupported content : %s", this.origin.toString(), description);
    }

    private void handleUnsupported(String message, Object ... messageArgs) {
        this.handleUnsupported(null, message, messageArgs);
    }

    private void handleUnsupported(PickHandler pickHandler, String message, Object ... messageArgs) {
        switch (this.unsupportedFeatureHandling) {
            case ERROR: {
                throw new UnsupportedOperationException(String.format(Locale.ROOT, message, messageArgs));
            }
            case PICK: {
                if (pickHandler == null) break;
                pickHandler.handlePick(message, messageArgs);
                break;
            }
            case IGNORE: {
                HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf(message, messageArgs);
                break;
            }
            case WARN: {
                HbmTransformationLogging.TRANSFORMATION_LOGGER.warnf(message, messageArgs);
            }
        }
    }

    private void transferTypeDefs() {
        if (this.hbmXmlMapping.getTypedef().isEmpty()) {
            return;
        }
        this.handleUnsupported("Transformation of type-def mapping not supported - `%s`", this.origin);
    }

    private void transferIdentifierGenerators() {
        if (this.hbmXmlMapping.getIdentifierGenerator().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of identifier-generator mappings in `%s`", this.origin);
        for (JaxbHbmIdentifierGeneratorDefinitionType hbmGenerator : this.hbmXmlMapping.getIdentifierGenerator()) {
            JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of identifier-generator mapping `%s` - `%s`", hbmGenerator.getName(), this.origin);
            JaxbGenericIdGeneratorImpl generatorDef = new JaxbGenericIdGeneratorImpl();
            this.ormRoot.getGenericGenerators().add(generatorDef);
            generatorDef.setName(hbmGenerator.getName());
            generatorDef.setClazz(hbmGenerator.getClazz());
        }
    }

    private void transferFilterDefinitions() {
        if (this.hbmXmlMapping.getFilterDef().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of filter-def mappings in `%s`", this.origin);
        for (JaxbHbmFilterDefinitionType hbmFilterDef : this.hbmXmlMapping.getFilterDef()) {
            JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of filter-def mapping `%s` - `%s`", hbmFilterDef.getName(), this.origin);
            JaxbFilterDefImpl filterDef = new JaxbFilterDefImpl();
            this.ormRoot.getFilterDefinitions().add(filterDef);
            filterDef.setName(hbmFilterDef.getName());
            boolean foundCondition = false;
            for (Serializable content : hbmFilterDef.getContent()) {
                if (content instanceof String) {
                    String condition = ((String)((Object)content)).trim();
                    if (StringHelper.isEmpty(condition)) continue;
                    foundCondition = true;
                    filterDef.setDefaultCondition(condition);
                    continue;
                }
                JaxbHbmFilterParameterType hbmFilterParam = (JaxbHbmFilterParameterType)((JAXBElement)content).getValue();
                JaxbFilterDefImpl.JaxbFilterParamImpl param = new JaxbFilterDefImpl.JaxbFilterParamImpl();
                filterDef.getFilterParams().add(param);
                param.setName(hbmFilterParam.getParameterName());
                param.setType(hbmFilterParam.getParameterValueTypeName());
            }
            if (foundCondition) continue;
            filterDef.setDefaultCondition(hbmFilterDef.getCondition());
        }
    }

    private void transferImports() {
        if (this.hbmXmlMapping.getImport().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of import mappings - `%s`", this.origin);
        for (JaxbHbmClassRenameType hbmImport : this.hbmXmlMapping.getImport()) {
            JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of import `%s` -> `%s` - `%s`", hbmImport.getClazz(), hbmImport.getRename(), this.origin);
            JaxbHqlImportImpl ormImport = new JaxbHqlImportImpl();
            this.ormRoot.getHqlImports().add(ormImport);
            ormImport.setClazz(hbmImport.getClazz());
            ormImport.setRename(hbmImport.getRename());
        }
    }

    private void transferResultSetMappings() {
        if (this.hbmXmlMapping.getResultset().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of resultset mappings - `%s`", this.origin);
        for (JaxbHbmResultSetMappingType hbmResultSet : this.hbmXmlMapping.getResultset()) {
            JaxbSqlResultSetMappingImpl mapping = this.transformResultSetMapping(null, hbmResultSet);
            this.ormRoot.getSqlResultSetMappings().add(mapping);
        }
    }

    private JaxbSqlResultSetMappingImpl transformResultSetMapping(String namePrefix, JaxbHbmResultSetMappingType hbmResultSet) {
        String resultMappingName = namePrefix == null ? hbmResultSet.getName() : namePrefix + "." + hbmResultSet.getName();
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of resultset mapping `{}` in `{}`", resultMappingName, this.origin);
        JaxbSqlResultSetMappingImpl mapping = new JaxbSqlResultSetMappingImpl();
        mapping.setName(resultMappingName);
        mapping.setDescription("SQL ResultSet mapping - " + resultMappingName);
        for (Serializable hbmReturn : hbmResultSet.getValueMappingSources()) {
            if (hbmReturn instanceof JaxbHbmNativeQueryReturnType) {
                mapping.getEntityResult().add(this.transferEntityReturnElement(resultMappingName, (JaxbHbmNativeQueryReturnType)hbmReturn));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryScalarReturnType) {
                mapping.getColumnResult().add(this.transferScalarReturnElement(resultMappingName, (JaxbHbmNativeQueryScalarReturnType)hbmReturn));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryJoinReturnType) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-join/> element, which is not supported for transformation", resultMappingName));
                continue;
            }
            if (hbmReturn instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <collection-load/> element, which is not supported for transformation", resultMappingName));
                continue;
            }
            this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained an unexpected element type", resultMappingName));
        }
        return mapping;
    }

    private JaxbEntityResultImpl transferEntityReturnElement(String resultMappingName, JaxbHbmNativeQueryReturnType hbmReturn) {
        JaxbEntityResultImpl entityResult = new JaxbEntityResultImpl();
        entityResult.setEntityClass(this.getFullyQualifiedClassName(hbmReturn.getClazz()));
        for (JaxbHbmNativeQueryPropertyReturnType propertyReturn : hbmReturn.getReturnProperty()) {
            JaxbFieldResultImpl field = new JaxbFieldResultImpl();
            ArrayList<String> columns = new ArrayList<String>();
            if (!StringHelper.isEmpty(propertyReturn.getColumn())) {
                columns.add(propertyReturn.getColumn());
            }
            for (JaxbHbmNativeQueryPropertyReturnType.JaxbHbmReturnColumn returnColumn : propertyReturn.getReturnColumn()) {
                columns.add(returnColumn.getName());
            }
            if (columns.size() > 1) {
                this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-property name='%s'/> element declaring multiple 1 column mapping, which is not supported for transformation;skipping that return-property mapping", resultMappingName, propertyReturn.getName()));
                continue;
            }
            field.setColumn((String)columns.get(0));
            field.setName(propertyReturn.getName());
            entityResult.getFieldResult().add(field);
        }
        return entityResult;
    }

    private JaxbColumnResultImpl transferScalarReturnElement(String resultMappingName, JaxbHbmNativeQueryScalarReturnType hbmReturn) {
        JaxbColumnResultImpl columnResult = new JaxbColumnResultImpl();
        columnResult.setName(hbmReturn.getColumn());
        columnResult.setClazz(hbmReturn.getType());
        this.handleUnsupportedContent(String.format("SQL ResultSet mapping [name=%s] contained a <return-scalar column='%s'/> element; transforming type->class likely requires manual adjustment", resultMappingName, hbmReturn.getColumn()));
        return columnResult;
    }

    private void transferFetchProfiles() {
        if (this.hbmXmlMapping.getFetchProfile().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of fetch-profile mappings in `{}`", this.origin);
        for (JaxbHbmFetchProfileType hbmFetchProfile : this.hbmXmlMapping.getFetchProfile()) {
            this.ormRoot.getFetchProfiles().add(this.transferFetchProfile(hbmFetchProfile));
        }
    }

    private JaxbFetchProfileImpl transferFetchProfile(JaxbHbmFetchProfileType hbmFetchProfile) {
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of fetch-profile mapping `{}` in `{}`", hbmFetchProfile.getName(), this.origin);
        JaxbFetchProfileImpl fetchProfile = new JaxbFetchProfileImpl();
        fetchProfile.setName(hbmFetchProfile.getName());
        for (JaxbHbmFetchProfileType.JaxbHbmFetch hbmFetch : hbmFetchProfile.getFetch()) {
            JaxbFetchProfileImpl.JaxbFetchImpl fetch = new JaxbFetchProfileImpl.JaxbFetchImpl();
            fetchProfile.getFetch().add(fetch);
            fetch.setEntity(hbmFetch.getEntity());
            fetch.setAssociation(hbmFetch.getAssociation());
            fetch.setStyle(hbmFetch.getStyle().value());
        }
        return fetchProfile;
    }

    private void transferNamedQueries() {
        if (this.hbmXmlMapping.getQuery().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of named-query mappings in `{}`", this.origin);
        for (JaxbHbmNamedQueryType hbmQuery : this.hbmXmlMapping.getQuery()) {
            this.ormRoot.getNamedQueries().add(this.transformNamedQuery(hbmQuery, hbmQuery.getName()));
        }
    }

    private JaxbNamedQueryImpl transformNamedQuery(JaxbHbmNamedQueryType hbmQuery, String name) {
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of named-query mapping `{}` in `{}`", name, this.origin);
        JaxbNamedQueryImpl query = new JaxbNamedQueryImpl();
        query.setName(name);
        query.setCacheable(hbmQuery.isCacheable());
        query.setCacheMode(hbmQuery.getCacheMode());
        query.setCacheRegion(hbmQuery.getCacheRegion());
        query.setComment(hbmQuery.getComment());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setFlushMode(hbmQuery.getFlushMode());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setReadOnly(hbmQuery.isReadOnly());
        query.setTimeout(hbmQuery.getTimeout());
        for (Serializable content : hbmQuery.getContent()) {
            if (content instanceof String) {
                String qryString = (String)((Object)content);
                qryString = qryString.trim();
                query.setQuery(qryString);
                continue;
            }
            JAXBElement element = (JAXBElement)content;
            JaxbHbmQueryParamType hbmQueryParam = (JaxbHbmQueryParamType)element.getValue();
            JaxbQueryParamTypeImpl queryParam = new JaxbQueryParamTypeImpl();
            query.getQueryParam().add(queryParam);
            queryParam.setName(hbmQueryParam.getName());
            queryParam.setType(hbmQueryParam.getType());
        }
        return query;
    }

    private void transferNamedNativeQueries() {
        if (this.hbmXmlMapping.getSqlQuery().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of (named) query mappings in `{}`", this.origin);
        for (JaxbHbmNamedNativeQueryType hbmQuery : this.hbmXmlMapping.getSqlQuery()) {
            this.ormRoot.getNamedNativeQueries().add(this.transformNamedNativeQuery(hbmQuery, hbmQuery.getName()));
        }
    }

    private JaxbNamedNativeQueryImpl transformNamedNativeQuery(JaxbHbmNamedNativeQueryType hbmQuery, String queryName) {
        JaxbLogger.JAXB_LOGGER.debugf("Starting transformation of (named) query mapping `{}` in `{}`", queryName, this.origin);
        String implicitResultSetMappingName = queryName + "-implicitResultSetMapping";
        JaxbNamedNativeQueryImpl query = new JaxbNamedNativeQueryImpl();
        query.setName(queryName);
        query.setCacheable(hbmQuery.isCacheable());
        query.setCacheMode(hbmQuery.getCacheMode());
        query.setCacheRegion(hbmQuery.getCacheRegion());
        query.setComment(hbmQuery.getComment());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setFlushMode(hbmQuery.getFlushMode());
        query.setFetchSize(hbmQuery.getFetchSize());
        query.setReadOnly(hbmQuery.isReadOnly());
        query.setTimeout(hbmQuery.getTimeout());
        JaxbSqlResultSetMappingImpl implicitResultSetMapping = null;
        for (Serializable content : hbmQuery.getContent()) {
            if (content instanceof String) {
                String qryString = (String)((Object)content);
                qryString = qryString.trim();
                query.setQuery(qryString);
                continue;
            }
            if (!(content instanceof JAXBElement)) continue;
            Object element = ((JAXBElement)content).getValue();
            if (element instanceof JaxbHbmQueryParamType) {
                JaxbHbmQueryParamType hbmQueryParam = (JaxbHbmQueryParamType)element;
                JaxbQueryParamTypeImpl queryParam = new JaxbQueryParamTypeImpl();
                queryParam.setName(hbmQueryParam.getName());
                queryParam.setType(hbmQueryParam.getType());
                query.getQueryParam().add(queryParam);
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryScalarReturnType) {
                if (implicitResultSetMapping == null) {
                    implicitResultSetMapping = new JaxbSqlResultSetMappingImpl();
                    implicitResultSetMapping.setName(implicitResultSetMappingName);
                    implicitResultSetMapping.setDescription(String.format(Locale.ROOT, "ResultSet mapping implicitly created for named native query `%s` during hbm.xml transformation", queryName));
                    this.ormRoot.getSqlResultSetMappings().add(implicitResultSetMapping);
                }
                implicitResultSetMapping.getColumnResult().add(this.transferScalarReturnElement(implicitResultSetMappingName, (JaxbHbmNativeQueryScalarReturnType)element));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryReturnType) {
                if (implicitResultSetMapping == null) {
                    implicitResultSetMapping = new JaxbSqlResultSetMappingImpl();
                    implicitResultSetMapping.setName(implicitResultSetMappingName);
                    implicitResultSetMapping.setDescription(String.format(Locale.ROOT, "ResultSet mapping implicitly created for named native query `%s` during hbm.xml transformation", queryName));
                    this.ormRoot.getSqlResultSetMappings().add(implicitResultSetMapping);
                }
                implicitResultSetMapping.getEntityResult().add(this.transferEntityReturnElement(implicitResultSetMappingName, (JaxbHbmNativeQueryReturnType)element));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
                this.handleUnsupportedContent(String.format("Named native query [name=%s] contained a <collection-load/> element, which is not supported for transformation", queryName));
                continue;
            }
            if (element instanceof JaxbHbmNativeQueryJoinReturnType) {
                this.handleUnsupportedContent(String.format("Named native query [name=%s] contained a <return-join/> element, which is not supported for transformation", queryName));
                continue;
            }
            if (element instanceof JaxbHbmSynchronizeType) {
                JaxbHbmSynchronizeType hbmSynchronize = (JaxbHbmSynchronizeType)element;
                JaxbSynchronizedTableImpl synchronize = new JaxbSynchronizedTableImpl();
                synchronize.setTable(hbmSynchronize.getTable());
                query.getSynchronizations().add(synchronize);
                continue;
            }
            this.handleUnsupportedContent(String.format("Named native query [name=%s] contained an unexpected element type", queryName));
        }
        return query;
    }

    private void transferDatabaseObjects() {
        if (this.hbmXmlMapping.getDatabaseObject().isEmpty()) {
            return;
        }
        JaxbLogger.JAXB_LOGGER.tracef("Starting transformation of database-object mappings in `{}`", this.origin);
        for (JaxbHbmAuxiliaryDatabaseObjectType hbmDatabaseObject : this.hbmXmlMapping.getDatabaseObject()) {
            JaxbDatabaseObjectImpl databaseObject = new JaxbDatabaseObjectImpl();
            this.ormRoot.getDatabaseObjects().add(databaseObject);
            databaseObject.setCreate(hbmDatabaseObject.getCreate());
            databaseObject.setDrop(hbmDatabaseObject.getDrop());
            if (hbmDatabaseObject.getDialectScope().isEmpty()) continue;
            hbmDatabaseObject.getDialectScope().forEach(hbmScope -> {
                JaxbDatabaseObjectScopeImpl scope = new JaxbDatabaseObjectScopeImpl();
                databaseObject.getDialectScopes().add(scope);
                scope.setName(hbmScope.getName());
            });
        }
    }

    private void transferEntities() {
        JaxbEntityImpl entity;
        for (JaxbHbmRootEntityType jaxbHbmRootEntityType : this.hbmXmlMapping.getClazz()) {
            entity = this.transformationState.getEntityXref().get(jaxbHbmRootEntityType);
            this.transferRootEntity(jaxbHbmRootEntityType, entity);
        }
        for (JaxbHbmDiscriminatorSubclassEntityType jaxbHbmDiscriminatorSubclassEntityType : this.hbmXmlMapping.getSubclass()) {
            entity = this.transformationState.getEntityXref().get(jaxbHbmDiscriminatorSubclassEntityType);
            this.transferDiscriminatorSubclass(jaxbHbmDiscriminatorSubclassEntityType, entity);
        }
        for (JaxbHbmJoinedSubclassEntityType jaxbHbmJoinedSubclassEntityType : this.hbmXmlMapping.getJoinedSubclass()) {
            entity = this.transformationState.getEntityXref().get(jaxbHbmJoinedSubclassEntityType);
            this.transferJoinedSubclass(jaxbHbmJoinedSubclassEntityType, entity);
        }
        for (JaxbHbmUnionSubclassEntityType jaxbHbmUnionSubclassEntityType : this.hbmXmlMapping.getUnionSubclass()) {
            entity = this.transformationState.getEntityXref().get(jaxbHbmUnionSubclassEntityType);
            this.transferUnionSubclass(jaxbHbmUnionSubclassEntityType, entity);
        }
    }

    private static String extractEntityName(EntityInfo entityInfo) {
        if (entityInfo.getEntityName() != null) {
            return entityInfo.getEntityName();
        }
        return entityInfo.getName();
    }

    private void transferRootEntity(JaxbHbmRootEntityType hbmClass, JaxbEntityImpl entity) {
        String name;
        JaxbEntityImpl subclassEntity;
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of root entity `%s` - `%s`", (Object)HbmXmlTransformer.extractEntityName(hbmClass), (Object)this.origin);
        this.currentTableName = "";
        this.transferBaseEntityInformation(hbmClass, entity);
        entity.setMutable(hbmClass.isMutable());
        if (hbmClass.getTable() != null) {
            entity.setTable(new JaxbTableImpl());
            this.transfer(hbmClass::getTable, entity.getTable()::setName);
            this.transfer(hbmClass::getCatalog, entity.getTable()::setCatalog);
            this.transfer(hbmClass::getSchema, entity.getTable()::setSchema);
            this.transfer(hbmClass::getComment, entity.getTable()::setComment);
            this.transfer(hbmClass::getCheck, constraint -> {
                JaxbCheckConstraintImpl checkConstraint = new JaxbCheckConstraintImpl();
                checkConstraint.setConstraint((String)constraint);
                entity.getTable().getCheckConstraints().add(checkConstraint);
            });
        } else {
            this.transfer(hbmClass::getSubselect, entity::setTableExpression);
        }
        for (JaxbHbmSynchronizeType jaxbHbmSynchronizeType : hbmClass.getSynchronize()) {
            JaxbSynchronizedTableImpl sync = new JaxbSynchronizedTableImpl();
            sync.setTable(jaxbHbmSynchronizeType.getTable());
            entity.getSynchronizeTables().add(sync);
        }
        if (hbmClass.getLoader() != null) {
            this.handleUnsupported("<loader/> is not supported in mapping.xsd - use <sql-select/> or <hql-select/> instead: ", this.origin);
        }
        if (hbmClass.getSqlInsert() != null) {
            entity.setSqlInsert(new JaxbCustomSqlImpl());
            entity.getSqlInsert().setValue(hbmClass.getSqlInsert().getValue());
            entity.getSqlInsert().setResultCheck(hbmClass.getSqlInsert().getCheck());
            entity.getSqlInsert().setValue(hbmClass.getSqlInsert().getValue());
        }
        if (hbmClass.getSqlUpdate() != null) {
            entity.setSqlUpdate(new JaxbCustomSqlImpl());
            entity.getSqlUpdate().setValue(hbmClass.getSqlUpdate().getValue());
            entity.getSqlUpdate().setResultCheck(hbmClass.getSqlUpdate().getCheck());
            entity.getSqlUpdate().setValue(hbmClass.getSqlUpdate().getValue());
        }
        if (hbmClass.getSqlDelete() != null) {
            entity.setSqlDelete(new JaxbCustomSqlImpl());
            entity.getSqlDelete().setValue(hbmClass.getSqlDelete().getValue());
            entity.getSqlDelete().setResultCheck(hbmClass.getSqlDelete().getCheck());
            entity.getSqlDelete().setValue(hbmClass.getSqlDelete().getValue());
        }
        entity.setRowid(hbmClass.getRowid());
        entity.setSqlRestriction(hbmClass.getWhere());
        if (!hbmClass.getTuplizer().isEmpty()) {
            if (this.unsupportedFeatureHandling == UnsupportedFeatureHandling.ERROR) {
                throw new MappingException("HBM transformation: Tuplizer not supported", this.origin);
            }
            HbmTransformationLogging.TRANSFORMATION_LOGGER.logf(this.unsupportedFeatureHandling == UnsupportedFeatureHandling.WARN ? Logger.Level.WARN : Logger.Level.DEBUG, "Transformation of <tuplizer/> is not supported - `%s`", (Object)this.origin);
            return;
        }
        entity.setOptimisticLocking(hbmClass.getOptimisticLock());
        entity.setDiscriminatorValue(hbmClass.getDiscriminatorValue());
        entity.setPolymorphism(this.convert(hbmClass.getPolymorphism()));
        this.transferDiscriminator(hbmClass, entity);
        this.transferAttributes(hbmClass, entity);
        if (hbmClass.getCache() != null) {
            this.transformEntityCaching(hbmClass, entity);
        }
        for (JaxbHbmNamedQueryType jaxbHbmNamedQueryType : hbmClass.getQuery()) {
            entity.getNamedQueries().add(this.transformNamedQuery(jaxbHbmNamedQueryType, entity.getName() + "." + jaxbHbmNamedQueryType.getName()));
        }
        for (JaxbHbmNamedNativeQueryType jaxbHbmNamedNativeQueryType : hbmClass.getSqlQuery()) {
            entity.getNamedNativeQueries().add(this.transformNamedNativeQuery(jaxbHbmNamedNativeQueryType, entity.getName() + "." + jaxbHbmNamedNativeQueryType.getName()));
        }
        for (JaxbHbmFilterType jaxbHbmFilterType : hbmClass.getFilter()) {
            entity.getFilters().add(this.convert(jaxbHbmFilterType));
        }
        for (JaxbHbmFetchProfileType jaxbHbmFetchProfileType : hbmClass.getFetchProfile()) {
            entity.getFetchProfiles().add(this.transferFetchProfile(jaxbHbmFetchProfileType));
        }
        for (JaxbHbmJoinedSubclassEntityType jaxbHbmJoinedSubclassEntityType : hbmClass.getJoinedSubclass()) {
            subclassEntity = this.transformationState.getEntityXref().get(jaxbHbmJoinedSubclassEntityType);
            this.transferJoinedSubclass(jaxbHbmJoinedSubclassEntityType, subclassEntity);
        }
        for (JaxbHbmUnionSubclassEntityType jaxbHbmUnionSubclassEntityType : hbmClass.getUnionSubclass()) {
            subclassEntity = this.transformationState.getEntityXref().get(jaxbHbmUnionSubclassEntityType);
            this.transferUnionSubclass(jaxbHbmUnionSubclassEntityType, subclassEntity);
        }
        for (JaxbHbmDiscriminatorSubclassEntityType jaxbHbmDiscriminatorSubclassEntityType : hbmClass.getSubclass()) {
            subclassEntity = this.transformationState.getEntityXref().get(jaxbHbmDiscriminatorSubclassEntityType);
            this.transferDiscriminatorSubclass(jaxbHbmDiscriminatorSubclassEntityType, subclassEntity);
        }
        for (JaxbHbmNamedQueryType jaxbHbmNamedQueryType : hbmClass.getQuery()) {
            name = hbmClass.getName() + "." + jaxbHbmNamedQueryType.getName();
            this.ormRoot.getNamedQueries().add(this.transformNamedQuery(jaxbHbmNamedQueryType, name));
        }
        for (JaxbHbmNamedNativeQueryType jaxbHbmNamedNativeQueryType : hbmClass.getSqlQuery()) {
            name = hbmClass.getName() + "." + jaxbHbmNamedNativeQueryType.getName();
            this.ormRoot.getNamedNativeQueries().add(this.transformNamedNativeQuery(jaxbHbmNamedNativeQueryType, name));
        }
    }

    private void transformEntityCaching(JaxbHbmRootEntityType hbmClass, JaxbEntityImpl entity) {
        entity.setCaching(new JaxbCachingImpl());
        entity.getCaching().setRegion(hbmClass.getCache().getRegion());
        entity.getCaching().setAccess(hbmClass.getCache().getUsage());
        entity.getCaching().setIncludeLazy(this.convert(hbmClass.getCache().getInclude()));
    }

    private boolean convert(JaxbHbmCacheInclusionEnum hbmInclusion) {
        if (hbmInclusion == null) {
            return true;
        }
        if (hbmInclusion == JaxbHbmCacheInclusionEnum.NON_LAZY) {
            return false;
        }
        if (hbmInclusion == JaxbHbmCacheInclusionEnum.ALL) {
            return true;
        }
        throw new IllegalArgumentException("Unrecognized cache-inclusions value : " + hbmInclusion);
    }

    private PolymorphismType convert(JaxbHbmPolymorphismEnum polymorphism) {
        if (polymorphism == null) {
            return null;
        }
        return polymorphism == JaxbHbmPolymorphismEnum.EXPLICIT ? PolymorphismType.EXPLICIT : PolymorphismType.IMPLICIT;
    }

    private void transferBaseEntityInformation(JaxbHbmEntityBaseDefinition hbmClass, JaxbEntityImpl entity) {
        JaxbHbmSubclassEntityBaseDefinition hbmSubclass;
        entity.setMetadataComplete(true);
        this.transfer(hbmClass::getEntityName, entity::setName);
        this.transfer(hbmClass::getName, entity::setClazz);
        if (StringHelper.isEmpty(entity.getExtends()) && hbmClass instanceof JaxbHbmSubclassEntityBaseDefinition && StringHelper.isNotEmpty((hbmSubclass = (JaxbHbmSubclassEntityBaseDefinition)hbmClass).getExtends())) {
            entity.setExtends(TransformationState.requireEntityReferenceName(hbmSubclass.getExtends(), this.hbmXmlMapping, this.transformationState.getEntityMap(), this.origin));
        }
        if (hbmClass instanceof Discriminatable) {
            Discriminatable discriminatable = (Discriminatable)((Object)hbmClass);
            this.transfer(discriminatable::getDiscriminatorValue, entity::setDiscriminatorValue);
        }
        if (hbmClass.isAbstract() != null) {
            entity.setAbstract(hbmClass.isAbstract());
        }
        if (hbmClass.getPersister() != null) {
            this.handleUnsupported("Transforming <persister/> mappings not supported - `%s` in `%s`", entity.getName(), this.origin);
            return;
        }
        this.transfer(hbmClass::isLazy, entity::setLazy);
        this.transfer(hbmClass::getProxy, entity::setProxy);
        this.transfer(hbmClass::getBatchSize, entity::setBatchSize);
        this.transfer(hbmClass::isDynamicInsert, entity::setDynamicInsert);
        this.transfer(hbmClass::isDynamicUpdate, entity::setDynamicUpdate);
        this.transfer(hbmClass::isSelectBeforeUpdate, entity::setSelectBeforeUpdate);
        this.transferToolingHints(hbmClass);
        this.transferResultSetMappings(entity.getName(), hbmClass);
    }

    private void transferResultSetMappings(String namePrefix, ResultSetMappingContainer container) {
        List<JaxbHbmResultSetMappingType> resultSetMappings = container.getResultset();
        resultSetMappings.forEach(hbmMapping -> {
            JaxbSqlResultSetMappingImpl mapping = this.transformResultSetMapping(namePrefix, (JaxbHbmResultSetMappingType)hbmMapping);
            this.ormRoot.getSqlResultSetMappings().add(mapping);
        });
    }

    private void transferToolingHints(ToolingHintContainer container) {
        if (CollectionHelper.isNotEmpty(container.getToolingHints())) {
            this.handleUnsupported("Transformation of <meta/> (tooling hint) is not supported - `%s`", this.origin);
        }
    }

    private void transferDiscriminatorSubclass(JaxbHbmDiscriminatorSubclassEntityType hbmSubclass, JaxbEntityImpl subclassEntity) {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of subclass entity `%` - `%s`", (Object)HbmXmlTransformer.extractEntityName(hbmSubclass), (Object)this.origin);
        this.currentTableName = "";
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity);
        this.transferEntityElementAttributes(hbmSubclass, subclassEntity);
        if (!hbmSubclass.getSubclass().isEmpty()) {
            for (JaxbHbmDiscriminatorSubclassEntityType nestedHbmSubclass : hbmSubclass.getSubclass()) {
                JaxbEntityImpl nestedSubclassEntity = this.transformationState.getEntityXref().get(nestedHbmSubclass);
                this.transferDiscriminatorSubclass(nestedHbmSubclass, nestedSubclassEntity);
            }
        }
    }

    private void transferJoinedSubclass(JaxbHbmJoinedSubclassEntityType hbmSubclass, JaxbEntityImpl subclassEntity) {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of joined-subclass entity `%` - `%s`", (Object)HbmXmlTransformer.extractEntityName(hbmSubclass), (Object)this.origin);
        this.currentTableName = "";
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity);
        this.transferEntityElementAttributes(hbmSubclass, subclassEntity);
        subclassEntity.setTable(new JaxbTableImpl());
        subclassEntity.getTable().setCatalog(hbmSubclass.getCatalog());
        subclassEntity.getTable().setSchema(hbmSubclass.getSchema());
        subclassEntity.getTable().setName(hbmSubclass.getTable());
        subclassEntity.getTable().setComment(hbmSubclass.getComment());
        String hbmCheckConstraint = hbmSubclass.getCheck();
        if (hbmCheckConstraint != null) {
            JaxbCheckConstraintImpl checkConstraint = new JaxbCheckConstraintImpl();
            checkConstraint.setConstraint(hbmCheckConstraint);
            subclassEntity.getTable().getCheckConstraints().add(checkConstraint);
        }
        if (hbmSubclass.getKey() != null) {
            JaxbPrimaryKeyJoinColumnImpl joinColumn = new JaxbPrimaryKeyJoinColumnImpl();
            joinColumn.setName(hbmSubclass.getKey().getColumnAttribute());
            subclassEntity.getPrimaryKeyJoinColumns().add(joinColumn);
        }
        if (!hbmSubclass.getJoinedSubclass().isEmpty()) {
            for (JaxbHbmJoinedSubclassEntityType nestedHbmSubclass : hbmSubclass.getJoinedSubclass()) {
                JaxbEntityImpl nestedSubclassEntity = this.transformationState.getEntityXref().get(nestedHbmSubclass);
                this.transferJoinedSubclass(nestedHbmSubclass, nestedSubclassEntity);
            }
        }
    }

    private void transferColumnsAndFormulas(ColumnAndFormulaSource source, ColumnAndFormulaTarget target, ColumnDefaults columnDefaults, String tableName) {
        if (StringHelper.isNotEmpty(source.getFormulaAttribute())) {
            target.addFormula(source.getFormulaAttribute());
        } else if (StringHelper.isNotEmpty(source.getColumnAttribute())) {
            TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
            column.setName(source.getColumnAttribute());
            column.setTable(tableName);
            target.addColumn(column);
        } else if (!source.getColumnOrFormula().isEmpty()) {
            for (Serializable columnOrFormula : source.getColumnOrFormula()) {
                if (columnOrFormula instanceof String) {
                    target.addFormula((String)((Object)columnOrFormula));
                    continue;
                }
                JaxbHbmColumnType hbmColumn = (JaxbHbmColumnType)columnOrFormula;
                TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
                column.setTable(tableName);
                this.transferColumn(source.wrap(hbmColumn), column);
                target.addColumn(column);
            }
        } else if (StringHelper.isNotEmpty(tableName)) {
            TargetColumnAdapter column = target.makeColumnAdapter(columnDefaults);
            column.setTable(tableName);
            target.addColumn(column);
        }
    }

    private void transferColumn(SourceColumnAdapter source, TargetColumnAdapter target) {
        target.setName(source.getName());
        target.setNullable(this.invert(source.isNotNull()));
        target.setUnique(source.isUnique());
        target.setLength(source.getLength());
        target.setScale(source.getScale());
        target.setPrecision(source.getPrecision());
        target.setComment(source.getComment());
        target.setCheck(source.getCheck());
        target.setDefault(source.getDefault());
        target.setColumnDefinition(source.getSqlType());
        target.setRead(source.getRead());
        target.setWrite(source.getWrite());
    }

    private void transferColumn(SourceColumnAdapter source, TargetColumnAdapter target, String tableName, ColumnDefaults columnDefaults) {
        target.setName(source.getName());
        target.setTable(tableName);
        target.setNullable(this.invert(source.isNotNull(), columnDefaults.isNullable()));
        if (source.getLength() != null) {
            target.setLength(source.getLength());
        } else {
            target.setLength(columnDefaults.getLength());
        }
        if (source.getScale() != null) {
            target.setScale(source.getScale());
        } else {
            target.setScale(columnDefaults.getScale());
        }
        if (source.getPrecision() != null) {
            target.setPrecision(source.getPrecision());
        } else {
            target.setPrecision(columnDefaults.getPrecision());
        }
        if (source.isUnique() != null) {
            target.setUnique(source.isUnique());
        } else {
            target.setUnique(columnDefaults.isUnique());
        }
        target.setInsertable(columnDefaults.isInsertable());
        target.setUpdatable(columnDefaults.isUpdateable());
        target.setComment(source.getComment());
        target.setCheck(source.getCheck());
        target.setDefault(source.getDefault());
        target.setColumnDefinition(source.getSqlType());
        target.setRead(source.getRead());
        target.setWrite(source.getWrite());
    }

    private void transferDiscriminator(JaxbHbmRootEntityType hbmClass, JaxbEntityImpl entity) {
        if (hbmClass.getDiscriminator() == null) {
            return;
        }
        if (StringHelper.isNotEmpty(hbmClass.getDiscriminator().getColumnAttribute())) {
            entity.setDiscriminatorColumn(new JaxbDiscriminatorColumnImpl());
            entity.getDiscriminatorColumn().setName(hbmClass.getDiscriminator().getColumnAttribute());
        } else if (StringHelper.isEmpty(hbmClass.getDiscriminator().getFormulaAttribute())) {
            JaxbDiscriminatorFormulaImpl formula = new JaxbDiscriminatorFormulaImpl();
            formula.setFragment(hbmClass.getDiscriminator().getFormulaAttribute());
            entity.setDiscriminatorFormula(formula);
        } else if (StringHelper.isEmpty(hbmClass.getDiscriminator().getFormula())) {
            JaxbDiscriminatorFormulaImpl formula = new JaxbDiscriminatorFormulaImpl();
            formula.setFragment(hbmClass.getDiscriminator().getFormula().trim());
            entity.setDiscriminatorFormula(formula);
        } else {
            entity.setDiscriminatorColumn(new JaxbDiscriminatorColumnImpl());
            entity.getDiscriminatorColumn().setName(hbmClass.getDiscriminator().getColumn().getName());
            entity.getDiscriminatorColumn().setColumnDefinition(hbmClass.getDiscriminator().getColumn().getSqlType());
            entity.getDiscriminatorColumn().setLength(hbmClass.getDiscriminator().getColumn().getLength());
            entity.getDiscriminatorColumn().setForceSelection(hbmClass.getDiscriminator().isForce());
        }
    }

    private void transferAttributes(JaxbHbmRootEntityType source, JaxbEntityImpl target) {
        this.transferEntityElementAttributes(source, target);
        this.transferIdentifier(source, target);
        this.transferNaturalIdentifiers(source, target);
        this.transferVersion(source, target);
        this.transferTimestamp(source, target);
        this.transferJoins(source, target);
    }

    private void transferEntityElementAttributes(EntityInfo hbmClass, JaxbEntityImpl entity) {
        entity.setAttributes(new JaxbAttributesContainerImpl());
        this.transferAttributes(hbmClass.getAttributes(), entity.getAttributes());
    }

    private void transferAttributes(List hbmAttributeMappings, JaxbAttributesContainer attributes) {
        for (Object hbmAttributeMapping : hbmAttributeMappings) {
            if (hbmAttributeMapping instanceof JaxbHbmBasicAttributeType) {
                JaxbHbmBasicAttributeType basic = (JaxbHbmBasicAttributeType)hbmAttributeMapping;
                attributes.getBasicAttributes().add(this.transformBasicAttribute(basic));
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmCompositeAttributeType) {
                JaxbHbmCompositeAttributeType hbmComponent = (JaxbHbmCompositeAttributeType)hbmAttributeMapping;
                JaxbEmbeddableImpl jaxbEmbeddable = this.applyEmbeddable(this.ormRoot, hbmComponent);
                attributes.getEmbeddedAttributes().add(this.transformEmbedded(jaxbEmbeddable, hbmComponent));
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmPropertiesType) {
                JaxbHbmPropertiesType hbmProperties = (JaxbHbmPropertiesType)hbmAttributeMapping;
                this.handleUnsupported("<properties/> mappings not supported for transformation [name=%s]", hbmProperties.getName());
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmDynamicComponentType) {
                String name = ((JaxbHbmDynamicComponentType)hbmAttributeMapping).getName();
                this.handleUnsupported("<dynamic-component/> mappings not supported for transformation [name=%s]", name);
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmOneToOneType) {
                JaxbHbmOneToOneType o2o = (JaxbHbmOneToOneType)hbmAttributeMapping;
                this.transferOneToOne(o2o, attributes);
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmManyToOneType) {
                JaxbHbmManyToOneType m2o = (JaxbHbmManyToOneType)hbmAttributeMapping;
                attributes.getManyToOneAttributes().add(this.transformManyToOne(m2o));
                continue;
            }
            if (hbmAttributeMapping instanceof JaxbHbmAnyAssociationType) {
                JaxbHbmAnyAssociationType any = (JaxbHbmAnyAssociationType)hbmAttributeMapping;
                attributes.getAnyMappingAttributes().add(this.transformAnyAttribute(any));
                continue;
            }
            if (!(hbmAttributeMapping instanceof PluralAttributeInfo)) continue;
            PluralAttributeInfo hbmCollection = (PluralAttributeInfo)hbmAttributeMapping;
            if (hbmCollection.getElement() != null || hbmCollection.getCompositeElement() != null) {
                attributes.getElementCollectionAttributes().add(this.transformElementCollection(hbmCollection));
                continue;
            }
            if (hbmCollection.getOneToMany() != null) {
                attributes.getOneToManyAttributes().add(this.transformOneToMany(hbmCollection));
                continue;
            }
            if (hbmCollection.getManyToMany() != null) {
                attributes.getManyToManyAttributes().add(this.transformManyToMany(hbmCollection));
                continue;
            }
            if (hbmCollection.getManyToAny() != null) {
                attributes.getPluralAnyMappingAttributes().add(this.transformPluralAny(hbmCollection));
                continue;
            }
            throw new UnsupportedOperationException("Unexpected node type - " + hbmCollection);
        }
    }

    private JaxbBasicImpl transformBasicAttribute(JaxbHbmBasicAttributeType hbmProp) {
        JaxbBasicImpl basic = new JaxbBasicImpl();
        this.transferBasicAttribute(hbmProp, basic);
        return basic;
    }

    private void transferBasicAttribute(final JaxbHbmBasicAttributeType hbmProp, final JaxbBasicImpl basic) {
        basic.setName(hbmProp.getName());
        basic.setOptional(hbmProp.isNotNull() == null || hbmProp.isNotNull() == false);
        basic.setFetch(FetchType.EAGER);
        basic.setAttributeAccessor(hbmProp.getAccess());
        basic.setOptimisticLock(hbmProp.isOptimisticLock());
        if (StringHelper.isNotEmpty(hbmProp.getTypeAttribute())) {
            basic.setType(new JaxbUserTypeImpl());
            basic.getType().setValue(hbmProp.getTypeAttribute());
        } else if (hbmProp.getType() != null) {
            basic.setType(new JaxbUserTypeImpl());
            basic.getType().setValue(hbmProp.getType().getName());
            for (JaxbHbmConfigParameterType hbmParam : hbmProp.getType().getConfigParameters()) {
                JaxbConfigurationParameterImpl param = new JaxbConfigurationParameterImpl();
                param.setName(hbmParam.getName());
                param.setValue(hbmParam.getValue());
                basic.getType().getParameters().add(param);
            }
        }
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmProp.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return hbmProp.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return hbmProp.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                basic.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                basic.setFormula(formula);
            }
        }, new ColumnDefaults(){

            @Override
            public Boolean isNullable() {
                return HbmXmlTransformer.this.invert(hbmProp.isNotNull());
            }

            @Override
            public Integer getLength() {
                return hbmProp.getLength();
            }

            @Override
            public Integer getScale() {
                return StringHelper.isNotEmpty(hbmProp.getScale()) ? Integer.valueOf(Integer.parseInt(hbmProp.getScale())) : null;
            }

            @Override
            public Integer getPrecision() {
                return StringHelper.isNotEmpty(hbmProp.getPrecision()) ? Integer.valueOf(Integer.parseInt(hbmProp.getPrecision())) : null;
            }

            @Override
            public Boolean isUnique() {
                return hbmProp.isUnique();
            }

            @Override
            public Boolean isInsertable() {
                return hbmProp.isInsert();
            }

            @Override
            public Boolean isUpdateable() {
                return hbmProp.isUpdate();
            }
        }, this.currentTableName);
    }

    private JaxbEmbeddableImpl applyEmbeddable(JaxbEntityMappingsImpl ormRoot, JaxbHbmCompositeAttributeType hbmComponent) {
        JaxbEmbeddableImpl existing;
        String embeddableClassName = hbmComponent.getClazz();
        if (StringHelper.isNotEmpty(embeddableClassName) && (existing = this.jaxbEmbeddableByClassName.get(embeddableClassName)) != null) {
            return existing;
        }
        String embeddableName = this.determineEmbeddableName(embeddableClassName, hbmComponent.getName());
        JaxbEmbeddableImpl jaxbEmbeddable = this.convertEmbeddable(embeddableName, embeddableClassName, hbmComponent);
        ormRoot.getEmbeddables().add(jaxbEmbeddable);
        if (StringHelper.isNotEmpty(embeddableClassName)) {
            this.jaxbEmbeddableByClassName.put(embeddableClassName, jaxbEmbeddable);
        }
        return jaxbEmbeddable;
    }

    private JaxbEmbeddableImpl convertEmbeddable(String embeddableName, String embeddableClassName, JaxbHbmCompositeAttributeType hbmComponent) {
        JaxbEmbeddableImpl embeddable = new JaxbEmbeddableImpl();
        embeddable.setMetadataComplete(true);
        embeddable.setName(embeddableName);
        embeddable.setClazz(embeddableClassName);
        embeddable.setAttributes(new JaxbEmbeddableAttributesContainerImpl());
        this.transferAttributes(hbmComponent.getAttributes(), embeddable.getAttributes());
        return embeddable;
    }

    private String determineEmbeddableName(String componentClassName, String attributeName) {
        if (StringHelper.isNotEmpty(componentClassName)) {
            return componentClassName;
        }
        return attributeName + "_" + this.counter++;
    }

    private JaxbEmbeddedImpl transformEmbedded(JaxbEmbeddableImpl jaxbEmbeddable, JaxbHbmCompositeAttributeType hbmComponent) {
        JaxbEmbeddedImpl embedded = new JaxbEmbeddedImpl();
        embedded.setName(hbmComponent.getName());
        embedded.setAttributeAccessor(hbmComponent.getAccess());
        embedded.setTarget(jaxbEmbeddable.getName());
        return embedded;
    }

    private void transferOneToOne(JaxbHbmOneToOneType hbmOneToOne, JaxbAttributesContainer attributes) {
        JaxbOneToOneImpl oneToOne = new JaxbOneToOneImpl();
        oneToOne.setAttributeAccessor(hbmOneToOne.getAccess());
        oneToOne.setCascade(this.convertCascadeType(hbmOneToOne.getCascade()));
        oneToOne.setOrphanRemoval(this.isOrphanRemoval(hbmOneToOne.getCascade()));
        oneToOne.setForeignKey(new JaxbForeignKeyImpl());
        oneToOne.getForeignKey().setName(hbmOneToOne.getForeignKey());
        if (!StringHelper.isEmpty(hbmOneToOne.getPropertyRef())) {
            JaxbJoinColumnImpl joinColumn = new JaxbJoinColumnImpl();
            joinColumn.setReferencedColumnName(hbmOneToOne.getPropertyRef());
            oneToOne.getJoinColumns().add(joinColumn);
        }
        for (String formula : hbmOneToOne.getFormula()) {
            oneToOne.getJoinFormulas().add(formula);
        }
        oneToOne.setName(hbmOneToOne.getName());
        if (StringHelper.isNotEmpty(hbmOneToOne.getEntityName())) {
            oneToOne.setTargetEntity(hbmOneToOne.getEntityName());
        } else {
            oneToOne.setTargetEntity(hbmOneToOne.getClazz());
        }
        this.transferFetchable(hbmOneToOne.getLazy(), hbmOneToOne.getFetch(), hbmOneToOne.getOuterJoin(), hbmOneToOne.isConstrained(), oneToOne);
        attributes.getOneToOneAttributes().add(oneToOne);
    }

    private JaxbManyToOneImpl transformManyToOne(final JaxbHbmManyToOneType hbmNode) {
        final JaxbManyToOneImpl m2o = new JaxbManyToOneImpl();
        m2o.setAttributeAccessor(hbmNode.getAccess());
        m2o.setCascade(this.convertCascadeType(hbmNode.getCascade()));
        if (hbmNode.getForeignKey() != null) {
            m2o.setForeignKey(new JaxbForeignKeyImpl());
            if ("none".equalsIgnoreCase(hbmNode.getForeignKey())) {
                m2o.getForeignKey().setConstraintMode(ConstraintMode.NO_CONSTRAINT);
            } else {
                m2o.getForeignKey().setName(hbmNode.getForeignKey());
            }
        }
        if (StringHelper.isNotEmpty(hbmNode.getPropertyRef())) {
            m2o.setPropertyRef(new JaxbPropertyRefImpl());
            m2o.getPropertyRef().setName(hbmNode.getPropertyRef());
        }
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return hbmNode.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return hbmNode.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return hbmNode.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                m2o.getJoinColumns().add(((TargetColumnAdapterJaxbJoinColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                m2o.getJoinFormulas().add(formula);
            }
        }, ColumnDefaultsBasicImpl.INSTANCE, this.currentTableName);
        m2o.setName(hbmNode.getName());
        m2o.setOptional(hbmNode.isNotNull() == null || hbmNode.isNotNull() == false);
        if (StringHelper.isNotEmpty(hbmNode.getEntityName())) {
            m2o.setTargetEntity(hbmNode.getEntityName());
        } else {
            m2o.setTargetEntity(hbmNode.getClazz());
        }
        this.transferFetchable(hbmNode.getLazy(), hbmNode.getFetch(), hbmNode.getOuterJoin(), null, m2o);
        if (hbmNode.getNotFound() != null) {
            m2o.setNotFound(this.interpretNotFoundAction(hbmNode.getNotFound()));
        }
        return m2o;
    }

    private NotFoundAction interpretNotFoundAction(JaxbHbmNotFoundEnum hbmNotFound) {
        return switch (hbmNotFound) {
            default -> throw new IncompatibleClassChangeError();
            case JaxbHbmNotFoundEnum.EXCEPTION -> NotFoundAction.EXCEPTION;
            case JaxbHbmNotFoundEnum.IGNORE -> NotFoundAction.IGNORE;
        };
    }

    private JaxbAnyMappingImpl transformAnyAttribute(JaxbHbmAnyAssociationType source) {
        JaxbAnyMappingImpl target = new JaxbAnyMappingImpl();
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setOptimisticLock(source.isOptimisticLock());
        target.setDiscriminator(new JaxbAnyMappingDiscriminatorImpl());
        source.getMetaValue().forEach(sourceMapping -> {
            JaxbAnyDiscriminatorValueMappingImpl mapping = new JaxbAnyDiscriminatorValueMappingImpl();
            mapping.setDiscriminatorValue(sourceMapping.getValue());
            mapping.setCorrespondingEntityName(sourceMapping.getClazz());
            target.getDiscriminator().getValueMappings().add(mapping);
        });
        target.setKey(new JaxbAnyMappingKeyImpl());
        return target;
    }

    private JaxbElementCollectionImpl transformElementCollection(PluralAttributeInfo source) {
        JaxbElementCollectionImpl target = new JaxbElementCollectionImpl();
        this.transferCollectionBasicInfo(source, target);
        this.transferCollectionTable(source, target);
        if (source.getElement() != null) {
            this.transferElementInfo(source, source.getElement(), target);
        } else {
            target.setTargetClass(source.getCompositeElement().getClazz());
            this.transferElementInfo(source, source.getCompositeElement(), target);
        }
        return target;
    }

    private void transferCollectionTable(final PluralAttributeInfo source, JaxbElementCollectionImpl target) {
        target.setCollectionTable(new JaxbCollectionTableImpl());
        if (StringHelper.isNotEmpty(source.getTable())) {
            target.getCollectionTable().setName(source.getTable());
            target.getCollectionTable().setCatalog(source.getCatalog());
            target.getCollectionTable().setSchema(source.getSchema());
        }
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return source.getKey().getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return null;
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return new ArrayList<Serializable>(source.getKey().getColumn());
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbJoinColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
            }

            @Override
            public void addFormula(String formula) {
                HbmXmlTransformer.this.handleUnsupportedContent("formula as part of element-collection key is not supported for transformation; skipping");
            }
        }, ColumnDefaultsBasicImpl.INSTANCE, source.getTable());
        if (StringHelper.isNotEmpty(source.getKey().getPropertyRef())) {
            this.handleUnsupportedContent("Foreign-key (<key/>) for persistent collection (name=" + source.getName() + ") specified property-ref which is not supported for transformation; transformed <join-column/> will need manual adjustment of referenced-column-name");
        }
    }

    private void transferCollectionBasicInfo(PluralAttributeInfo source, JaxbPluralAttribute target) {
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        target.setFetchMode(this.convert(source.getFetch()));
        target.setFetch(this.convert(source.getLazy()));
        if (source instanceof JaxbHbmSetType) {
            JaxbHbmSetType set = (JaxbHbmSetType)source;
            String sort = set.getSort();
            if (StringHelper.isNotEmpty(sort) && !"unsorted".equals(sort)) {
                target.setSort(sort);
            }
            target.setOrderBy(set.getOrderBy());
            target.setClassification(LimitedCollectionClassification.SET);
        } else if (source instanceof JaxbHbmMapType) {
            JaxbHbmMapType map = (JaxbHbmMapType)source;
            String sort = map.getSort();
            if (StringHelper.isNotEmpty(sort) && !"unsorted".equals(sort)) {
                target.setSort(sort);
            }
            target.setOrderBy(map.getOrderBy());
            this.transferMapKey((JaxbHbmMapType)source, target);
            target.setClassification(LimitedCollectionClassification.MAP);
        } else if (source instanceof JaxbHbmIdBagCollectionType) {
            this.handleUnsupported("collection-id is not supported for transformation", new Object[0]);
        } else if (source instanceof JaxbHbmBagCollectionType) {
            target.setClassification(LimitedCollectionClassification.BAG);
        } else if (source instanceof JaxbHbmListType) {
            this.transferListIndex(((JaxbHbmListType)source).getIndex(), ((JaxbHbmListType)source).getListIndex(), target);
            target.setClassification(LimitedCollectionClassification.LIST);
        } else if (source instanceof JaxbHbmArrayType) {
            this.transferListIndex(((JaxbHbmArrayType)source).getIndex(), ((JaxbHbmArrayType)source).getListIndex(), target);
            target.setClassification(LimitedCollectionClassification.LIST);
        } else if (source instanceof JaxbHbmPrimitiveArrayType) {
            this.transferListIndex(((JaxbHbmPrimitiveArrayType)source).getIndex(), ((JaxbHbmPrimitiveArrayType)source).getListIndex(), target);
            target.setClassification(LimitedCollectionClassification.LIST);
        }
    }

    private FetchType convert(JaxbHbmLazyWithExtraEnum lazy) {
        if (lazy == null || lazy == JaxbHbmLazyWithExtraEnum.TRUE) {
            return FetchType.LAZY;
        }
        return FetchType.EAGER;
    }

    private void transferListIndex(JaxbHbmIndexType index, JaxbHbmListIndexType listIndex, JaxbPluralAttribute target) {
        JaxbOrderColumnImpl orderColumn = new JaxbOrderColumnImpl();
        target.setOrderColumn(orderColumn);
        if (index != null) {
            if (StringHelper.isNotEmpty(index.getColumnAttribute())) {
                orderColumn.setName(index.getColumnAttribute());
            } else if (index.getColumn().size() == 1) {
                JaxbHbmColumnType hbmColumn = index.getColumn().get(0);
                orderColumn.setName(hbmColumn.getName());
                orderColumn.setNullable(this.invert(hbmColumn.isNotNull()));
                orderColumn.setColumnDefinition(hbmColumn.getSqlType());
            }
        } else if (listIndex != null) {
            if (StringHelper.isNotEmpty(listIndex.getColumnAttribute())) {
                orderColumn.setName(listIndex.getColumnAttribute());
            } else if (listIndex.getColumn() != null) {
                orderColumn.setName(listIndex.getColumn().getName());
                orderColumn.setNullable(this.invert(listIndex.getColumn().isNotNull()));
                orderColumn.setColumnDefinition(listIndex.getColumn().getSqlType());
            }
        }
    }

    private void transferMapKey(JaxbHbmMapType source, JaxbPluralAttribute target) {
        if (source.getIndex() != null) {
            JaxbMapKeyColumnImpl mapKey = new JaxbMapKeyColumnImpl();
            mapKey.setName(source.getIndex().getColumnAttribute());
            target.setMapKeyColumn(mapKey);
        } else if (source.getMapKey() != null) {
            if (!StringHelper.isEmpty(source.getMapKey().getFormulaAttribute())) {
                this.handleUnsupported("Transformation of formula attribute within map-keys is not supported - `%s`", this.origin);
                return;
            }
            if (CollectionHelper.isNotEmpty(source.getMapKey().getColumnOrFormula())) {
                this.handleUnsupported("Transformation of column/formula elements within map-keys is not supported - `%s`", this.origin);
                return;
            }
            if (StringHelper.isNotEmpty(source.getMapKey().getNode())) {
                this.handleUnsupported("Transformation of `node` attribute is not supported - %s", this.origin);
                return;
            }
            String mapKeyType = this.resolveMapKeyType(source.getMapKey());
            if (mapKeyType != null) {
                JaxbUserTypeImpl jaxbMapKeyType = new JaxbUserTypeImpl();
                target.setMapKeyType(jaxbMapKeyType);
                jaxbMapKeyType.setValue(mapKeyType);
            }
            if (StringHelper.isNotEmpty(source.getMapKey().getColumnAttribute())) {
                JaxbMapKeyColumnImpl mapKeyColumn = new JaxbMapKeyColumnImpl();
                mapKeyColumn.setName(source.getMapKey().getColumnAttribute());
                target.setMapKeyColumn(mapKeyColumn);
            }
        }
    }

    private String resolveMapKeyType(JaxbHbmMapKeyBasicType mapKey) {
        if (StringHelper.isNotEmpty(mapKey.getTypeAttribute())) {
            return mapKey.getTypeAttribute();
        }
        if (mapKey.getType() != null) {
            return StringHelper.nullIfEmpty(mapKey.getType().getName());
        }
        return null;
    }

    private Boolean invert(Boolean value) {
        return this.invert(value, null);
    }

    private Boolean invert(Boolean value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value == false;
    }

    private JaxbPluralFetchModeImpl convert(JaxbHbmFetchStyleWithSubselectEnum fetch) {
        if (fetch != null) {
            return switch (fetch) {
                default -> throw new IncompatibleClassChangeError();
                case JaxbHbmFetchStyleWithSubselectEnum.SELECT -> JaxbPluralFetchModeImpl.SELECT;
                case JaxbHbmFetchStyleWithSubselectEnum.JOIN -> JaxbPluralFetchModeImpl.JOIN;
                case JaxbHbmFetchStyleWithSubselectEnum.SUBSELECT -> JaxbPluralFetchModeImpl.SUBSELECT;
            };
        }
        return null;
    }

    private void transferElementInfo(PluralAttributeInfo hbmCollection, final JaxbHbmBasicCollectionElementType element, final JaxbElementCollectionImpl target) {
        this.transferCollectionBasicInfo(hbmCollection, target);
        this.transferCollectionTable(hbmCollection, target);
        this.transferElementTypeInfo(hbmCollection, element, target);
        this.transferColumnsAndFormulas(new ColumnAndFormulaSource(){

            @Override
            public String getColumnAttribute() {
                return element.getColumnAttribute();
            }

            @Override
            public String getFormulaAttribute() {
                return element.getFormulaAttribute();
            }

            @Override
            public List<Serializable> getColumnOrFormula() {
                return element.getColumnOrFormula();
            }

            @Override
            public SourceColumnAdapter wrap(Serializable column) {
                return new SourceColumnAdapterJaxbHbmColumnType((JaxbHbmColumnType)column);
            }
        }, new ColumnAndFormulaTarget(){

            @Override
            public TargetColumnAdapter makeColumnAdapter(ColumnDefaults columnDefaults) {
                return new TargetColumnAdapterJaxbColumn(columnDefaults);
            }

            @Override
            public void addColumn(TargetColumnAdapter column) {
                target.setColumn(((TargetColumnAdapterJaxbColumn)column).getTargetColumn());
            }

            @Override
            public void addFormula(String formula) {
                target.setFormula(formula);
            }
        }, ColumnDefaultsBasicImpl.INSTANCE, null);
    }

    private void transferElementTypeInfo(PluralAttributeInfo hbmCollection, JaxbHbmBasicCollectionElementType element, JaxbElementCollectionImpl target) {
        if (StringHelper.isNotEmpty(element.getTypeAttribute())) {
            JaxbUserTypeImpl jaxbUserType = new JaxbUserTypeImpl();
            target.setType(jaxbUserType);
            jaxbUserType.setValue(element.getTypeAttribute());
        } else if (element.getType() != null && StringHelper.isNotEmpty(element.getType().getName())) {
            JaxbUserTypeImpl jaxbUserType = new JaxbUserTypeImpl();
            target.setType(jaxbUserType);
            jaxbUserType.setValue(element.getType().getName());
            for (JaxbHbmConfigParameterType hbmParam : element.getType().getConfigParameters()) {
                JaxbConfigurationParameterImpl param = new JaxbConfigurationParameterImpl();
                param.setName(hbmParam.getName());
                param.setValue(hbmParam.getValue());
                jaxbUserType.getParameters().add(param);
            }
        }
    }

    private void transferElementInfo(PluralAttributeInfo hbmCollection, JaxbHbmCompositeCollectionElementType compositeElement, JaxbElementCollectionImpl target) {
        this.transferCollectionBasicInfo(hbmCollection, target);
        this.transferCollectionTable(hbmCollection, target);
        String embeddableClassName = compositeElement.getClazz();
        String embeddableName = this.determineEmbeddableName(embeddableClassName, hbmCollection.getName());
        target.setTarget(embeddableName);
        if (StringHelper.isNotEmpty(embeddableClassName)) {
            target.setTargetClass(embeddableClassName);
        }
        JaxbEmbeddableImpl embeddable = new JaxbEmbeddableImpl();
        embeddable.setClazz(embeddableClassName);
        embeddable.setName(embeddableName);
        embeddable.setAttributes(new JaxbEmbeddableAttributesContainerImpl());
        this.transferAttributes(compositeElement.getAttributes(), embeddable.getAttributes());
        this.ormRoot.getEmbeddables().add(embeddable);
    }

    private JaxbOneToManyImpl transformOneToMany(PluralAttributeInfo hbmCollection) {
        JaxbOneToManyImpl target = new JaxbOneToManyImpl();
        this.transferOneToManyInfo(hbmCollection, hbmCollection.getOneToMany(), target);
        return target;
    }

    private void transferOneToManyInfo(PluralAttributeInfo hbmAttributeInfo, JaxbHbmOneToManyCollectionElementType hbmOneToMany, JaxbOneToManyImpl target) {
        if (StringHelper.isNotEmpty(hbmAttributeInfo.getCollectionType())) {
            this.handleUnsupported("Collection-type is not supported for transformation", new Object[0]);
        }
        if (CollectionHelper.isNotEmpty(hbmAttributeInfo.getFilter())) {
            this.handleUnsupported("Filters are not supported for transformation", new Object[0]);
        }
        if (StringHelper.isNotEmpty(hbmAttributeInfo.getWhere())) {
            this.handleUnsupported("SQL restrictions are not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlInsert() != null) {
            this.handleUnsupported("<sql-insert/> not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlUpdate() != null) {
            this.handleUnsupported("<sql-update/> not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlDelete() != null) {
            this.handleUnsupported("<sql-delete/> not supported for transformation", new Object[0]);
        }
        if (hbmAttributeInfo.getSqlDeleteAll() != null) {
            this.handleUnsupported("<sql-delete-all/> not supported for transformation", new Object[0]);
        }
        if (hbmOneToMany.isEmbedXml() != null) {
            this.handleUnsupported("`embed-xml` not supported for transformation", new Object[0]);
        }
        if (hbmOneToMany.getNode() != null && !hbmOneToMany.getNode().isBlank()) {
            this.handleUnsupported("`node` not supported for transformation", new Object[0]);
        }
        if (hbmOneToMany.getNotFound() != null) {
            target.setNotFound(this.interpretNotFoundAction(hbmOneToMany.getNotFound()));
        }
        this.transferCollectionBasicInfo(hbmAttributeInfo, target);
        target.setTargetEntity(StringHelper.isNotEmpty(hbmOneToMany.getClazz()) ? hbmOneToMany.getClazz() : hbmOneToMany.getEntityName());
        JaxbHbmKeyType key = hbmAttributeInfo.getKey();
        if (key != null) {
            target.setForeignKey(new JaxbForeignKeyImpl());
            if (StringHelper.isNotEmpty(key.getForeignKey())) {
                target.getForeignKey().setName(key.getForeignKey());
            }
        }
        target.setOrphanRemoval(this.isOrphanRemoval(hbmAttributeInfo.getCascade()));
        target.setCascade(this.convertCascadeType(hbmAttributeInfo.getCascade()));
    }

    private JaxbManyToManyImpl transformManyToMany(PluralAttributeInfo hbmCollection) {
        JaxbManyToManyImpl target = new JaxbManyToManyImpl();
        this.transferManyToManyInfo(hbmCollection, hbmCollection.getManyToMany(), target);
        return target;
    }

    private void transferManyToManyInfo(PluralAttributeInfo hbmCollection, JaxbHbmManyToManyCollectionElementType manyToMany, JaxbManyToManyImpl target) {
        if (StringHelper.isNotEmpty(hbmCollection.getCollectionType())) {
            this.handleUnsupported("Collection-type is not supported for transformation", new Object[0]);
        }
        if (CollectionHelper.isNotEmpty(hbmCollection.getFilter())) {
            this.handleUnsupported("Filters are not supported for transformation", new Object[0]);
        }
        if (StringHelper.isNotEmpty(hbmCollection.getWhere())) {
            this.handleUnsupported("SQL restrictions are not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlInsert() != null) {
            this.handleUnsupported("<sql-insert/> not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlUpdate() != null) {
            this.handleUnsupported("<sql-update/> not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlDelete() != null) {
            this.handleUnsupported("<sql-delete/> not supported for transformation", new Object[0]);
        }
        if (hbmCollection.getSqlDeleteAll() != null) {
            this.handleUnsupported("<sql-delete-all/> not supported for transformation", new Object[0]);
        }
        if (manyToMany.isEmbedXml() != null) {
            this.handleUnsupported("`embed-xml` not supported for transformation", new Object[0]);
        }
        if (StringHelper.isNotEmpty(manyToMany.getNode())) {
            this.handleUnsupported("`node` not supported for transformation", new Object[0]);
        }
        if (manyToMany.getNotFound() != JaxbHbmNotFoundEnum.EXCEPTION) {
            this.handleUnsupported("`not-found` not supported for transformation", new Object[0]);
        }
        this.transferCollectionBasicInfo(hbmCollection, target);
        target.setTargetEntity(StringHelper.isNotEmpty(manyToMany.getClazz()) ? manyToMany.getClazz() : manyToMany.getEntityName());
    }

    private JaxbPluralAnyMappingImpl transformPluralAny(PluralAttributeInfo hbmCollection) {
        JaxbPluralAnyMappingImpl target = new JaxbPluralAnyMappingImpl();
        this.transferPluralAny(hbmCollection, hbmCollection.getManyToAny(), target);
        return target;
    }

    private void transferPluralAny(PluralAttributeInfo hbmCollection, JaxbHbmManyToAnyCollectionElementType manyToAny, JaxbPluralAnyMappingImpl target) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void transferIdentifier(JaxbHbmRootEntityType source, JaxbEntityImpl target) {
        if (source.getId() != null) {
            target.getAttributes().getIdAttributes().add(this.convertSimpleId(source.getId()));
        } else {
            JaxbHbmCompositeIdType hbmCompositeId = source.getCompositeId();
            assert (hbmCompositeId != null);
            boolean isAggregate = StringHelper.isNotEmpty(hbmCompositeId.getClazz()) ? !hbmCompositeId.isMapped() : false;
            if (isAggregate) {
                target.getAttributes().setEmbeddedIdAttribute(new JaxbEmbeddedIdImpl());
                target.getAttributes().getEmbeddedIdAttribute().setName(hbmCompositeId.getName());
                target.getAttributes().getEmbeddedIdAttribute().setAttributeAccessor(hbmCompositeId.getAccess());
                JaxbEmbeddableImpl embeddable = new JaxbEmbeddableImpl();
                embeddable.setClazz(hbmCompositeId.getClazz());
                embeddable.setAttributes(new JaxbEmbeddableAttributesContainerImpl());
                for (JaxbHbmToolingHintContainer hbmCompositeAttribute : hbmCompositeId.getKeyPropertyOrKeyManyToOne()) {
                    if (hbmCompositeAttribute instanceof JaxbHbmCompositeKeyBasicAttributeType) {
                        JaxbHbmCompositeKeyBasicAttributeType keyProp = (JaxbHbmCompositeKeyBasicAttributeType)hbmCompositeAttribute;
                        JaxbBasicImpl basic = new JaxbBasicImpl();
                        basic.setName(keyProp.getName());
                        basic.setAttributeAccessor(keyProp.getAccess());
                        if (StringHelper.isNotEmpty(keyProp.getColumnAttribute())) {
                            JaxbColumnImpl column = new JaxbColumnImpl();
                            column.setName(keyProp.getColumnAttribute());
                            basic.setColumn(column);
                        } else {
                            for (JaxbHbmColumnType hbmColumn : keyProp.getColumn()) {
                                JaxbColumnImpl column = new JaxbColumnImpl();
                                this.transferColumn(new SourceColumnAdapterJaxbHbmColumnType(hbmColumn), new TargetColumnAdapterJaxbColumn(column, ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
                                basic.setColumn(column);
                            }
                        }
                        embeddable.getAttributes().getBasicAttributes().add(basic);
                        continue;
                    }
                    JaxbHbmCompositeKeyManyToOneType keyManyToOne = (JaxbHbmCompositeKeyManyToOneType)hbmCompositeAttribute;
                    JaxbManyToOneImpl manyToOne = this.transferManyToOneAttribute(keyManyToOne);
                    embeddable.getAttributes().getManyToOneAttributes().add(manyToOne);
                }
                this.ormRoot.getEmbeddables().add(embeddable);
            } else {
                JaxbIdClassImpl idClass = new JaxbIdClassImpl();
                idClass.setClazz(hbmCompositeId.getClazz());
                target.setIdClass(idClass);
                for (JaxbHbmToolingHintContainer hbmCompositeAttribute : hbmCompositeId.getKeyPropertyOrKeyManyToOne()) {
                    if (hbmCompositeAttribute instanceof JaxbHbmCompositeKeyBasicAttributeType) {
                        JaxbHbmCompositeKeyBasicAttributeType keyProp = (JaxbHbmCompositeKeyBasicAttributeType)hbmCompositeAttribute;
                        JaxbIdImpl id = new JaxbIdImpl();
                        id.setName(keyProp.getName());
                        id.setAttributeAccessor(keyProp.getAccess());
                        if (StringHelper.isNotEmpty(keyProp.getColumnAttribute())) {
                            JaxbColumnImpl column = new JaxbColumnImpl();
                            column.setName(keyProp.getColumnAttribute());
                            id.setColumn(column);
                        } else if (keyProp.getColumn().size() == 1) {
                            id.setColumn(new JaxbColumnImpl());
                            this.transferColumn(new SourceColumnAdapterJaxbHbmColumnType(keyProp.getColumn().get(0)), new TargetColumnAdapterJaxbColumn(id.getColumn(), ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
                        }
                        target.getAttributes().getIdAttributes().add(id);
                        continue;
                    }
                    JaxbHbmCompositeKeyManyToOneType keyManyToOne = (JaxbHbmCompositeKeyManyToOneType)hbmCompositeAttribute;
                    JaxbManyToOneImpl manyToOne = this.transferManyToOneAttribute(keyManyToOne);
                    target.getAttributes().getManyToOneAttributes().add(manyToOne);
                }
            }
        }
    }

    private JaxbIdImpl convertSimpleId(JaxbHbmSimpleIdType source) {
        JaxbIdImpl target = new JaxbIdImpl();
        target.setName(source.getName());
        target.setAttributeAccessor(source.getAccess());
        JaxbHbmGeneratorSpecificationType hbmGenerator = source.getGenerator();
        if (hbmGenerator != null && !"assigned".equals(hbmGenerator.getClazz())) {
            JaxbGeneratedValueImpl jaxbGeneratedValue = new JaxbGeneratedValueImpl();
            target.setGeneratedValue(jaxbGeneratedValue);
            JaxbGenericIdGeneratorImpl generator = new JaxbGenericIdGeneratorImpl();
            target.setGenericGenerator(generator);
            generator.setClazz(hbmGenerator.getClazz());
            List<JaxbHbmConfigParameterType> hbmConfigParameters = hbmGenerator.getConfigParameters();
            if (CollectionHelper.isNotEmpty(hbmConfigParameters)) {
                for (JaxbHbmConfigParameterType hbmConfigParameter : hbmConfigParameters) {
                    JaxbConfigurationParameterImpl jaxbParam = new JaxbConfigurationParameterImpl();
                    generator.getParameters().add(jaxbParam);
                    jaxbParam.setName(hbmConfigParameter.getName());
                    jaxbParam.setValue(hbmConfigParameter.getValue());
                }
            }
        }
        target.setUnsavedValue(source.getUnsavedValue());
        if (StringHelper.isNotEmpty(source.getColumnAttribute())) {
            target.setColumn(new JaxbColumnImpl());
            target.getColumn().setName(source.getColumnAttribute());
        } else if (source.getColumn() != null && source.getColumn().size() == 1) {
            target.setColumn(new JaxbColumnImpl());
            this.transferColumn(new SourceColumnAdapterJaxbHbmColumnType(source.getColumn().get(0)), new TargetColumnAdapterJaxbColumn(target.getColumn(), ColumnDefaultsInsertableNonUpdateableImpl.INSTANCE));
        }
        return target;
    }

    private void transferNaturalIdentifiers(JaxbHbmRootEntityType source, JaxbEntityImpl target) {
        if (source.getNaturalId() == null) {
            return;
        }
        final JaxbNaturalIdImpl naturalId = new JaxbNaturalIdImpl();
        this.transferAttributes(source.getNaturalId().getAttributes(), new JaxbAttributesContainer(){

            @Override
            public List<JaxbBasicImpl> getBasicAttributes() {
                return naturalId.getBasicAttributes();
            }

            @Override
            public List<JaxbEmbeddedImpl> getEmbeddedAttributes() {
                return naturalId.getEmbeddedAttributes();
            }

            @Override
            public List<JaxbOneToOneImpl> getOneToOneAttributes() {
                return null;
            }

            @Override
            public List<JaxbManyToOneImpl> getManyToOneAttributes() {
                return null;
            }

            @Override
            public List<JaxbAnyMappingImpl> getAnyMappingAttributes() {
                return null;
            }

            @Override
            public List<JaxbElementCollectionImpl> getElementCollectionAttributes() {
                return null;
            }

            @Override
            public List<JaxbOneToManyImpl> getOneToManyAttributes() {
                return null;
            }

            @Override
            public List<JaxbManyToManyImpl> getManyToManyAttributes() {
                return null;
            }

            @Override
            public List<JaxbPluralAnyMappingImpl> getPluralAnyMappingAttributes() {
                return null;
            }

            @Override
            public List<JaxbTransientImpl> getTransients() {
                return null;
            }
        });
        naturalId.setMutable(source.getNaturalId().isMutable());
        target.getAttributes().setNaturalId(naturalId);
    }

    private void transferVersion(JaxbHbmRootEntityType source, JaxbEntityImpl target) {
        JaxbHbmVersionAttributeType hbmVersion = source.getVersion();
        if (hbmVersion != null) {
            JaxbVersionImpl version = new JaxbVersionImpl();
            version.setName(hbmVersion.getName());
            if (StringHelper.isNotEmpty(hbmVersion.getColumnAttribute())) {
                version.setColumn(new JaxbColumnImpl());
                version.getColumn().setName(hbmVersion.getColumnAttribute());
            }
            target.getAttributes().setVersion(version);
        }
    }

    private void transferTimestamp(JaxbHbmRootEntityType source, JaxbEntityImpl target) {
        JaxbHbmTimestampAttributeType hbmTimestamp = source.getTimestamp();
        if (hbmTimestamp != null) {
            JaxbVersionImpl version = new JaxbVersionImpl();
            version.setName(hbmTimestamp.getName());
            if (StringHelper.isNotEmpty(hbmTimestamp.getColumnAttribute())) {
                version.setColumn(new JaxbColumnImpl());
                version.getColumn().setName(hbmTimestamp.getColumnAttribute());
            }
            version.setTemporal(TemporalType.TIMESTAMP);
            target.getAttributes().setVersion(version);
        }
    }

    private void transferJoins(JaxbHbmRootEntityType source, JaxbEntityImpl target) {
        for (JaxbHbmSecondaryTableType hbmJoin : source.getJoin()) {
            this.currentTableName = hbmJoin.getTable();
            assert (StringHelper.isNotEmpty(this.currentTableName));
            JaxbSecondaryTableImpl secondaryTable = new JaxbSecondaryTableImpl();
            secondaryTable.setCatalog(hbmJoin.getCatalog());
            secondaryTable.setComment(hbmJoin.getComment());
            secondaryTable.setName(hbmJoin.getTable());
            secondaryTable.setSchema(hbmJoin.getSchema());
            secondaryTable.setOptional(hbmJoin.isOptional());
            secondaryTable.setOwned(!hbmJoin.isInverse());
            if (hbmJoin.getKey() != null) {
                JaxbPrimaryKeyJoinColumnImpl joinColumn = new JaxbPrimaryKeyJoinColumnImpl();
                joinColumn.setName(hbmJoin.getKey().getColumnAttribute());
                secondaryTable.getPrimaryKeyJoinColumn().add(joinColumn);
            }
            target.getSecondaryTables().add(secondaryTable);
            for (Serializable attributeMapping : hbmJoin.getAttributes()) {
                if (attributeMapping instanceof JaxbHbmBasicAttributeType) {
                    JaxbBasicImpl prop = this.transformBasicAttribute((JaxbHbmBasicAttributeType)attributeMapping);
                    if (prop.getColumn() == null && prop.getFormula() == null) {
                        prop.setColumn(new JaxbColumnImpl());
                        prop.getColumn().setTable(this.currentTableName);
                    }
                    target.getAttributes().getBasicAttributes().add(prop);
                    continue;
                }
                if (attributeMapping instanceof JaxbHbmCompositeAttributeType) {
                    JaxbHbmCompositeAttributeType hbmComponent = (JaxbHbmCompositeAttributeType)attributeMapping;
                    JaxbEmbeddableImpl jaxbEmbeddable = this.applyEmbeddable(this.ormRoot, hbmComponent);
                    target.getAttributes().getEmbeddedAttributes().add(this.transformEmbedded(jaxbEmbeddable, hbmComponent));
                    continue;
                }
                if (attributeMapping instanceof JaxbHbmManyToOneType) {
                    JaxbHbmManyToOneType hbmManyToOne = (JaxbHbmManyToOneType)attributeMapping;
                    JaxbManyToOneImpl jaxbManyToOne = this.transformManyToOne(hbmManyToOne);
                    target.getAttributes().getManyToOneAttributes().add(jaxbManyToOne);
                    continue;
                }
                if (attributeMapping instanceof JaxbHbmAnyAssociationType) {
                    throw new MappingException("transformation of <any/> as part of <join/> (secondary-table) not yet implemented", this.origin);
                }
                if (!(attributeMapping instanceof JaxbHbmDynamicComponentType)) continue;
                this.handleUnsupportedContent("<dynamic-component/> mappings not supported; skipping");
            }
        }
    }

    private JaxbManyToOneImpl transferManyToOneAttribute(JaxbHbmCompositeKeyManyToOneType hbmM2O) {
        JaxbManyToOneImpl m2o = new JaxbManyToOneImpl();
        m2o.setId(true);
        m2o.setName(hbmM2O.getName());
        m2o.setAttributeAccessor(hbmM2O.getAccess());
        m2o.setFetch(this.convert(hbmM2O.getLazy()));
        m2o.setForeignKey(new JaxbForeignKeyImpl());
        m2o.getForeignKey().setName(hbmM2O.getForeignKey());
        if (!hbmM2O.getColumn().isEmpty()) {
            for (JaxbHbmColumnType hbmColumn : hbmM2O.getColumn()) {
                JaxbJoinColumnImpl joinColumn = new JaxbJoinColumnImpl();
                joinColumn.setName(hbmColumn.getName());
                joinColumn.setTable(this.currentTableName);
                joinColumn.setNullable(hbmColumn.isNotNull() == null ? null : Boolean.valueOf(hbmColumn.isNotNull() == false));
                joinColumn.setUnique(hbmColumn.isUnique());
                m2o.getJoinColumns().add(joinColumn);
            }
        } else {
            JaxbJoinColumnImpl joinColumn = new JaxbJoinColumnImpl();
            if (StringHelper.isEmpty(hbmM2O.getColumnAttribute())) {
                joinColumn.setName(hbmM2O.getName());
            } else {
                joinColumn.setName(hbmM2O.getColumnAttribute());
            }
            joinColumn.setTable(this.currentTableName);
            m2o.getJoinColumns().add(joinColumn);
        }
        if (StringHelper.isNotEmpty(hbmM2O.getEntityName())) {
            m2o.setTargetEntity(hbmM2O.getEntityName());
        } else {
            m2o.setTargetEntity(hbmM2O.getClazz());
        }
        if (hbmM2O.getOnDelete() != null) {
            m2o.setOnDelete(this.convert(hbmM2O.getOnDelete()));
        }
        return m2o;
    }

    private void transferUnionSubclass(JaxbHbmUnionSubclassEntityType hbmSubclass, JaxbEntityImpl subclassEntity) {
        HbmTransformationLogging.TRANSFORMATION_LOGGER.debugf("Starting transformation of union-subclass entity `%` - `%s`", (Object)HbmXmlTransformer.extractEntityName(hbmSubclass), (Object)this.origin);
        this.currentTableName = "";
        subclassEntity.setProxy(hbmSubclass.getProxy());
        this.transferBaseEntityInformation(hbmSubclass, subclassEntity);
        this.transferEntityElementAttributes(hbmSubclass, subclassEntity);
        subclassEntity.setTable(new JaxbTableImpl());
        subclassEntity.getTable().setCatalog(hbmSubclass.getCatalog());
        subclassEntity.getTable().setSchema(hbmSubclass.getSchema());
        subclassEntity.getTable().setName(hbmSubclass.getTable());
        subclassEntity.getTable().setComment(hbmSubclass.getComment());
        String hbmCheck = hbmSubclass.getCheck();
        if (hbmCheck != null) {
            JaxbCheckConstraintImpl checkConstraint = new JaxbCheckConstraintImpl();
            checkConstraint.setConstraint(hbmCheck);
            subclassEntity.getTable().getCheckConstraints().add(checkConstraint);
        }
        if (!hbmSubclass.getUnionSubclass().isEmpty()) {
            for (JaxbHbmUnionSubclassEntityType nestedHbmSubclass : hbmSubclass.getUnionSubclass()) {
                JaxbEntityImpl nestedSubclassEntity = this.transformationState.getEntityXref().get(nestedHbmSubclass);
                this.transferUnionSubclass(nestedHbmSubclass, nestedSubclassEntity);
            }
        }
    }

    private void transferFetchable(JaxbHbmLazyWithNoProxyEnum hbmLazy, JaxbHbmFetchStyleEnum hbmFetch, JaxbHbmOuterJoinEnum hbmOuterJoin, Boolean constrained, JaxbSingularAssociationAttribute fetchable) {
        FetchType laziness = FetchType.LAZY;
        JaxbSingularFetchModeImpl fetch = JaxbSingularFetchModeImpl.SELECT;
        if (hbmLazy != null) {
            if (hbmLazy.equals((Object)JaxbHbmLazyWithNoProxyEnum.FALSE)) {
                laziness = FetchType.EAGER;
            } else if (hbmLazy.equals((Object)JaxbHbmLazyWithNoProxyEnum.NO_PROXY)) {
                // empty if block
            }
        }
        if (constrained != null && !constrained.booleanValue()) {
            laziness = FetchType.EAGER;
            fetch = JaxbSingularFetchModeImpl.JOIN;
        } else if (hbmFetch == null) {
            if (hbmOuterJoin != null && hbmOuterJoin.equals((Object)JaxbHbmOuterJoinEnum.TRUE)) {
                laziness = FetchType.EAGER;
                fetch = JaxbSingularFetchModeImpl.JOIN;
            }
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleEnum.JOIN)) {
            laziness = FetchType.EAGER;
            fetch = JaxbSingularFetchModeImpl.JOIN;
        }
        fetchable.setFetch(laziness);
        fetchable.setFetchMode(fetch);
    }

    private void transferFetchable(JaxbHbmLazyWithExtraEnum hbmLazy, JaxbHbmFetchStyleWithSubselectEnum hbmFetch, JaxbHbmOuterJoinEnum hbmOuterJoin, JaxbPluralAttribute fetchable) {
        FetchType laziness = FetchType.LAZY;
        JaxbPluralFetchModeImpl fetch = JaxbPluralFetchModeImpl.SELECT;
        if (hbmLazy != null) {
            if (hbmLazy.equals((Object)JaxbHbmLazyWithExtraEnum.EXTRA)) {
                throw new MappingException("HBM transformation: extra lazy not yet supported.", this.origin);
            }
            if (hbmLazy.equals((Object)JaxbHbmLazyWithExtraEnum.FALSE)) {
                laziness = FetchType.EAGER;
            }
        }
        if (hbmFetch == null) {
            if (hbmOuterJoin != null && hbmOuterJoin.equals((Object)JaxbHbmOuterJoinEnum.TRUE)) {
                laziness = FetchType.EAGER;
                fetch = JaxbPluralFetchModeImpl.JOIN;
            }
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleWithSubselectEnum.JOIN)) {
            laziness = FetchType.EAGER;
            fetch = JaxbPluralFetchModeImpl.JOIN;
        } else if (hbmFetch.equals((Object)JaxbHbmFetchStyleWithSubselectEnum.SUBSELECT)) {
            fetch = JaxbPluralFetchModeImpl.SUBSELECT;
        }
        fetchable.setFetch(laziness);
        fetchable.setFetchMode(fetch);
    }

    private FetchType convert(JaxbHbmLazyEnum hbmLazy) {
        if (hbmLazy != null && "false".equalsIgnoreCase(hbmLazy.value())) {
            return FetchType.EAGER;
        }
        return FetchType.LAZY;
    }

    private OnDeleteAction convert(JaxbHbmOnDeleteEnum hbmOnDelete) {
        return hbmOnDelete == JaxbHbmOnDeleteEnum.CASCADE ? OnDeleteAction.CASCADE : OnDeleteAction.NO_ACTION;
    }

    private JaxbHbmFilterImpl convert(JaxbHbmFilterType hbmFilter) {
        JaxbHbmFilterImpl filter = new JaxbHbmFilterImpl();
        filter.setName(hbmFilter.getName());
        boolean shouldAutoInjectAliases = hbmFilter.getAutoAliasInjection() == null || hbmFilter.getAutoAliasInjection().equalsIgnoreCase("true");
        filter.setAutoAliasInjection(shouldAutoInjectAliases);
        filter.setCondition(hbmFilter.getCondition());
        for (Serializable content : hbmFilter.getContent()) {
            if (content instanceof String) {
                filter.setCondition((String)((Object)content));
                continue;
            }
            JaxbHbmFilterAliasMappingType hbmAliasMapping = (JaxbHbmFilterAliasMappingType)content;
            JaxbHbmFilterImpl.JaxbAliasesImpl aliasMapping = new JaxbHbmFilterImpl.JaxbAliasesImpl();
            aliasMapping.setAlias(hbmAliasMapping.getAlias());
            aliasMapping.setEntity(hbmAliasMapping.getEntity());
            aliasMapping.setTable(hbmAliasMapping.getTable());
            filter.getAliases().add(aliasMapping);
        }
        return filter;
    }

    private JaxbCascadeTypeImpl convertCascadeType(String s) {
        JaxbCascadeTypeImpl cascadeType = new JaxbCascadeTypeImpl();
        if (StringHelper.isNotEmpty(s)) {
            String[] split;
            s = s.toLowerCase(Locale.ROOT).replaceAll(" ", "");
            for (String hbmCascade : split = s.split(",")) {
                if (hbmCascade.contains("all")) {
                    cascadeType.setCascadeAll(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("persist")) {
                    cascadeType.setCascadePersist(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("merge")) {
                    cascadeType.setCascadeMerge(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("refresh")) {
                    cascadeType.setCascadeRefresh(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("save-update")) {
                    cascadeType.setCascadeMerge(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("evict") || hbmCascade.contains("detach")) {
                    cascadeType.setCascadeDetach(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("replicate")) {
                    cascadeType.setCascadeReplicate(new JaxbEmptyTypeImpl());
                }
                if (hbmCascade.contains("lock")) {
                    cascadeType.setCascadeLock(new JaxbEmptyTypeImpl());
                }
                if (!hbmCascade.contains("delete")) continue;
                cascadeType.setCascadeRemove(new JaxbEmptyTypeImpl());
            }
        }
        return cascadeType;
    }

    private boolean isOrphanRemoval(String s) {
        return StringHelper.isNotEmpty(s) && s.toLowerCase(Locale.ROOT).contains("orphan");
    }

    private String getFullyQualifiedClassName(String className) {
        String defaultPackageName = this.ormRoot.getPackage();
        if (StringHelper.isNotEmpty(className) && className.indexOf(46) < 0 && StringHelper.isNotEmpty(defaultPackageName)) {
            className = StringHelper.qualify(defaultPackageName, className);
        }
        return className;
    }

    @FunctionalInterface
    private static interface PickHandler {
        public void handlePick(String var1, Object ... var2);
    }
}

