/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import jakarta.persistence.InheritanceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.EntityInfo;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmJoinedSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSubclassEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmUnionSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.transform.TransformationState;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbInheritanceImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;

public class TransformationPreprocessor {
    static void preprocessHbmXml(List<Binding<JaxbHbmHibernateMapping>> hbmXmlBindings, TransformationState transformationState) {
        EntityMappingConsumer entityMappingConsumer = new EntityMappingConsumer(transformationState);
        HashMap<String, JaxbEntityImpl> rootClassesMap = new HashMap<String, JaxbEntityImpl>();
        TransformationPreprocessor.processStructuredHierarchies(hbmXmlBindings, rootClassesMap, entityMappingConsumer);
        TransformationPreprocessor.processSeparatedHierarchies(hbmXmlBindings, rootClassesMap, entityMappingConsumer);
    }

    private static void processStructuredHierarchies(Collection<Binding<JaxbHbmHibernateMapping>> hbmXmlBindings, Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer) {
        hbmXmlBindings.forEach(hbmBinding -> TransformationPreprocessor.processStructuredHierarchies(rootClassesMap, entityMappingConsumer, hbmBinding));
    }

    private static void processStructuredHierarchies(Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer, Binding<JaxbHbmHibernateMapping> hbmBinding) {
        JaxbHbmHibernateMapping hibernateMapping = hbmBinding.getRoot();
        hibernateMapping.getClazz().forEach(hbmRoot -> {
            JaxbEntityImpl rootJaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmRoot, hibernateMapping);
            String entityName = TransformationPreprocessor.determineEntityName(hbmRoot, hibernateMapping);
            entityMappingConsumer.accept(hbmBinding, entityName, (JaxbHbmEntityBaseDefinition)hbmRoot, rootJaxbEntity);
            rootClassesMap.put(entityName, rootJaxbEntity);
            if (CollectionHelper.isNotEmpty(hbmRoot.getSubclass())) {
                TransformationPreprocessor.applyInheritanceStrategy(entityName, rootJaxbEntity, InheritanceType.SINGLE_TABLE);
                TransformationPreprocessor.processStructuredDiscriminatorSubclasses(hbmRoot.getSubclass(), entityName, hbmBinding, entityMappingConsumer);
            }
            if (CollectionHelper.isNotEmpty(hbmRoot.getJoinedSubclass())) {
                TransformationPreprocessor.applyInheritanceStrategy(entityName, rootJaxbEntity, InheritanceType.JOINED);
                TransformationPreprocessor.processStructuredJoinedSubclasses(hbmRoot.getJoinedSubclass(), entityName, hbmBinding, entityMappingConsumer);
            }
            if (CollectionHelper.isNotEmpty(hbmRoot.getUnionSubclass())) {
                TransformationPreprocessor.applyInheritanceStrategy(entityName, rootJaxbEntity, InheritanceType.TABLE_PER_CLASS);
                TransformationPreprocessor.processStructuredUnionSubclasses(hbmRoot.getUnionSubclass(), entityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void applyInheritanceStrategy(String entityName, JaxbEntityImpl rootJaxbEntity, InheritanceType strategy) {
        JaxbInheritanceImpl existing = rootJaxbEntity.getInheritance();
        if (existing != null) {
            if (existing.getStrategy() != null && existing.getStrategy() != strategy) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Root entity `%s` defined a mix of inheritance strategies; at least %s and %s", entityName, strategy, existing.getStrategy()));
            }
            existing.setStrategy(strategy);
        } else {
            JaxbInheritanceImpl created = new JaxbInheritanceImpl();
            created.setStrategy(strategy);
            rootJaxbEntity.setInheritance(created);
        }
    }

    private static void processStructuredDiscriminatorSubclasses(List<JaxbHbmDiscriminatorSubclassEntityType> hbmSubclasses, String superEntityName, Binding<JaxbHbmHibernateMapping> hbmBinding, EntityMappingConsumer entityMappingConsumer) {
        hbmSubclasses.forEach(hbmSubclass -> {
            JaxbEntityImpl subclassJaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmSubclass, (JaxbHbmHibernateMapping)hbmBinding.getRoot());
            String subclassEntityName = TransformationPreprocessor.determineEntityName(hbmSubclass, (JaxbHbmHibernateMapping)hbmBinding.getRoot());
            entityMappingConsumer.accept(hbmBinding, subclassEntityName, (JaxbHbmEntityBaseDefinition)hbmSubclass, subclassJaxbEntity);
            subclassJaxbEntity.setExtends(superEntityName);
            if (CollectionHelper.isNotEmpty(hbmSubclass.getSubclass())) {
                TransformationPreprocessor.processStructuredDiscriminatorSubclasses(hbmSubclass.getSubclass(), subclassEntityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void processStructuredJoinedSubclasses(List<JaxbHbmJoinedSubclassEntityType> hbmSubclasses, String superEntityName, Binding<JaxbHbmHibernateMapping> hbmBinding, EntityMappingConsumer entityMappingConsumer) {
        hbmSubclasses.forEach(hbmSubclass -> {
            JaxbEntityImpl subclassJaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmSubclass, (JaxbHbmHibernateMapping)hbmBinding.getRoot());
            String subclassEntityName = TransformationPreprocessor.determineEntityName(hbmSubclass, (JaxbHbmHibernateMapping)hbmBinding.getRoot());
            entityMappingConsumer.accept(hbmBinding, subclassEntityName, (JaxbHbmEntityBaseDefinition)hbmSubclass, subclassJaxbEntity);
            subclassJaxbEntity.setExtends(superEntityName);
            if (CollectionHelper.isNotEmpty(hbmSubclass.getJoinedSubclass())) {
                TransformationPreprocessor.processStructuredJoinedSubclasses(hbmSubclass.getJoinedSubclass(), subclassEntityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void processStructuredUnionSubclasses(List<JaxbHbmUnionSubclassEntityType> hbmSubclasses, String superEntityName, Binding<JaxbHbmHibernateMapping> hbmBinding, EntityMappingConsumer entityMappingConsumer) {
        hbmSubclasses.forEach(hbmSubclass -> {
            JaxbEntityImpl subclassJaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmSubclass, (JaxbHbmHibernateMapping)hbmBinding.getRoot());
            String subclassEntityName = TransformationPreprocessor.determineEntityName(hbmSubclass, (JaxbHbmHibernateMapping)hbmBinding.getRoot());
            entityMappingConsumer.accept(hbmBinding, subclassEntityName, (JaxbHbmEntityBaseDefinition)hbmSubclass, subclassJaxbEntity);
            subclassJaxbEntity.setExtends(superEntityName);
            if (CollectionHelper.isNotEmpty(hbmSubclass.getUnionSubclass())) {
                TransformationPreprocessor.processStructuredUnionSubclasses(hbmSubclass.getUnionSubclass(), subclassEntityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void processSeparatedHierarchies(Collection<Binding<JaxbHbmHibernateMapping>> hbmXmlBindings, Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer) {
        hbmXmlBindings.forEach(hbmBinding -> TransformationPreprocessor.processSeparatedHierarchies(rootClassesMap, entityMappingConsumer, hbmBinding));
    }

    private static void processSeparatedHierarchies(Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer, Binding<JaxbHbmHibernateMapping> hbmBinding) {
        JaxbHbmHibernateMapping hibernateMapping = hbmBinding.getRoot();
        TransformationPreprocessor.processTopLevelDiscriminatedSubclasses(rootClassesMap, entityMappingConsumer, hbmBinding, hibernateMapping);
        TransformationPreprocessor.processTopLevelJoinedSubclasses(rootClassesMap, entityMappingConsumer, hbmBinding, hibernateMapping);
        TransformationPreprocessor.processTopLevelUnionSubclasses(rootClassesMap, entityMappingConsumer, hbmBinding, hibernateMapping);
    }

    private static void processTopLevelDiscriminatedSubclasses(Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer, Binding<JaxbHbmHibernateMapping> hbmBinding, JaxbHbmHibernateMapping hibernateMapping) {
        hibernateMapping.getSubclass().forEach(hbmSubclass -> {
            String entityName = TransformationPreprocessor.determineEntityName(hbmSubclass, hibernateMapping);
            TransformationPreprocessor.applyExtendedInheritanceStrategy(entityName, InheritanceType.SINGLE_TABLE, hbmSubclass, hibernateMapping, rootClassesMap, hbmBinding.getOrigin());
            JaxbEntityImpl jaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmSubclass, hibernateMapping);
            entityMappingConsumer.accept(hbmBinding, entityName, (JaxbHbmEntityBaseDefinition)hbmSubclass, jaxbEntity);
            if (CollectionHelper.isNotEmpty(hbmSubclass.getSubclass())) {
                TransformationPreprocessor.processStructuredDiscriminatorSubclasses(hbmSubclass.getSubclass(), entityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void processTopLevelJoinedSubclasses(Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer, Binding<JaxbHbmHibernateMapping> hbmBinding, JaxbHbmHibernateMapping hibernateMapping) {
        hibernateMapping.getJoinedSubclass().forEach(hbmSubclass -> {
            String entityName = TransformationPreprocessor.determineEntityName(hbmSubclass, hibernateMapping);
            TransformationPreprocessor.applyExtendedInheritanceStrategy(entityName, InheritanceType.JOINED, hbmSubclass, hibernateMapping, rootClassesMap, hbmBinding.getOrigin());
            JaxbEntityImpl jaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmSubclass, hibernateMapping);
            entityMappingConsumer.accept(hbmBinding, entityName, (JaxbHbmEntityBaseDefinition)hbmSubclass, jaxbEntity);
            if (CollectionHelper.isNotEmpty(hbmSubclass.getJoinedSubclass())) {
                TransformationPreprocessor.processStructuredJoinedSubclasses(hbmSubclass.getJoinedSubclass(), entityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void processTopLevelUnionSubclasses(Map<String, JaxbEntityImpl> rootClassesMap, EntityMappingConsumer entityMappingConsumer, Binding<JaxbHbmHibernateMapping> hbmBinding, JaxbHbmHibernateMapping hibernateMapping) {
        hibernateMapping.getUnionSubclass().forEach(hbmSubclass -> {
            String entityName = TransformationPreprocessor.determineEntityName(hbmSubclass, hibernateMapping);
            TransformationPreprocessor.applyExtendedInheritanceStrategy(entityName, InheritanceType.TABLE_PER_CLASS, hbmSubclass, hibernateMapping, rootClassesMap, hbmBinding.getOrigin());
            JaxbEntityImpl jaxbEntity = TransformationPreprocessor.makeJaxbEntity(hbmSubclass, hibernateMapping);
            entityMappingConsumer.accept(hbmBinding, entityName, (JaxbHbmEntityBaseDefinition)hbmSubclass, jaxbEntity);
            if (CollectionHelper.isNotEmpty(hbmSubclass.getUnionSubclass())) {
                TransformationPreprocessor.processStructuredUnionSubclasses(hbmSubclass.getUnionSubclass(), entityName, hbmBinding, entityMappingConsumer);
            }
        });
    }

    private static void applyExtendedInheritanceStrategy(String entityName, InheritanceType strategy, JaxbHbmSubclassEntityBaseDefinition hbmSubclass, JaxbHbmHibernateMapping hibernateMapping, Map<String, JaxbEntityImpl> rootClassesMap, Origin origin) {
        if (StringHelper.isEmpty(hbmSubclass.getExtends())) {
            throw new MappingException("Separated inheritance mapping did not specify extends", origin);
        }
        JaxbEntityImpl superRoot = TransformationState.resolveEntityReference(hbmSubclass.getExtends(), hibernateMapping, rootClassesMap);
        if (superRoot != null) {
            TransformationPreprocessor.applyInheritanceStrategy(entityName, superRoot, strategy);
        }
    }

    private static JaxbEntityImpl makeJaxbEntity(JaxbHbmEntityBaseDefinition hbmEntity, JaxbHbmHibernateMapping hibernateMapping) {
        JaxbEntityImpl jaxbEntity = new JaxbEntityImpl();
        if (StringHelper.isNotEmpty(hbmEntity.getName())) {
            jaxbEntity.setClazz(StringHelper.qualifyConditionallyIfNot(hibernateMapping.getPackage(), hbmEntity.getName()));
        }
        if (StringHelper.isNotEmpty(hbmEntity.getEntityName())) {
            jaxbEntity.setName(hbmEntity.getEntityName());
        }
        return jaxbEntity;
    }

    private static String determineEntityName(EntityInfo entityInfo, JaxbHbmHibernateMapping hibernateMapping) {
        if (entityInfo.getEntityName() != null) {
            return entityInfo.getEntityName();
        }
        return StringHelper.qualifyConditionallyIfNot(hibernateMapping.getPackage(), entityInfo.getName());
    }

    private record EntityMappingConsumer(TransformationState transformationState) {
        public void accept(Binding<JaxbHbmHibernateMapping> hbmBinding, String registrationName, JaxbHbmEntityBaseDefinition hbmEntity, JaxbEntityImpl mappingEntity) {
            Binding<JaxbEntityMappingsImpl> mappingBinding = this.resolveMappingBinding(hbmBinding);
            mappingBinding.getRoot().getEntities().add(mappingEntity);
            this.transformationState.getEntityXref().put(hbmEntity, mappingEntity);
            this.transformationState.getEntityMap().put(registrationName, mappingEntity);
        }

        private Binding<JaxbEntityMappingsImpl> resolveMappingBinding(Binding<JaxbHbmHibernateMapping> hbmBinding) {
            for (int i = 0; i < this.transformationState.getHbmBindings().size(); ++i) {
                if (hbmBinding != this.transformationState.getHbmBindings().get(i)) continue;
                return this.transformationState.getMappingBindings().get(i);
            }
            throw new IllegalStateException("Could not resolve corresponding mapping binding : " + hbmBinding);
        }
    }
}

