/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmEntityBaseDefinition;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.UnknownEntityReferenceException;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;

class TransformationState {
    private final List<Binding<JaxbHbmHibernateMapping>> hbmBindings;
    private final List<Binding<JaxbEntityMappingsImpl>> mappingBindings;
    private final Map<String, JaxbEntityImpl> entityMap = new HashMap<String, JaxbEntityImpl>();
    private final Map<JaxbHbmEntityBaseDefinition, JaxbEntityImpl> entityXref = new HashMap<JaxbHbmEntityBaseDefinition, JaxbEntityImpl>();

    public TransformationState(List<Binding<JaxbHbmHibernateMapping>> hbmBindings) {
        this.hbmBindings = hbmBindings;
        this.mappingBindings = CollectionHelper.arrayList(hbmBindings.size());
        for (Binding<JaxbHbmHibernateMapping> hbmBinding : this.hbmBindings) {
            JaxbEntityMappingsImpl mappingRoot = new JaxbEntityMappingsImpl();
            mappingRoot.setDescription(String.format(Locale.ROOT, "Generated by Hibernate HbmXmlTransformer from %s (%s)", new Object[]{hbmBinding.getOrigin().getName(), hbmBinding.getOrigin().getType()}));
            this.mappingBindings.add(new Binding<JaxbEntityMappingsImpl>(mappingRoot, hbmBinding.getOrigin()));
        }
    }

    public static String resolveEntityReferenceName(String referenceName, JaxbHbmHibernateMapping hibernateMapping, Map<String, JaxbEntityImpl> entityMap) {
        String qualifiedName;
        JaxbEntityImpl byQualifiedName;
        JaxbEntityImpl byDirectName = entityMap.get(referenceName);
        if (byDirectName != null) {
            return referenceName;
        }
        if (StringHelper.isNotEmpty(hibernateMapping.getPackage()) && (byQualifiedName = entityMap.get(qualifiedName = StringHelper.qualify(hibernateMapping.getPackage(), referenceName))) != null) {
            return qualifiedName;
        }
        return null;
    }

    public static String requireEntityReferenceName(String referenceName, JaxbHbmHibernateMapping hibernateMapping, Map<String, JaxbEntityImpl> entityMap, Origin origin) {
        String resolved = TransformationState.resolveEntityReferenceName(referenceName, hibernateMapping, entityMap);
        if (resolved == null) {
            throw new UnknownEntityReferenceException(referenceName, origin);
        }
        return resolved;
    }

    public static JaxbEntityImpl resolveEntityReference(String referenceName, JaxbHbmHibernateMapping hibernateMapping, Map<String, JaxbEntityImpl> entityMap) {
        String qualifiedName;
        JaxbEntityImpl byQualifiedName;
        JaxbEntityImpl byDirectName = entityMap.get(referenceName);
        if (byDirectName != null) {
            return byDirectName;
        }
        if (StringHelper.isNotEmpty(hibernateMapping.getPackage()) && (byQualifiedName = entityMap.get(qualifiedName = StringHelper.qualify(hibernateMapping.getPackage(), referenceName))) != null) {
            return byQualifiedName;
        }
        return null;
    }

    public static JaxbEntityImpl requireEntityReference(String referenceName, JaxbHbmHibernateMapping hibernateMapping, Map<String, JaxbEntityImpl> entityMap, Origin origin) {
        JaxbEntityImpl resolved = TransformationState.resolveEntityReference(referenceName, hibernateMapping, entityMap);
        if (resolved == null) {
            throw new UnknownEntityReferenceException(referenceName, origin);
        }
        return resolved;
    }

    public List<Binding<JaxbHbmHibernateMapping>> getHbmBindings() {
        return this.hbmBindings;
    }

    public List<Binding<JaxbEntityMappingsImpl>> getMappingBindings() {
        return this.mappingBindings;
    }

    public Map<String, JaxbEntityImpl> getEntityMap() {
        return this.entityMap;
    }

    public Map<JaxbHbmEntityBaseDefinition, JaxbEntityImpl> getEntityXref() {
        return this.entityXref;
    }
}

