/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MappedSuperclass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.TimeZoneStorageHelper;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.ColumnJpaAnnotation;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.logging.Logger;

public abstract class AbstractPropertyHolder
implements PropertyHolder {
    private static final Logger log = CoreLogging.logger(AbstractPropertyHolder.class);
    private final String path;
    protected final AbstractPropertyHolder parent;
    private final MetadataBuildingContext context;
    private Boolean isInIdClass;
    private Map<String, Column[]> holderColumnOverride;
    private Map<String, Column[]> currentPropertyColumnOverride;
    private Map<String, ColumnTransformer> holderColumnTransformerOverride;
    private Map<String, ColumnTransformer> currentPropertyColumnTransformerOverride;
    private Map<String, JoinColumn[]> holderJoinColumnOverride;
    private Map<String, JoinColumn[]> currentPropertyJoinColumnOverride;
    private Map<String, JoinTable> holderJoinTableOverride;
    private Map<String, JoinTable> currentPropertyJoinTableOverride;
    private Map<String, ForeignKey> holderForeignKeyOverride;
    private Map<String, ForeignKey> currentPropertyForeignKeyOverride;

    AbstractPropertyHolder(String path, PropertyHolder parent, ClassDetails clazzToProcess, MetadataBuildingContext context) {
        this.path = path;
        this.parent = (AbstractPropertyHolder)parent;
        this.context = context;
        this.buildHierarchyColumnOverride(clazzToProcess);
    }

    protected abstract String normalizeCompositePathForLogging(String var1);

    protected abstract String normalizeCompositePath(String var1);

    protected abstract AttributeConversionInfo locateAttributeConversionInfo(MemberDetails var1);

    protected abstract AttributeConversionInfo locateAttributeConversionInfo(String var1);

    @Override
    public ConverterDescriptor resolveAttributeConverterDescriptor(MemberDetails attributeMember) {
        AttributeConversionInfo info = this.locateAttributeConversionInfo(attributeMember);
        if (info != null) {
            if (info.isConversionDisabled()) {
                return null;
            }
            try {
                return this.makeAttributeConverterDescriptor(info);
            }
            catch (Exception e) {
                throw this.buildExceptionFromInstantiationError(info, e);
            }
        }
        log.debugf("Attempting to locate auto-apply AttributeConverter for attributeMember [%s:%s]", (Object)this.path, (Object)attributeMember.getName());
        return this.context.getMetadataCollector().getConverterRegistry().getAttributeConverterAutoApplyHandler().findAutoApplyConverterForAttribute(attributeMember, this.context);
    }

    protected IllegalStateException buildExceptionFromInstantiationError(AttributeConversionInfo info, Exception e) {
        if (Void.TYPE.equals(info.getConverterClass())) {
            return new IllegalStateException("Unable to instantiate AttributeConverter: you left @Convert.converter to its default value void.", e);
        }
        return new IllegalStateException(String.format("Unable to instantiate AttributeConverter [%s]", info.getConverterClass().getName()), e);
    }

    protected ConverterDescriptor makeAttributeConverterDescriptor(AttributeConversionInfo conversion) {
        try {
            return new ClassBasedConverterDescriptor(conversion.getConverterClass(), false, this.context.getBootstrapContext().getClassmateContext());
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to create AttributeConverter instance", e);
        }
    }

    @Override
    public boolean isInIdClass() {
        if (this.isInIdClass != null) {
            return this.isInIdClass;
        }
        if (this.parent != null) {
            return this.parent.isInIdClass();
        }
        return false;
    }

    @Override
    public void setInIdClass(Boolean isInIdClass) {
        this.isInIdClass = isInIdClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected MetadataBuildingContext getContext() {
        return this.context;
    }

    protected SourceModelBuildingContext getSourceModelContext() {
        return this.getContext().getMetadataCollector().getSourceModelBuildingContext();
    }

    protected void setCurrentProperty(MemberDetails attributeMember) {
        if (attributeMember == null) {
            this.currentPropertyColumnOverride = null;
            this.currentPropertyColumnTransformerOverride = null;
            this.currentPropertyJoinColumnOverride = null;
            this.currentPropertyJoinTableOverride = null;
            this.currentPropertyForeignKeyOverride = null;
        } else {
            this.currentPropertyColumnOverride = AbstractPropertyHolder.buildColumnOverride((AnnotationTarget)attributeMember, this.getPath(), this.context);
            if (this.currentPropertyColumnOverride.isEmpty()) {
                this.currentPropertyColumnOverride = null;
            }
            this.currentPropertyColumnTransformerOverride = AbstractPropertyHolder.buildColumnTransformerOverride((AnnotationTarget)attributeMember, this.context);
            if (this.currentPropertyColumnTransformerOverride.isEmpty()) {
                this.currentPropertyColumnTransformerOverride = null;
            }
            this.currentPropertyJoinColumnOverride = AbstractPropertyHolder.buildJoinColumnOverride((AnnotationTarget)attributeMember, this.getPath(), this.context);
            if (this.currentPropertyJoinColumnOverride.isEmpty()) {
                this.currentPropertyJoinColumnOverride = null;
            }
            this.currentPropertyJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride((AnnotationTarget)attributeMember, this.getPath(), this.context);
            if (this.currentPropertyJoinTableOverride.isEmpty()) {
                this.currentPropertyJoinTableOverride = null;
            }
            this.currentPropertyForeignKeyOverride = AbstractPropertyHolder.buildForeignKeyOverride((AnnotationTarget)attributeMember, this.getPath(), this.context);
            if (this.currentPropertyForeignKeyOverride.isEmpty()) {
                this.currentPropertyForeignKeyOverride = null;
            }
        }
    }

    @Override
    public Column[] getOverriddenColumn(String propertyName) {
        Column[] result = this.getExactOverriddenColumn(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenColumn(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    @Override
    public ColumnTransformer getOverriddenColumnTransformer(String logicalColumnName) {
        ColumnTransformer result = null;
        if (this.parent != null) {
            result = this.parent.getOverriddenColumnTransformer(logicalColumnName);
        }
        if (result == null && this.currentPropertyColumnTransformerOverride != null) {
            result = this.currentPropertyColumnTransformerOverride.get(logicalColumnName);
        }
        if (result == null && this.holderColumnTransformerOverride != null) {
            result = this.holderColumnTransformerOverride.get(logicalColumnName);
        }
        return result;
    }

    private Column[] getExactOverriddenColumn(String propertyName) {
        Column[] result = null;
        if (this.parent != null) {
            result = this.parent.getExactOverriddenColumn(propertyName);
        }
        if (result == null && this.currentPropertyColumnOverride != null) {
            result = this.currentPropertyColumnOverride.get(propertyName);
        }
        if (result == null && this.holderColumnOverride != null) {
            result = this.holderColumnOverride.get(propertyName);
        }
        return result;
    }

    @Override
    public JoinColumn[] getOverriddenJoinColumn(String propertyName) {
        JoinColumn[] result = this.getExactOverriddenJoinColumn(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenJoinColumn(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private JoinColumn[] getExactOverriddenJoinColumn(String propertyName) {
        JoinColumn[] result = null;
        if (this.parent != null) {
            result = this.parent.getExactOverriddenJoinColumn(propertyName);
        }
        if (result == null && this.currentPropertyJoinColumnOverride != null) {
            result = this.currentPropertyJoinColumnOverride.get(propertyName);
        }
        if (result == null && this.holderJoinColumnOverride != null) {
            result = this.holderJoinColumnOverride.get(propertyName);
        }
        return result;
    }

    @Override
    public ForeignKey getOverriddenForeignKey(String propertyName) {
        ForeignKey result = this.getExactOverriddenForeignKey(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenForeignKey(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private ForeignKey getExactOverriddenForeignKey(String propertyName) {
        ForeignKey result = null;
        if (this.parent != null) {
            result = this.parent.getExactOverriddenForeignKey(propertyName);
        }
        if (result == null && this.currentPropertyForeignKeyOverride != null) {
            result = this.currentPropertyForeignKeyOverride.get(propertyName);
        }
        if (result == null && this.holderForeignKeyOverride != null) {
            result = this.holderForeignKeyOverride.get(propertyName);
        }
        return result;
    }

    @Override
    public JoinTable getJoinTable(MemberDetails attributeMember) {
        String propertyName = StringHelper.qualify(this.getPath(), attributeMember.getName());
        JoinTable result = this.getOverriddenJoinTable(propertyName);
        if (result == null) {
            return (JoinTable)attributeMember.getDirectAnnotationUsage(JoinTable.class);
        }
        return result;
    }

    public JoinTable getOverriddenJoinTable(String propertyName) {
        JoinTable result = this.getExactOverriddenJoinTable(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenJoinTable(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private JoinTable getExactOverriddenJoinTable(String propertyName) {
        JoinTable override = null;
        if (this.parent != null) {
            override = this.parent.getExactOverriddenJoinTable(propertyName);
        }
        if (override == null && this.currentPropertyJoinTableOverride != null) {
            override = this.currentPropertyJoinTableOverride.get(propertyName);
        }
        if (override == null && this.holderJoinTableOverride != null) {
            override = this.holderJoinTableOverride.get(propertyName);
        }
        return override;
    }

    private void buildHierarchyColumnOverride(ClassDetails element) {
        Map<String, Column[]> columnOverride = new HashMap<String, Column[]>();
        Map<String, ColumnTransformer> columnTransformerOverride = new HashMap<String, ColumnTransformer>();
        Map<String, JoinColumn[]> joinColumnOverride = new HashMap<String, JoinColumn[]>();
        Map<String, JoinTable> joinTableOverride = new HashMap<String, JoinTable>();
        Map<String, ForeignKey> foreignKeyOverride = new HashMap<String, ForeignKey>();
        for (ClassDetails current = element; current != null && !ClassDetails.OBJECT_CLASS_DETAILS.equals(current); current = current.getSuperClass()) {
            if (!current.hasDirectAnnotationUsage(Entity.class) && !current.hasDirectAnnotationUsage(MappedSuperclass.class) && !current.hasDirectAnnotationUsage(Embeddable.class)) continue;
            Map<String, Column[]> currentOverride = AbstractPropertyHolder.buildColumnOverride((AnnotationTarget)current, this.getPath(), this.context);
            Map<String, ColumnTransformer> currentTransformerOverride = AbstractPropertyHolder.buildColumnTransformerOverride((AnnotationTarget)current, this.context);
            Map<String, JoinColumn[]> currentJoinOverride = AbstractPropertyHolder.buildJoinColumnOverride((AnnotationTarget)current, this.getPath(), this.context);
            Map<String, JoinTable> currentJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride((AnnotationTarget)current, this.getPath(), this.context);
            Map<String, ForeignKey> currentForeignKeyOverride = AbstractPropertyHolder.buildForeignKeyOverride((AnnotationTarget)current, this.getPath(), this.context);
            currentOverride.putAll(columnOverride);
            currentTransformerOverride.putAll(columnTransformerOverride);
            currentJoinOverride.putAll(joinColumnOverride);
            currentJoinTableOverride.putAll(joinTableOverride);
            currentForeignKeyOverride.putAll(foreignKeyOverride);
            columnOverride = currentOverride;
            columnTransformerOverride = currentTransformerOverride;
            joinColumnOverride = currentJoinOverride;
            joinTableOverride = currentJoinTableOverride;
            foreignKeyOverride = currentForeignKeyOverride;
        }
        this.holderColumnOverride = !columnOverride.isEmpty() ? columnOverride : null;
        this.holderColumnTransformerOverride = !columnTransformerOverride.isEmpty() ? columnTransformerOverride : null;
        this.holderJoinColumnOverride = !joinColumnOverride.isEmpty() ? joinColumnOverride : null;
        this.holderJoinTableOverride = !joinTableOverride.isEmpty() ? joinTableOverride : null;
        this.holderForeignKeyOverride = !foreignKeyOverride.isEmpty() ? foreignKeyOverride : null;
    }

    private static Map<String, Column[]> buildColumnOverride(AnnotationTarget element, String path, MetadataBuildingContext context) {
        HashMap<String, Column[]> result = new HashMap<String, Column[]>();
        if (element == null) {
            return result;
        }
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        HashMap<Object, List> columnOverrideMap = new HashMap<Object, List>();
        Object[] overrides = (AttributeOverride[])element.getRepeatedAnnotationUsages(AttributeOverride.class, sourceModelContext);
        if (CollectionHelper.isNotEmpty(overrides)) {
            for (Object depAttr : overrides) {
                String qualifiedName = StringHelper.qualify(path, depAttr.name());
                Column column = depAttr.column();
                if (columnOverrideMap.containsKey(qualifiedName)) {
                    ((List)columnOverrideMap.get(qualifiedName)).add(column);
                    continue;
                }
                ArrayList<Column> list = new ArrayList<Column>();
                list.add(column);
                columnOverrideMap.put(qualifiedName, list);
            }
        } else if (TimeZoneStorageHelper.useColumnForTimeZoneStorage(element, context)) {
            Column column = AbstractPropertyHolder.createTemporalColumn(element, path, context);
            if (TimeZoneStorageHelper.isOffsetTimeClass(element)) {
                columnOverrideMap.put(path + ".utcTime", List.of(column));
            } else {
                columnOverrideMap.put(path + ".instant", List.of(column));
            }
            Column offsetColumn = AbstractPropertyHolder.createTimeZoneColumn(element, column, context);
            columnOverrideMap.put(path + ".zoneOffset", List.of(offsetColumn));
        }
        columnOverrideMap.forEach((name, columns) -> result.put((String)name, columns.toArray(new Column[0])));
        return result;
    }

    private static Column createTimeZoneColumn(AnnotationTarget element, Column column, MetadataBuildingContext context) {
        TimeZoneColumn timeZoneColumn = (TimeZoneColumn)element.getDirectAnnotationUsage(TimeZoneColumn.class);
        ColumnJpaAnnotation created = (ColumnJpaAnnotation)JpaAnnotations.COLUMN.createUsage(context.getMetadataCollector().getSourceModelBuildingContext());
        Object columnName = timeZoneColumn != null ? timeZoneColumn.name() : column.name() + "_tz";
        created.name((String)columnName);
        created.nullable(column.nullable());
        if (timeZoneColumn != null) {
            created.table(timeZoneColumn.table());
            created.insertable(timeZoneColumn.insertable());
            created.updatable(timeZoneColumn.updatable());
            created.columnDefinition(timeZoneColumn.columnDefinition());
        } else {
            created.table(column.table());
            created.insertable(column.insertable());
            created.updatable(column.updatable());
            created.columnDefinition(column.columnDefinition());
        }
        return created;
    }

    private static Column createTemporalColumn(AnnotationTarget element, final String path, final MetadataBuildingContext context) {
        int secondPrecision;
        int precision;
        Column annotatedColumn = (Column)element.getDirectAnnotationUsage(Column.class);
        if (annotatedColumn != null) {
            if (StringHelper.isNotEmpty(annotatedColumn.name())) {
                return annotatedColumn;
            }
            precision = annotatedColumn.precision();
            secondPrecision = annotatedColumn.secondPrecision();
        } else {
            precision = 0;
            secondPrecision = -1;
        }
        Identifier implicitName = context.getObjectNameNormalizer().normalizeIdentifierQuoting(context.getBuildingOptions().getImplicitNamingStrategy().determineBasicColumnName(new ImplicitBasicColumnNameSource(){
            final AttributePath attributePath;
            {
                this.attributePath = AttributePath.parse(path);
            }

            @Override
            public AttributePath getAttributePath() {
                return this.attributePath;
            }

            @Override
            public boolean isCollectionElement() {
                return false;
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return context;
            }
        }));
        ColumnJpaAnnotation created = (ColumnJpaAnnotation)JpaAnnotations.COLUMN.createUsage(context.getMetadataCollector().getSourceModelBuildingContext());
        if (StringHelper.isNotEmpty(implicitName.getText())) {
            created.name(implicitName.getText());
        }
        created.precision(precision);
        created.secondPrecision(secondPrecision);
        return created;
    }

    private static Map<String, ColumnTransformer> buildColumnTransformerOverride(AnnotationTarget element, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        HashMap<String, ColumnTransformer> columnOverride = new HashMap<String, ColumnTransformer>();
        if (element != null) {
            element.forEachAnnotationUsage(ColumnTransformer.class, sourceModelContext, usage -> columnOverride.put(usage.forColumn(), (ColumnTransformer)usage));
        }
        return columnOverride;
    }

    private static Map<String, JoinColumn[]> buildJoinColumnOverride(AnnotationTarget element, String path, MetadataBuildingContext context) {
        HashMap<String, JoinColumn[]> columnOverride = new HashMap<String, JoinColumn[]>();
        if (element != null) {
            AssociationOverride[] overrides;
            for (AssociationOverride override : overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path, context)) {
                columnOverride.put(StringHelper.qualify(path, override.name()), override.joinColumns());
            }
        }
        return columnOverride;
    }

    private static Map<String, ForeignKey> buildForeignKeyOverride(AnnotationTarget element, String path, MetadataBuildingContext context) {
        HashMap<String, ForeignKey> foreignKeyOverride = new HashMap<String, ForeignKey>();
        if (element != null) {
            AssociationOverride[] overrides;
            for (AssociationOverride override : overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path, context)) {
                foreignKeyOverride.put(StringHelper.qualify(path, override.name()), override.foreignKey());
            }
        }
        return foreignKeyOverride;
    }

    private static AssociationOverride[] buildAssociationOverrides(AnnotationTarget element, String path, MetadataBuildingContext context) {
        return (AssociationOverride[])element.getRepeatedAnnotationUsages(AssociationOverride.class, context.getMetadataCollector().getSourceModelBuildingContext());
    }

    private static Map<String, JoinTable> buildJoinTableOverride(AnnotationTarget element, String path, MetadataBuildingContext context) {
        HashMap<String, JoinTable> result = new HashMap<String, JoinTable>();
        if (element != null) {
            AssociationOverride[] overrides;
            for (AssociationOverride override : overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path, context)) {
                Object[] joinColumns = override.joinColumns();
                if (!CollectionHelper.isEmpty(joinColumns)) continue;
                result.put(StringHelper.qualify(path, override.name()), override.joinTable());
            }
        }
        return result;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        throw new AssertionFailure("Setting the parent property to a non component");
    }

    private static class ColumnImpl
    implements Column {
        private final String name;
        private final boolean unique;
        private final boolean nullable;
        private final boolean insertable;
        private final boolean updatable;
        private final String columnDefinition;
        private final String table;
        private final int precision;
        private final int secondPrecision;

        private ColumnImpl(String name, boolean unique, boolean nullable, boolean insertable, boolean updatable, String columnDefinition, String table, int precision, int secondPrecision) {
            this.name = name;
            this.unique = unique;
            this.nullable = nullable;
            this.insertable = insertable;
            this.updatable = updatable;
            this.columnDefinition = columnDefinition;
            this.table = table;
            this.precision = precision;
            this.secondPrecision = secondPrecision;
        }

        public String name() {
            return this.name;
        }

        public boolean unique() {
            return this.unique;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public boolean insertable() {
            return this.insertable;
        }

        public boolean updatable() {
            return this.updatable;
        }

        public String columnDefinition() {
            return this.columnDefinition;
        }

        public String options() {
            return "";
        }

        public String table() {
            return this.table;
        }

        public int length() {
            return 255;
        }

        public int precision() {
            return this.precision;
        }

        public int scale() {
            return 0;
        }

        public int secondPrecision() {
            return this.secondPrecision;
        }

        public CheckConstraint[] check() {
            return new CheckConstraint[0];
        }

        public String comment() {
            return "";
        }

        public Class<? extends Annotation> annotationType() {
            return Column.class;
        }
    }
}

