/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Table;

public class AnnotatedColumns {
    private final List<AnnotatedColumn> columns = new ArrayList<AnnotatedColumn>();
    private Table table;
    private PropertyHolder propertyHolder;
    private String propertyName;
    private Map<String, Join> joins = Collections.emptyMap();
    private MetadataBuildingContext buildingContext;

    public List<AnnotatedColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public PropertyHolder getPropertyHolder() {
        return this.propertyHolder;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public MetadataBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    public void setJoins(Map<String, Join> joins) {
        this.joins = joins;
    }

    public Join getJoin() {
        String physicalTableName;
        AnnotatedColumn firstColumn = this.columns.get(0);
        String explicitTableName = firstColumn.getExplicitTableName();
        Join join = this.joins.get(explicitTableName);
        if (join == null && (physicalTableName = this.getBuildingContext().getMetadataCollector().getPhysicalTableName(explicitTableName)) != null) {
            join = this.joins.get(physicalTableName);
        }
        if (join == null) {
            throw new AnnotationException("Secondary table '" + explicitTableName + "' for property '" + this.propertyName + "' of entity'" + this.getPropertyHolder().getClassName() + "' is not declared (use '@SecondaryTable' to declare the secondary table)");
        }
        return join;
    }

    public boolean isSecondary() {
        AnnotatedColumn firstColumn = this.columns.get(0);
        String explicitTableName = firstColumn.getExplicitTableName();
        return StringHelper.isNotEmpty(explicitTableName) && !this.getPropertyHolder().getTable().getName().equals(explicitTableName);
    }

    public Table getTable() {
        if (this.table != null) {
            return this.table;
        }
        return this.isSecondary() ? this.getJoin().getTable() : this.getPropertyHolder().getTable();
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Deprecated
    void setTableInternal(Table table) {
        this.table = table;
    }

    public void addColumn(AnnotatedColumn child) {
        this.columns.add(child);
    }

    public void checkPropertyConsistency() {
        if (this.columns.size() > 1) {
            for (int currentIndex = 1; currentIndex < this.columns.size(); ++currentIndex) {
                AnnotatedColumn current = this.columns.get(currentIndex);
                AnnotatedColumn previous = this.columns.get(currentIndex - 1);
                if (current.isFormula() || previous.isFormula()) continue;
                if (current.isNullable() != previous.isNullable()) {
                    throw new AnnotationException("Column mappings for property '" + this.propertyName + "' mix nullable with 'not null'");
                }
                if (current.isInsertable() != previous.isInsertable()) {
                    throw new AnnotationException("Column mappings for property '" + this.propertyName + "' mix insertable with 'insertable=false'");
                }
                if (current.isUpdatable() != previous.isUpdatable()) {
                    throw new AnnotationException("Column mappings for property '" + this.propertyName + "' mix updatable with 'updatable=false'");
                }
                if (current.getExplicitTableName().equals(previous.getExplicitTableName())) continue;
                throw new AnnotationException("Column mappings for property '" + this.propertyName + "' mix distinct secondary tables");
            }
        }
    }
}

