/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.AnyKeyJavaType;
import org.hibernate.annotations.AnyKeyJdbcType;
import org.hibernate.annotations.AnyKeyJdbcTypeCode;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionIdJavaType;
import org.hibernate.annotations.CollectionIdJdbcType;
import org.hibernate.annotations.CollectionIdJdbcTypeCode;
import org.hibernate.annotations.CollectionIdMutability;
import org.hibernate.annotations.CollectionIdType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ListIndexJavaType;
import org.hibernate.annotations.ListIndexJdbcType;
import org.hibernate.annotations.ListIndexJdbcTypeCode;
import org.hibernate.annotations.MapKeyJavaType;
import org.hibernate.annotations.MapKeyJdbcType;
import org.hibernate.annotations.MapKeyJdbcTypeCode;
import org.hibernate.annotations.MapKeyMutability;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.PartitionKey;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.annotations.Type;
import org.hibernate.boot.model.TypeDefinition;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.AnnotationHelper;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.boot.model.internal.SetBasicValueTypeSecondPass;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.EnumType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.Immutability;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.internal.ParameterizedTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;

public class BasicValueBinder
implements JdbcTypeIndicators {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BasicValueBinder.class.getName());
    private final Kind kind;
    private final Component aggregateComponent;
    private final MetadataBuildingContext buildingContext;
    private String explicitBasicTypeName;
    private Class<? extends UserType<?>> explicitCustomType;
    private Map<String, String> explicitLocalTypeParams;
    private Function<TypeConfiguration, JdbcType> explicitJdbcTypeAccess;
    private Function<TypeConfiguration, BasicJavaType> explicitJavaTypeAccess;
    private Function<TypeConfiguration, MutabilityPlan> explicitMutabilityAccess;
    private Function<TypeConfiguration, java.lang.reflect.Type> implicitJavaTypeAccess;
    private MemberDetails xproperty;
    private AccessType accessType;
    private ConverterDescriptor converterDescriptor;
    private boolean isNationalized;
    private boolean isLob;
    private jakarta.persistence.EnumType enumType;
    private TemporalType temporalPrecision;
    private TimeZoneStorageType timeZoneStorageType;
    private boolean partitionKey;
    private Integer jdbcTypeCode;
    private Table table;
    private AnnotatedColumns columns;
    private BasicValue basicValue;
    private String timeStampVersionType;
    private String persistentClassName;
    private String propertyName;
    private String returnedClassName;
    private String referencedEntityName;

    public BasicValueBinder(Kind kind, MetadataBuildingContext buildingContext) {
        this(kind, null, buildingContext);
    }

    public BasicValueBinder(Kind kind, Component aggregateComponent, MetadataBuildingContext buildingContext) {
        assert (kind != null);
        assert (buildingContext != null);
        this.kind = kind;
        this.aggregateComponent = aggregateComponent;
        this.buildingContext = buildingContext;
    }

    protected SourceModelBuildingContext getSourceModelContext() {
        return this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.buildingContext.getBootstrapContext().getTypeConfiguration();
    }

    @Override
    public TimeZoneStorageStrategy getDefaultTimeZoneStorageStrategy() {
        return BasicValue.timeZoneStorageStrategy(this.timeZoneStorageType, this.buildingContext);
    }

    @Override
    public jakarta.persistence.EnumType getEnumeratedType() {
        return this.enumType;
    }

    @Override
    public boolean isLob() {
        JdbcType type;
        if (this.isLob) {
            return true;
        }
        if (this.explicitJdbcTypeAccess != null && (type = this.explicitJdbcTypeAccess.apply(this.getTypeConfiguration())) != null) {
            return type.isLob();
        }
        return false;
    }

    @Override
    public TemporalType getTemporalPrecision() {
        return this.temporalPrecision;
    }

    @Override
    public boolean isPreferJavaTimeJdbcTypesEnabled() {
        return this.buildingContext.isPreferJavaTimeJdbcTypesEnabled();
    }

    @Override
    public boolean isPreferNativeEnumTypesEnabled() {
        return this.buildingContext.isPreferNativeEnumTypesEnabled();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForBoolean());
    }

    @Override
    public int getPreferredSqlTypeCodeForDuration() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForDuration());
    }

    @Override
    public int getPreferredSqlTypeCodeForUuid() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForUuid());
    }

    @Override
    public int getPreferredSqlTypeCodeForInstant() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForInstant());
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return this.resolveJdbcTypeCode(this.buildingContext.getPreferredSqlTypeCodeForArray());
    }

    @Override
    public int resolveJdbcTypeCode(int jdbcTypeCode) {
        return this.aggregateComponent == null ? jdbcTypeCode : this.buildingContext.getMetadataCollector().getDatabase().getDialect().getAggregateSupport().aggregateComponentSqlTypeCode(this.aggregateComponent.getAggregateColumn().getSqlTypeCode(), jdbcTypeCode);
    }

    @Override
    public boolean isNationalized() {
        JdbcType type;
        if (this.isNationalized) {
            return true;
        }
        if (this.explicitJdbcTypeAccess != null && (type = this.explicitJdbcTypeAccess.apply(this.getTypeConfiguration())) != null) {
            return type.isNationalized();
        }
        return false;
    }

    public void setVersion(boolean isVersion) {
        if (isVersion && this.basicValue != null) {
            this.basicValue.makeVersion();
        }
    }

    public void setTimestampVersionType(String versionType) {
        this.timeStampVersionType = versionType;
    }

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setType(MemberDetails valueMember, TypeDetails typeDetails, String declaringClassName, ConverterDescriptor converterDescriptor) {
        TypeDetails modelClassDetails;
        this.xproperty = valueMember;
        boolean isArray = valueMember.isArray();
        if (typeDetails == null && !isArray) {
            return;
        }
        if (this.columns == null) {
            throw new AssertionFailure("`BasicValueBinder#setColumns` should be called before `BasicValueBinder#setType`");
        }
        TypeDetails typeDetails2 = modelClassDetails = isArray ? valueMember.getElementType() : typeDetails;
        if (this.kind != Kind.LIST_INDEX && this.kind != Kind.MAP_KEY) {
            this.isLob = valueMember.hasDirectAnnotationUsage(Lob.class);
        }
        if (this.getDialect().getNationalizationSupport() == NationalizationSupport.EXPLICIT) {
            this.isNationalized = this.buildingContext.getBuildingOptions().useNationalizedCharacterData() || valueMember.locateAnnotationUsage(Nationalized.class, this.getSourceModelContext()) != null;
        }
        this.applyJpaConverter(valueMember, converterDescriptor);
        Class<? extends UserType<?>> userTypeImpl = this.kind.mappingAccess.customType(valueMember, this.getSourceModelContext());
        if (userTypeImpl != null) {
            this.applyExplicitType(userTypeImpl, this.kind.mappingAccess.customTypeParameters(valueMember, this.getSourceModelContext()));
            return;
        }
        if (modelClassDetails != null) {
            ClassDetails rawClassDetails = modelClassDetails.determineRawClass();
            Class basicClass = rawClassDetails.toJavaClass();
            Class<? extends UserType<?>> registeredUserTypeImpl = this.buildingContext.getMetadataCollector().findRegisteredUserType(basicClass);
            if (registeredUserTypeImpl != null) {
                this.applyExplicitType(registeredUserTypeImpl, Collections.emptyMap());
                return;
            }
        }
        switch (this.kind) {
            case ATTRIBUTE: {
                this.prepareBasicAttribute(declaringClassName, valueMember, typeDetails);
                break;
            }
            case ANY_DISCRIMINATOR: {
                this.prepareAnyDiscriminator(valueMember);
                break;
            }
            case ANY_KEY: {
                this.prepareAnyKey(valueMember);
                break;
            }
            case COLLECTION_ID: {
                this.prepareCollectionId(valueMember);
                break;
            }
            case LIST_INDEX: {
                this.prepareListIndex(valueMember);
                break;
            }
            case MAP_KEY: {
                this.prepareMapKey(valueMember, typeDetails);
                break;
            }
            case COLLECTION_ELEMENT: {
                this.prepareCollectionElement(valueMember, typeDetails);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected binder type : " + this.kind);
            }
        }
    }

    private void applyExplicitType(Class<? extends UserType<?>> impl, Map<String, String> params) {
        this.explicitCustomType = impl;
        this.explicitLocalTypeParams = params;
    }

    private void prepareCollectionId(MemberDetails attributeMember) {
        CollectionId collectionIdAnn = (CollectionId)attributeMember.getDirectAnnotationUsage(CollectionId.class);
        if (collectionIdAnn == null) {
            throw new MappingException("idbag mapping missing @CollectionId");
        }
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        ManagedBeanRegistry beanRegistry = this.getManagedBeanRegistry();
        this.explicitBasicTypeName = null;
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            CollectionIdJavaType javaTypeAnn = (CollectionIdJavaType)attributeMember.locateAnnotationUsage(CollectionIdJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (javaTypeClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                ManagedBean<BasicJavaType<?>> bean = beanRegistry.getBean(javaTypeClass);
                return bean.getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int code;
            Class<? extends JdbcType> jdbcTypeClass;
            CollectionIdJdbcType jdbcTypeAnn = (CollectionIdJdbcType)attributeMember.locateAnnotationUsage(CollectionIdJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                ManagedBean<? extends JdbcType> managedBean = beanRegistry.getBean(jdbcTypeClass);
                return managedBean.getBeanInstance();
            }
            CollectionIdJdbcTypeCode jdbcTypeCodeAnn = (CollectionIdJdbcTypeCode)attributeMember.locateAnnotationUsage(CollectionIdJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (code = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(code);
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class attributeType;
            Class<? extends MutabilityPlan<?>> mutabilityClass;
            CollectionIdMutability mutabilityAnn = (CollectionIdMutability)attributeMember.locateAnnotationUsage(CollectionIdMutability.class, this.getSourceModelContext());
            if (mutabilityAnn != null && (mutabilityClass = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutabilityClass);
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null) {
                Mutability attributeTypeMutabilityAnn = attributeType.getAnnotation(Mutability.class);
                if (attributeTypeMutabilityAnn != null) {
                    return this.resolveMutability(attributeTypeMutabilityAnn.value());
                }
                if (attributeType.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(attributeMember, this.getSourceModelContext())) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                if (customTypeImpl.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private ManagedBeanRegistry getManagedBeanRegistry() {
        return this.buildingContext.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class);
    }

    private void prepareMapKey(MemberDetails attributeMember, TypeDetails explicitMapKeyTypeDetails) {
        MapKeyTemporal mapKeyTemporalAnn;
        TypeDetails mapKeyClass = explicitMapKeyTypeDetails == null ? attributeMember.getMapKeyType() : explicitMapKeyTypeDetails;
        this.implicitJavaTypeAccess = typeConfiguration -> {
            ClassDetails rawKeyClassDetails = mapKeyClass.determineRawClass();
            return rawKeyClassDetails.toJavaClass();
        };
        MapKeyEnumerated mapKeyEnumeratedAnn = (MapKeyEnumerated)attributeMember.getDirectAnnotationUsage(MapKeyEnumerated.class);
        if (mapKeyEnumeratedAnn != null) {
            this.enumType = mapKeyEnumeratedAnn.value();
        }
        if ((mapKeyTemporalAnn = (MapKeyTemporal)attributeMember.getDirectAnnotationUsage(MapKeyTemporal.class)) != null) {
            this.temporalPrecision = mapKeyTemporalAnn.value();
        }
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<? extends JdbcType> jdbcTypeClass;
            MapKeyJdbcType jdbcTypeAnn = (MapKeyJdbcType)attributeMember.locateAnnotationUsage(MapKeyJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            MapKeyJdbcTypeCode jdbcTypeCodeAnn = (MapKeyJdbcTypeCode)attributeMember.locateAnnotationUsage(MapKeyJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCode);
            }
            return null;
        };
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            MapKeyJavaType javaTypeAnn = (MapKeyJavaType)attributeMember.locateAnnotationUsage(MapKeyJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (javaTypeClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            MapKeyClass mapKeyClassAnn = (MapKeyClass)attributeMember.getDirectAnnotationUsage(MapKeyClass.class);
            if (mapKeyClassAnn != null) {
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(mapKeyClassAnn.value());
            }
            return null;
        };
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class attributeType;
            Class<? extends MutabilityPlan<?>> mutabilityClass;
            MapKeyMutability mutabilityAnn = (MapKeyMutability)attributeMember.locateAnnotationUsage(MapKeyMutability.class, this.getSourceModelContext());
            if (mutabilityAnn != null && (mutabilityClass = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutabilityClass);
            }
            if (this.implicitJavaTypeAccess != null && (attributeType = ReflectHelper.getClass(this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration))) != null) {
                Mutability attributeTypeMutabilityAnn = attributeType.getAnnotation(Mutability.class);
                if (attributeTypeMutabilityAnn != null) {
                    return this.resolveMutability(attributeTypeMutabilityAnn.value());
                }
                if (attributeType.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    return this.resolveMutability(converterMutabilityAnn.value());
                }
                if (this.converterDescriptor.getAttributeConverterClass().isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.MAP_KEY.mappingAccess.customType(attributeMember, this.getSourceModelContext())) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    return this.resolveMutability(customTypeMutabilityAnn.value());
                }
                if (customTypeImpl.isAnnotationPresent(Immutable.class)) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private void prepareListIndex(MemberDetails attributeMember) {
        this.implicitJavaTypeAccess = typeConfiguration -> Integer.class;
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        ManagedBeanRegistry beanRegistry = this.buildingContext.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class);
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            ListIndexJavaType javaTypeAnn = (ListIndexJavaType)attributeMember.locateAnnotationUsage(ListIndexJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (javaTypeClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                ManagedBean<BasicJavaType<?>> bean = beanRegistry.getBean(javaTypeClass);
                return bean.getBeanInstance();
            }
            return null;
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            Class<? extends JdbcType> jdbcTypeClass;
            ListIndexJdbcType jdbcTypeAnn = (ListIndexJdbcType)attributeMember.locateAnnotationUsage(ListIndexJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                ManagedBean<? extends JdbcType> bean = beanRegistry.getBean(jdbcTypeClass);
                return bean.getBeanInstance();
            }
            ListIndexJdbcTypeCode jdbcTypeCodeAnn = (ListIndexJdbcTypeCode)attributeMember.locateAnnotationUsage(ListIndexJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(jdbcTypeCodeAnn.value());
            }
            return null;
        };
    }

    private void prepareCollectionElement(MemberDetails attributeMember, TypeDetails explicitElementTypeDetails) {
        Class targetClassDetails;
        TypeDetails elementTypeDetails = explicitElementTypeDetails == null && attributeMember.isArray() ? attributeMember.getElementType() : explicitElementTypeDetails;
        ClassDetails rawElementType = elementTypeDetails.determineRawClass();
        Class javaType = rawElementType.toJavaClass();
        Class javaTypeClass = ReflectHelper.getClass(javaType);
        this.implicitJavaTypeAccess = typeConfiguration -> javaType;
        Temporal temporalAnn = (Temporal)attributeMember.getDirectAnnotationUsage(Temporal.class);
        if (temporalAnn != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedAnnotation(Temporal.class, attributeMember.getName());
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + attributeMember.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if (javaTypeClass.isEnum()) {
            Enumerated enumeratedAnn = (Enumerated)attributeMember.getDirectAnnotationUsage(Enumerated.class);
            if (enumeratedAnn != null) {
                this.enumType = enumeratedAnn.value();
                if (this.enumType == null) {
                    throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + attributeMember.getName());
                }
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeMember);
        ElementCollection elementCollectionAnn = (ElementCollection)attributeMember.getDirectAnnotationUsage(ElementCollection.class);
        if (elementCollectionAnn != null && (targetClassDetails = elementCollectionAnn.targetClass()) != Void.TYPE) {
            Function<TypeConfiguration, BasicJavaType> original = this.explicitJavaTypeAccess;
            this.explicitJavaTypeAccess = typeConfiguration -> {
                BasicJavaType originalResult = (BasicJavaType)original.apply((TypeConfiguration)typeConfiguration);
                if (originalResult != null) {
                    return originalResult;
                }
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(targetClassDetails);
            };
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prepareBasicAttribute(String declaringClassName, MemberDetails attributeMember, TypeDetails attributeType) {
        Enumerated enumeratedAnn;
        Class javaTypeClass = attributeType.determineRawClass().toJavaClass();
        this.implicitJavaTypeAccess = typeConfiguration -> {
            if (attributeType.getTypeKind() == TypeDetails.Kind.PARAMETERIZED_TYPE) {
                return ParameterizedTypeImpl.from(attributeType.asParameterizedType());
            }
            return attributeType.determineRawClass().toJavaClass();
        };
        Temporal temporalAnn = (Temporal)attributeMember.getDirectAnnotationUsage(Temporal.class);
        if (temporalAnn != null) {
            DeprecationLogger.DEPRECATION_LOGGER.deprecatedAnnotation(Temporal.class, declaringClassName + "." + attributeMember.getName());
            this.temporalPrecision = temporalAnn.value();
            if (this.temporalPrecision == null) {
                throw new IllegalStateException("No jakarta.persistence.TemporalType defined for @jakarta.persistence.Temporal associated with attribute " + declaringClassName + "." + attributeMember.getName());
            }
        } else {
            this.temporalPrecision = null;
        }
        if ((enumeratedAnn = (Enumerated)attributeMember.getDirectAnnotationUsage(Enumerated.class)) != null) {
            this.enumType = enumeratedAnn.value();
            if (!this.canUseEnumerated(attributeType, javaTypeClass)) throw new AnnotationException(String.format("Property '%s.%s' is annotated '@Enumerated' but its type '%s' is not an enum", declaringClassName, attributeMember.getName(), attributeType.getName()));
            if (this.enumType == null) {
                throw new IllegalStateException("jakarta.persistence.EnumType was null on @jakarta.persistence.Enumerated  associated with attribute " + declaringClassName + "." + attributeMember.getName());
            }
        } else {
            this.enumType = null;
        }
        this.normalSupplementalDetails(attributeMember);
    }

    private boolean canUseEnumerated(TypeDetails javaType, Class<Object> javaTypeClass) {
        ParameterizedTypeDetails parameterizedType;
        List typeArguments;
        if (javaTypeClass.isEnum() || javaTypeClass.isArray() && javaTypeClass.getComponentType().isEnum()) {
            return true;
        }
        if (javaType.isImplementor(Collection.class) && !(typeArguments = (parameterizedType = javaType.asParameterizedType()).getArguments()).isEmpty()) {
            return ((TypeDetails)typeArguments.get(0)).isImplementor(Enum.class);
        }
        return false;
    }

    private void prepareAnyDiscriminator(MemberDetails memberDetails) {
        AnyDiscriminator anyDiscriminatorAnn = (AnyDiscriminator)memberDetails.locateAnnotationUsage(AnyDiscriminator.class, this.getSourceModelContext());
        this.implicitJavaTypeAccess = typeConfiguration -> {
            if (anyDiscriminatorAnn != null) {
                DiscriminatorType anyDiscriminatorType = anyDiscriminatorAnn.value();
                return switch (anyDiscriminatorType) {
                    case DiscriminatorType.CHAR -> Character.class;
                    case DiscriminatorType.INTEGER -> Integer.class;
                    default -> String.class;
                };
            }
            return String.class;
        };
        this.normalJdbcTypeDetails(memberDetails);
        this.normalMutabilityDetails(memberDetails);
        Function<TypeConfiguration, JdbcType> originalJdbcTypeResolution = this.explicitJdbcTypeAccess;
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            JdbcType originalResolution = (JdbcType)originalJdbcTypeResolution.apply((TypeConfiguration)typeConfiguration);
            if (originalResolution != null) {
                return originalResolution;
            }
            Class hintedJavaType = (Class)this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration);
            JavaType hintedDescriptor = typeConfiguration.getJavaTypeRegistry().getDescriptor(hintedJavaType);
            return hintedDescriptor.getRecommendedJdbcType(typeConfiguration.getCurrentBaseSqlTypeIndicators());
        };
    }

    private void prepareAnyKey(MemberDetails memberDetails) {
        this.implicitJavaTypeAccess = typeConfiguration -> null;
        boolean useDeferredBeanContainerAccess = !this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi();
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> implClass;
            AnyKeyJavaType javaTypeAnn = (AnyKeyJavaType)memberDetails.locateAnnotationUsage(AnyKeyJavaType.class, this.getSourceModelContext());
            if (javaTypeAnn != null && (implClass = javaTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(implClass);
                }
                return this.getManagedBeanRegistry().getBean(implClass).getBeanInstance();
            }
            AnyKeyJavaClass javaClassAnn = (AnyKeyJavaClass)memberDetails.locateAnnotationUsage(AnyKeyJavaClass.class, this.getSourceModelContext());
            if (javaClassAnn != null) {
                Class<?> impl = javaClassAnn.value();
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(impl);
            }
            throw new MappingException("Could not determine key type for '@Any' mapping (specify '@AnyKeyJavaType' or '@AnyKeyJavaClass')");
        };
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int code;
            Class<? extends JdbcType> jdbcTypeClass;
            AnyKeyJdbcType jdbcTypeAnn = (AnyKeyJdbcType)memberDetails.locateAnnotationUsage(AnyKeyJdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (useDeferredBeanContainerAccess) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                ManagedBean<? extends JdbcType> jtdBean = this.getManagedBeanRegistry().getBean(jdbcTypeClass);
                return jtdBean.getBeanInstance();
            }
            AnyKeyJdbcTypeCode jdbcTypeCodeAnn = (AnyKeyJdbcTypeCode)memberDetails.locateAnnotationUsage(AnyKeyJdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (code = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                return typeConfiguration.getJdbcTypeRegistry().getDescriptor(code);
            }
            return null;
        };
    }

    private void normalJdbcTypeDetails(MemberDetails attributeMember) {
        this.explicitJdbcTypeAccess = typeConfiguration -> {
            int jdbcTypeCode;
            Class<? extends JdbcType> jdbcTypeClass;
            org.hibernate.annotations.JdbcType jdbcTypeAnn = (org.hibernate.annotations.JdbcType)attributeMember.locateAnnotationUsage(org.hibernate.annotations.JdbcType.class, this.getSourceModelContext());
            if (jdbcTypeAnn != null && (jdbcTypeClass = jdbcTypeAnn.value()) != null) {
                if (!this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(jdbcTypeClass).getBeanInstance();
            }
            JdbcTypeCode jdbcTypeCodeAnn = (JdbcTypeCode)attributeMember.locateAnnotationUsage(JdbcTypeCode.class, this.getSourceModelContext());
            if (jdbcTypeCodeAnn != null && (jdbcTypeCode = jdbcTypeCodeAnn.value()) != Integer.MIN_VALUE) {
                JdbcTypeRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeRegistry();
                if (jdbcTypeRegistry.getConstructor(jdbcTypeCode) != null) {
                    return null;
                }
                return jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
            }
            return null;
        };
    }

    private void normalMutabilityDetails(MemberDetails attributeMember) {
        this.explicitMutabilityAccess = typeConfiguration -> {
            Class<UserType<?>> customTypeImpl;
            Class<? extends MutabilityPlan<?>> mutability;
            Class<? extends MutabilityPlan<?>> mutability2;
            Mutability mutabilityAnn = (Mutability)attributeMember.locateAnnotationUsage(Mutability.class, this.getSourceModelContext());
            if (mutabilityAnn != null && (mutability2 = mutabilityAnn.value()) != null) {
                return this.resolveMutability(mutability2);
            }
            if (attributeMember.hasDirectAnnotationUsage(Immutable.class)) {
                return ImmutableMutabilityPlan.instance();
            }
            if (this.explicitJavaTypeAccess != null || this.implicitJavaTypeAccess != null) {
                java.lang.reflect.Type javaType;
                BasicJavaType jtd;
                Class attributeType = null;
                if (this.explicitJavaTypeAccess != null && (jtd = this.explicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration)) != null) {
                    attributeType = jtd.getJavaTypeClass();
                }
                if (attributeType == null && (javaType = this.implicitJavaTypeAccess.apply((TypeConfiguration)typeConfiguration)) != null) {
                    attributeType = ReflectHelper.getClass(javaType);
                }
                if (attributeType != null) {
                    Mutability classMutability = attributeType.getAnnotation(Mutability.class);
                    if (classMutability != null && (mutability = classMutability.value()) != null) {
                        return this.resolveMutability(mutability);
                    }
                    Immutable classImmutable = attributeType.getAnnotation(Immutable.class);
                    if (classImmutable != null) {
                        return ImmutableMutabilityPlan.instance();
                    }
                }
            }
            if (this.converterDescriptor != null) {
                Mutability converterMutabilityAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Mutability.class);
                if (converterMutabilityAnn != null) {
                    Class<? extends MutabilityPlan<?>> mutability3 = converterMutabilityAnn.value();
                    return this.resolveMutability(mutability3);
                }
                Immutable converterImmutableAnn = this.converterDescriptor.getAttributeConverterClass().getAnnotation(Immutable.class);
                if (converterImmutableAnn != null) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            if ((customTypeImpl = Kind.ATTRIBUTE.mappingAccess.customType(attributeMember, this.getSourceModelContext())) != null) {
                Mutability customTypeMutabilityAnn = customTypeImpl.getAnnotation(Mutability.class);
                if (customTypeMutabilityAnn != null) {
                    mutability = customTypeMutabilityAnn.value();
                    return this.resolveMutability(mutability);
                }
                Immutable customTypeImmutableAnn = customTypeImpl.getAnnotation(Immutable.class);
                if (customTypeImmutableAnn != null) {
                    return ImmutableMutabilityPlan.instance();
                }
            }
            return null;
        };
    }

    private <T> MutabilityPlan<T> resolveMutability(Class<? extends MutabilityPlan> mutability) {
        if (mutability.equals(Immutability.class)) {
            return Immutability.instance();
        }
        if (mutability.equals(ImmutableMutabilityPlan.class)) {
            return ImmutableMutabilityPlan.instance();
        }
        if (!this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
            return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(mutability);
        }
        return this.getManagedBeanRegistry().getBean(mutability).getBeanInstance();
    }

    private void normalSupplementalDetails(MemberDetails attributeMember) {
        TimeZoneStorage timeZoneStorage;
        Temporal temporal;
        this.explicitJavaTypeAccess = typeConfiguration -> {
            Class<? extends BasicJavaType<?>> javaTypeClass;
            org.hibernate.annotations.JavaType javaType = (org.hibernate.annotations.JavaType)attributeMember.locateAnnotationUsage(org.hibernate.annotations.JavaType.class, this.getSourceModelContext());
            if (javaType != null && (javaTypeClass = BasicValueBinder.normalizeJavaType(javaType.value())) != null) {
                if (!this.buildingContext.getBuildingOptions().isAllowExtensionsInCdi()) {
                    return FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass);
                }
                return this.getManagedBeanRegistry().getBean(javaTypeClass).getBeanInstance();
            }
            Target targetAnn = (Target)attributeMember.locateAnnotationUsage(Target.class, this.getSourceModelContext());
            if (targetAnn != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedAnnotation(Target.class, attributeMember.getName());
                return (BasicJavaType)typeConfiguration.getJavaTypeRegistry().getDescriptor(targetAnn.value());
            }
            return null;
        };
        JdbcTypeCode jdbcType = (JdbcTypeCode)attributeMember.locateAnnotationUsage(JdbcTypeCode.class, this.getSourceModelContext());
        if (jdbcType != null) {
            this.jdbcTypeCode = jdbcType.value();
        }
        this.normalJdbcTypeDetails(attributeMember);
        this.normalMutabilityDetails(attributeMember);
        Enumerated enumerated = (Enumerated)attributeMember.getDirectAnnotationUsage(Enumerated.class);
        if (enumerated != null) {
            this.enumType = enumerated.value();
        }
        if ((temporal = (Temporal)attributeMember.getDirectAnnotationUsage(Temporal.class)) != null) {
            this.temporalPrecision = temporal.value();
        }
        if ((timeZoneStorage = (TimeZoneStorage)attributeMember.getDirectAnnotationUsage(TimeZoneStorage.class)) != null) {
            this.timeZoneStorageType = timeZoneStorage.value();
            TimeZoneColumn timeZoneColumnAnn = (TimeZoneColumn)attributeMember.getDirectAnnotationUsage(TimeZoneColumn.class);
            if (timeZoneColumnAnn != null && this.timeZoneStorageType != TimeZoneStorageType.AUTO && this.timeZoneStorageType != TimeZoneStorageType.COLUMN) {
                throw new IllegalStateException("@TimeZoneColumn can not be used in conjunction with @TimeZoneStorage( " + this.timeZoneStorageType + " ) with attribute " + attributeMember.getDeclaringType().getName() + "." + attributeMember.getName());
            }
        }
        this.partitionKey = attributeMember.hasDirectAnnotationUsage(PartitionKey.class);
    }

    private static Class<? extends UserType<?>> normalizeUserType(Class<? extends UserType<?>> userType) {
        return userType;
    }

    private Class<? extends JdbcType> normalizeJdbcType(Class<? extends JdbcType> jdbcType) {
        return jdbcType;
    }

    private static Class<? extends BasicJavaType<?>> normalizeJavaType(Class<? extends BasicJavaType<?>> javaType) {
        return javaType;
    }

    @Override
    public Dialect getDialect() {
        return this.buildingContext.getMetadataCollector().getDatabase().getDialect();
    }

    private void applyJpaConverter(MemberDetails attributeMember, ConverterDescriptor attributeConverterDescriptor) {
        if (attributeConverterDescriptor == null) {
            return;
        }
        LOG.debugf("Applying JPA converter [%s:%s]", this.persistentClassName, attributeMember.getName());
        if (attributeMember.hasDirectAnnotationUsage(Id.class)) {
            LOG.debugf("Skipping AttributeConverter checks for Id attribute [%s]", attributeMember.getName());
            return;
        }
        if (attributeMember.hasDirectAnnotationUsage(Version.class)) {
            LOG.debugf("Skipping AttributeConverter checks for version attribute [%s]", attributeMember.getName());
            return;
        }
        if (this.kind == Kind.MAP_KEY) {
            if (attributeMember.hasDirectAnnotationUsage(MapKeyTemporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyTemporal [%s]", attributeMember.getName());
                return;
            }
            if (attributeMember.hasDirectAnnotationUsage(MapKeyEnumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for map-key annotated as MapKeyEnumerated [%s]", attributeMember.getName());
                return;
            }
        } else {
            if (attributeMember.hasDirectAnnotationUsage(Temporal.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Temporal attribute [%s]", attributeMember.getName());
                return;
            }
            if (attributeMember.hasDirectAnnotationUsage(Enumerated.class)) {
                LOG.debugf("Skipping AttributeConverter checks for Enumerated attribute [%s]", attributeMember.getName());
                return;
            }
        }
        if (this.isAssociation()) {
            LOG.debugf("Skipping AttributeConverter checks for association attribute [%s]", attributeMember.getName());
            return;
        }
        this.converterDescriptor = attributeConverterDescriptor;
    }

    private boolean isAssociation() {
        return this.referencedEntityName != null;
    }

    public void setExplicitType(String explicitType) {
        this.explicitBasicTypeName = explicitType;
    }

    public BasicValue make() {
        if (this.basicValue != null) {
            return this.basicValue;
        }
        this.columns.checkPropertyConsistency();
        LOG.debugf("building BasicValue for %s", this.propertyName);
        if (this.table == null) {
            this.table = this.columns.getTable();
        }
        this.basicValue = new BasicValue(this.buildingContext, this.table);
        if (this.columns.getPropertyHolder().isComponent()) {
            ComponentPropertyHolder propertyHolder = (ComponentPropertyHolder)this.columns.getPropertyHolder();
            this.basicValue.setAggregateColumn(propertyHolder.getAggregateColumn());
        }
        if (this.isNationalized()) {
            this.basicValue.makeNationalized();
        }
        if (this.isLob()) {
            this.basicValue.makeLob();
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        this.basicValue.setPartitionKey(this.partitionKey);
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.jdbcTypeCode != null) {
            this.basicValue.setExplicitJdbcTypeCode(this.jdbcTypeCode);
        }
        this.linkWithValue();
        boolean isInSecondPass = this.buildingContext.getMetadataCollector().isInSecondPass();
        if (!isInSecondPass) {
            this.buildingContext.getMetadataCollector().addSecondPass(new SetBasicValueTypeSecondPass(this));
        } else {
            this.fillSimpleValue();
        }
        return this.basicValue;
    }

    public void linkWithValue() {
        InFlightMetadataCollector collector = this.buildingContext.getMetadataCollector();
        AnnotatedColumn firstColumn = this.columns.getColumns().get(0);
        if (!collector.isInSecondPass() && firstColumn.isNameDeferred() && this.referencedEntityName != null) {
            AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
            joinColumns.setBuildingContext(this.buildingContext);
            joinColumns.setPropertyHolder(this.columns.getPropertyHolder());
            joinColumns.setPropertyName(this.columns.getPropertyName());
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.setParent(joinColumns);
            }
            collector.addSecondPass(new PkDrivenByDefaultMapsIdSecondPass(this.referencedEntityName, joinColumns, this.basicValue));
        } else if (this.aggregateComponent != null) {
            assert (this.columns.getColumns().size() == 1);
            firstColumn.linkWithAggregateValue(this.basicValue, this.aggregateComponent);
        } else {
            for (AnnotatedColumn column : this.columns.getColumns()) {
                column.linkWithValue(this.basicValue);
            }
        }
    }

    public void fillSimpleValue() {
        LOG.debugf("Starting `BasicValueBinder#fillSimpleValue` for %s", this.propertyName);
        String explicitBasicTypeName = this.explicitBasicTypeName != null ? this.explicitBasicTypeName : this.timeStampVersionType;
        this.basicValue.setExplicitTypeName(explicitBasicTypeName);
        this.basicValue.setExplicitTypeParams(this.explicitLocalTypeParams);
        Class typeClass = null;
        if (explicitBasicTypeName != null) {
            TypeDefinition typeDefinition = this.buildingContext.getTypeDefinitionRegistry().resolve(explicitBasicTypeName);
            if (typeDefinition == null) {
                BasicType registeredType = this.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(explicitBasicTypeName);
                if (registeredType == null) {
                    typeClass = this.buildingContext.getBootstrapContext().getClassLoaderAccess().classForName(explicitBasicTypeName);
                }
            } else {
                typeClass = typeDefinition.getTypeImplementorClass();
            }
        } else if (this.enumType != null || this.isEnum()) {
            typeClass = EnumType.class;
        } else if (this.isLob || this.isSerializable()) {
            typeClass = SerializableToBlobType.class;
        }
        if (this.explicitCustomType != null && DynamicParameterizedType.class.isAssignableFrom(this.explicitCustomType) || typeClass != null && DynamicParameterizedType.class.isAssignableFrom(typeClass)) {
            this.basicValue.setTypeParameters(this.createDynamicParameterizedTypeParameters());
        }
        if (this.converterDescriptor != null) {
            this.basicValue.setJpaAttributeConverterDescriptor(this.converterDescriptor);
        }
        if (this.implicitJavaTypeAccess != null) {
            this.basicValue.setImplicitJavaTypeAccess(this.implicitJavaTypeAccess);
        }
        if (this.explicitJavaTypeAccess != null) {
            this.basicValue.setExplicitJavaTypeAccess(this.explicitJavaTypeAccess);
        }
        if (this.explicitJdbcTypeAccess != null) {
            this.basicValue.setExplicitJdbcTypeAccess(this.explicitJdbcTypeAccess);
        }
        if (this.explicitMutabilityAccess != null) {
            this.basicValue.setExplicitMutabilityPlanAccess(this.explicitMutabilityAccess);
        }
        if (this.enumType != null) {
            this.basicValue.setEnumerationStyle(this.enumType);
        }
        if (this.timeZoneStorageType != null) {
            this.basicValue.setTimeZoneStorageType(this.timeZoneStorageType);
        }
        if (this.temporalPrecision != null) {
            this.basicValue.setTemporalPrecision(this.temporalPrecision);
        }
        if (this.isLob()) {
            this.basicValue.makeLob();
        }
        if (this.isNationalized()) {
            this.basicValue.makeNationalized();
        }
        if (this.explicitCustomType != null) {
            this.basicValue.setExplicitCustomType(this.explicitCustomType);
        }
    }

    private Map<String, Object> createDynamicParameterizedTypeParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (this.returnedClassName == null) {
            throw new MappingException("Returned class name not specified for basic mapping: " + this.xproperty.getName());
        }
        parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        parameters.put("org.hibernate.type.ParameterType.xproperty", this.xproperty);
        parameters.put("org.hibernate.type.ParameterType.propertyName", this.xproperty.getName());
        parameters.put("org.hibernate.type.ParameterType.dynamic", Boolean.toString(true));
        parameters.put("org.hibernate.type.ParameterType.primaryKey", Boolean.toString(this.kind == Kind.MAP_KEY));
        if (this.persistentClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.entityClass", this.persistentClassName);
        }
        if (this.returnedClassName != null) {
            parameters.put("org.hibernate.type.ParameterType.returnedClass", this.returnedClassName);
        }
        if (this.accessType != null) {
            parameters.put("org.hibernate.type.ParameterType.accessType", this.accessType.getType());
        }
        if (this.explicitLocalTypeParams != null) {
            parameters.putAll(this.explicitLocalTypeParams);
        }
        return parameters;
    }

    private boolean isEnum() {
        Class clazz = null;
        if (this.implicitJavaTypeAccess != null) {
            java.lang.reflect.Type type = this.implicitJavaTypeAccess.apply(this.getTypeConfiguration());
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                clazz = (Class)type;
            }
        }
        return clazz != null && clazz.isEnum();
    }

    private boolean isSerializable() {
        Class clazz = null;
        if (this.implicitJavaTypeAccess != null) {
            java.lang.reflect.Type type = this.implicitJavaTypeAccess.apply(this.getTypeConfiguration());
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (type instanceof Class) {
                clazz = (Class)type;
            }
        }
        return clazz != null && Serializable.class.isAssignableFrom(clazz);
    }

    public static enum Kind {
        ATTRIBUTE(ValueMappingAccess.INSTANCE),
        ANY_DISCRIMINATOR(AnyDiscriminatorMappingAccess.INSTANCE),
        ANY_KEY(AnyKeyMappingAccess.INSTANCE),
        MAP_KEY(MapKeyMappingAccess.INSTANCE),
        COLLECTION_ELEMENT(ValueMappingAccess.INSTANCE),
        COLLECTION_ID(CollectionIdMappingAccess.INSTANCE),
        LIST_INDEX(ListIndexMappingAccess.INSTANCE);

        private final BasicMappingAccess mappingAccess;

        private Kind(BasicMappingAccess mappingAccess) {
            this.mappingAccess = mappingAccess;
        }
    }

    private static interface BasicMappingAccess {
        public Class<? extends UserType<?>> customType(MemberDetails var1, SourceModelBuildingContext var2);

        public Map<String, String> customTypeParameters(MemberDetails var1, SourceModelBuildingContext var2);
    }

    private static class ListIndexMappingAccess
    implements BasicMappingAccess {
        public static final ListIndexMappingAccess INSTANCE = new ListIndexMappingAccess();

        private ListIndexMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            return null;
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            return Collections.emptyMap();
        }
    }

    private static class CollectionIdMappingAccess
    implements BasicMappingAccess {
        public static final CollectionIdMappingAccess INSTANCE = new CollectionIdMappingAccess();

        private CollectionIdMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attributeMember, SourceModelBuildingContext sourceModelBuildingContext) {
            CollectionIdType customType = (CollectionIdType)attributeMember.locateAnnotationUsage(CollectionIdType.class, sourceModelBuildingContext);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            CollectionIdType customType = (CollectionIdType)attributeMember.locateAnnotationUsage(CollectionIdType.class, sourceModelContext);
            if (customType == null) {
                return null;
            }
            return AnnotationHelper.extractParameterMap(customType.parameters());
        }
    }

    private static class MapKeyMappingAccess
    implements BasicMappingAccess {
        public static final MapKeyMappingAccess INSTANCE = new MapKeyMappingAccess();

        private MapKeyMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            MapKeyType customType = (MapKeyType)attributeMember.locateAnnotationUsage(MapKeyType.class, sourceModelContext);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            MapKeyType customType = (MapKeyType)attributeMember.locateAnnotationUsage(MapKeyType.class, sourceModelContext);
            if (customType == null) {
                return null;
            }
            return AnnotationHelper.extractParameterMap(customType.parameters());
        }
    }

    private static class AnyKeyMappingAccess
    implements BasicMappingAccess {
        public static final AnyKeyMappingAccess INSTANCE = new AnyKeyMappingAccess();

        private AnyKeyMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            return null;
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            return Collections.emptyMap();
        }
    }

    private static class AnyDiscriminatorMappingAccess
    implements BasicMappingAccess {
        public static final AnyDiscriminatorMappingAccess INSTANCE = new AnyDiscriminatorMappingAccess();

        private AnyDiscriminatorMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            return null;
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            return Collections.emptyMap();
        }
    }

    private static class ValueMappingAccess
    implements BasicMappingAccess {
        public static final ValueMappingAccess INSTANCE = new ValueMappingAccess();

        private ValueMappingAccess() {
        }

        @Override
        public Class<? extends UserType<?>> customType(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            Type customType = (Type)attributeMember.locateAnnotationUsage(Type.class, sourceModelContext);
            if (customType == null) {
                return null;
            }
            return BasicValueBinder.normalizeUserType(customType.value());
        }

        @Override
        public Map<String, String> customTypeParameters(MemberDetails attributeMember, SourceModelBuildingContext sourceModelContext) {
            Type customType = (Type)attributeMember.locateAnnotationUsage(Type.class, sourceModelContext);
            if (customType == null) {
                return null;
            }
            return AnnotationHelper.extractParameterMap(customType.parameters());
        }
    }
}

