/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Internal;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.id.enhanced.LegacyNamingStrategy;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.SingleNamingStrategy;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;

public class GeneratorParameters {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(GeneratorBinder.class);

    public static Properties collectParameters(SimpleValue identifierValue, Dialect dialect, RootClass rootClass, Map<String, Object> configuration) {
        ConfigurationService configService = identifierValue.getMetadata().getMetadataBuildingOptions().getServiceRegistry().requireService(ConfigurationService.class);
        Properties params = new Properties();
        params.setProperty("initial_value", String.valueOf(1));
        params.setProperty("increment_size", String.valueOf(GeneratorParameters.defaultIncrement(configService)));
        String tableName = identifierValue.getTable().getQuotedName(dialect);
        params.setProperty("target_table", tableName);
        Column column = (Column)identifierValue.getSelectables().get(0);
        String columnName = column.getQuotedName(dialect);
        params.setProperty("target_column", columnName);
        if (rootClass != null) {
            params.setProperty("entity_name", rootClass.getEntityName());
            params.setProperty("jpa_entity_name", rootClass.getJpaEntityName());
            params.setProperty("implicit_name_base", identifierValue.getTable().isSubselect() ? rootClass.getJpaEntityName() : identifierValue.getTable().getName());
            params.setProperty("identity_tables", GeneratorParameters.identityTablesString(dialect, rootClass));
        } else {
            params.setProperty("identity_tables", tableName);
            params.setProperty("implicit_name_base", tableName);
        }
        params.put("CONTRIBUTOR", identifierValue.getBuildingContext().getCurrentContributorName());
        Map<String, Object> settings = configService.getSettings();
        if (settings.containsKey("hibernate.id.optimizer.pooled.preferred")) {
            params.put("hibernate.id.optimizer.pooled.preferred", settings.get("hibernate.id.optimizer.pooled.preferred"));
        }
        params.putAll(configuration);
        return params;
    }

    private static String identityTablesString(Dialect dialect, RootClass rootClass) {
        StringBuilder tables = new StringBuilder();
        for (Table table : rootClass.getIdentityTables()) {
            tables.append(table.getQuotedName(dialect));
            if (tables.isEmpty()) continue;
            tables.append(", ");
        }
        return tables.toString();
    }

    private static int defaultIncrement(ConfigurationService configService) {
        String idNamingStrategy = configService.getSetting("hibernate.id.db_structure_naming_strategy", StandardConverters.STRING, null);
        if ("legacy".equals(idNamingStrategy) || LegacyNamingStrategy.class.getName().equals(idNamingStrategy) || "single".equals(idNamingStrategy) || SingleNamingStrategy.class.getName().equals(idNamingStrategy)) {
            return 1;
        }
        return 50;
    }

    @Internal
    public static void interpretTableGenerator(TableGenerator tableGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        String options;
        String valueColumnName;
        String pkColumnValue;
        String pkColumnName;
        String table;
        String schema;
        definitionBuilder.setName(tableGeneratorAnnotation.name());
        definitionBuilder.setStrategy(org.hibernate.id.enhanced.TableGenerator.class.getName());
        definitionBuilder.addParam("prefer_entity_table_as_segment_value", "true");
        String catalog = tableGeneratorAnnotation.catalog();
        if (StringHelper.isNotEmpty(catalog)) {
            definitionBuilder.addParam("catalog", catalog);
        }
        if (StringHelper.isNotEmpty(schema = tableGeneratorAnnotation.schema())) {
            definitionBuilder.addParam("schema", schema);
        }
        if (StringHelper.isNotEmpty(table = tableGeneratorAnnotation.table())) {
            definitionBuilder.addParam("table_name", table);
        }
        if (StringHelper.isNotEmpty(pkColumnName = tableGeneratorAnnotation.pkColumnName())) {
            definitionBuilder.addParam("segment_column_name", pkColumnName);
        }
        if (StringHelper.isNotEmpty(pkColumnValue = tableGeneratorAnnotation.pkColumnValue())) {
            definitionBuilder.addParam("segment_value", pkColumnValue);
        }
        if (StringHelper.isNotEmpty(valueColumnName = tableGeneratorAnnotation.valueColumnName())) {
            definitionBuilder.addParam("value_column_name", valueColumnName);
        }
        if (StringHelper.isNotEmpty(options = tableGeneratorAnnotation.options())) {
            definitionBuilder.addParam("options", options);
        }
        definitionBuilder.addParam("increment_size", String.valueOf(tableGeneratorAnnotation.allocationSize()));
        definitionBuilder.addParam("initial_value", String.valueOf(tableGeneratorAnnotation.initialValue() + 1));
        Object[] uniqueConstraints = tableGeneratorAnnotation.uniqueConstraints();
        if (CollectionHelper.isNotEmpty(uniqueConstraints)) {
            LOG.ignoringTableGeneratorConstraints(tableGeneratorAnnotation.name());
        }
    }

    @Internal
    public static void interpretSequenceGenerator(SequenceGenerator sequenceGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        String sequenceName;
        String schema;
        definitionBuilder.setName(sequenceGeneratorAnnotation.name());
        definitionBuilder.setStrategy(SequenceStyleGenerator.class.getName());
        String catalog = sequenceGeneratorAnnotation.catalog();
        if (StringHelper.isNotEmpty(catalog)) {
            definitionBuilder.addParam("catalog", catalog);
        }
        if (StringHelper.isNotEmpty(schema = sequenceGeneratorAnnotation.schema())) {
            definitionBuilder.addParam("schema", schema);
        }
        if (StringHelper.isNotEmpty(sequenceName = sequenceGeneratorAnnotation.sequenceName())) {
            definitionBuilder.addParam("sequence_name", sequenceName);
        }
        definitionBuilder.addParam("increment_size", String.valueOf(sequenceGeneratorAnnotation.allocationSize()));
        definitionBuilder.addParam("initial_value", String.valueOf(sequenceGeneratorAnnotation.initialValue()));
        String options = sequenceGeneratorAnnotation.options();
        if (StringHelper.isNotEmpty(options)) {
            definitionBuilder.addParam("options", options);
        }
    }
}

