/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.OrderColumn;
import java.util.Map;
import org.hibernate.annotations.ListIndexBase;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Join;

public class IndexColumn
extends AnnotatedColumn {
    private int base;

    public IndexColumn() {
        this.setLength(0L);
        this.setPrecision(0);
        this.setScale(0);
    }

    public static IndexColumn fromAnnotations(OrderColumn orderColumn, org.hibernate.annotations.IndexColumn indexColumn, ListIndexBase listIndexBase, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        IndexColumn column;
        if (orderColumn != null) {
            column = IndexColumn.buildColumnFromOrderColumn(orderColumn, propertyHolder, inferredData, secondaryTables, context);
        } else if (indexColumn != null) {
            column = IndexColumn.buildColumnFromIndexColumn(indexColumn, propertyHolder, inferredData, context);
            column.setBase(indexColumn.base());
        } else {
            column = new IndexColumn();
            column.setLogicalColumnName(inferredData.getPropertyName() + "_ORDER");
            column.setImplicit(true);
            IndexColumn.createParent(propertyHolder, secondaryTables, column, context);
            column.bind();
        }
        if (listIndexBase != null) {
            column.setBase(listIndexBase.value());
        }
        return column;
    }

    private static void createParent(PropertyHolder propertyHolder, Map<String, Join> secondaryTables, IndexColumn column, MetadataBuildingContext context) {
        AnnotatedColumns parent = new AnnotatedColumns();
        parent.setPropertyHolder(propertyHolder);
        parent.setJoins(secondaryTables);
        parent.setBuildingContext(context);
        column.setParent(parent);
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public static IndexColumn buildColumnFromOrderColumn(OrderColumn orderColumn, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        if (orderColumn != null) {
            String sqlType = StringHelper.nullIfEmpty(orderColumn.columnDefinition());
            String explicitName = orderColumn.name();
            String name = explicitName.isEmpty() ? inferredData.getPropertyName() + "_ORDER" : explicitName;
            IndexColumn column = new IndexColumn();
            column.setLogicalColumnName(name);
            column.setSqlType(sqlType);
            column.setNullable(orderColumn.nullable());
            column.setInsertable(orderColumn.insertable());
            column.setUpdatable(orderColumn.updatable());
            column.setOptions(orderColumn.options());
            IndexColumn.createParent(propertyHolder, secondaryTables, column, context);
            column.bind();
            return column;
        }
        IndexColumn column = new IndexColumn();
        column.setImplicit(true);
        IndexColumn.createParent(propertyHolder, secondaryTables, column, context);
        column.bind();
        return column;
    }

    public static IndexColumn buildColumnFromIndexColumn(org.hibernate.annotations.IndexColumn indexColumn, PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext context) {
        if (indexColumn != null) {
            String explicitName = indexColumn.name();
            String name = explicitName.isEmpty() ? inferredData.getPropertyName() : explicitName;
            String sqlType = StringHelper.nullIfEmpty(indexColumn.columnDefinition());
            IndexColumn column = new IndexColumn();
            column.setLogicalColumnName(name);
            column.setSqlType(sqlType);
            column.setNullable(indexColumn.nullable());
            column.setBase(indexColumn.base());
            IndexColumn.createParent(propertyHolder, null, column, context);
            column.bind();
            return column;
        }
        IndexColumn column = new IndexColumn();
        column.setImplicit(true);
        IndexColumn.createParent(propertyHolder, null, column, context);
        column.bind();
        return column;
    }
}

