/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Access;
import org.hibernate.MappingException;
import org.hibernate.annotations.Target;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class PropertyInferredData
implements PropertyData {
    private final AccessType defaultAccess;
    private final ClassDetails declaringClass;
    private final TypeVariableScope ownerType;
    private final MemberDetails propertyMember;
    private final MetadataBuildingContext buildingContext;

    public PropertyInferredData(ClassDetails declaringClass, TypeVariableScope ownerType, MemberDetails propertyMember, String propertyAccessor, MetadataBuildingContext buildingContext) {
        this.declaringClass = declaringClass;
        this.ownerType = ownerType;
        this.propertyMember = propertyMember;
        this.defaultAccess = AccessType.getAccessStrategy(propertyAccessor);
        this.buildingContext = buildingContext;
    }

    public String toString() {
        return String.format("PropertyInferredData{property=%s, declaringClass=%s}", this.propertyMember, this.declaringClass);
    }

    @Override
    public AccessType getDefaultAccess() throws MappingException {
        AccessType accessType = this.defaultAccess;
        AccessType jpaAccessType = AccessType.DEFAULT;
        Access access = (Access)this.propertyMember.getDirectAnnotationUsage(Access.class);
        if (access != null) {
            jpaAccessType = AccessType.getAccessStrategy(access.value());
        }
        if (jpaAccessType != AccessType.DEFAULT) {
            accessType = jpaAccessType;
        }
        return accessType;
    }

    @Override
    public String getPropertyName() throws MappingException {
        return this.propertyMember.resolveAttributeName();
    }

    @Override
    public TypeDetails getPropertyType() throws MappingException {
        org.hibernate.boot.internal.Target targetAnnotation = (org.hibernate.boot.internal.Target)this.propertyMember.getDirectAnnotationUsage(org.hibernate.boot.internal.Target.class);
        SourceModelBuildingContext sourceModelContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        if (targetAnnotation != null) {
            String targetName = targetAnnotation.value();
            SourceModelBuildingContext sourceModelBuildingContext = sourceModelContext;
            ClassDetails classDetails = sourceModelBuildingContext.getClassDetailsRegistry().resolveClassDetails(targetName, name -> new DynamicClassDetails(targetName, sourceModelBuildingContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        Target legacyTargetAnnotation = (Target)this.propertyMember.getDirectAnnotationUsage(Target.class);
        if (legacyTargetAnnotation != null) {
            return PropertyInferredData.resolveLegacyTargetAnnotation(legacyTargetAnnotation, sourceModelContext);
        }
        return this.propertyMember.resolveRelativeType(this.ownerType);
    }

    private static ClassTypeDetailsImpl resolveLegacyTargetAnnotation(Target legacyTargetAnnotation, SourceModelBuildingContext sourceModelContext) {
        ClassDetailsRegistry classDetailsRegistry = sourceModelContext.getClassDetailsRegistry();
        ClassDetails targetClassDetails = classDetailsRegistry.resolveClassDetails(legacyTargetAnnotation.value().getName());
        return new ClassTypeDetailsImpl(targetClassDetails, TypeDetails.Kind.CLASS);
    }

    @Override
    public TypeDetails getClassOrElementType() throws MappingException {
        SourceModelBuildingContext sourceModelBuildingContext = this.buildingContext.getMetadataCollector().getSourceModelBuildingContext();
        org.hibernate.boot.internal.Target annotationUsage = (org.hibernate.boot.internal.Target)this.propertyMember.getDirectAnnotationUsage(org.hibernate.boot.internal.Target.class);
        if (annotationUsage != null) {
            String targetName = annotationUsage.value();
            ClassDetails classDetails = sourceModelBuildingContext.getClassDetailsRegistry().resolveClassDetails(targetName, name -> new DynamicClassDetails(targetName, sourceModelBuildingContext));
            return new ClassTypeDetailsImpl(classDetails, TypeDetails.Kind.CLASS);
        }
        Target legacyTargetAnnotation = (Target)this.propertyMember.getDirectAnnotationUsage(Target.class);
        if (legacyTargetAnnotation != null) {
            return PropertyInferredData.resolveLegacyTargetAnnotation(legacyTargetAnnotation, sourceModelBuildingContext);
        }
        return this.propertyMember.resolveRelativeAssociatedType(this.ownerType);
    }

    @Override
    public ClassDetails getClassOrPluralElement() throws MappingException {
        org.hibernate.boot.internal.Target xmlTarget = (org.hibernate.boot.internal.Target)this.propertyMember.getDirectAnnotationUsage(org.hibernate.boot.internal.Target.class);
        if (xmlTarget != null) {
            return this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(xmlTarget.value());
        }
        Target legacyTarget = (Target)this.propertyMember.getDirectAnnotationUsage(Target.class);
        if (legacyTarget != null) {
            String targetName = legacyTarget.value().getName();
            return this.buildingContext.getMetadataCollector().getClassDetailsRegistry().getClassDetails(targetName);
        }
        if (this.propertyMember.isPlural()) {
            return this.propertyMember.getElementType().determineRawClass();
        }
        return this.propertyMember.getAssociatedType().determineRawClass();
    }

    @Override
    public String getClassOrElementName() throws MappingException {
        return this.getClassOrElementType().getName();
    }

    @Override
    public String getTypeName() throws MappingException {
        return this.getPropertyType().getName();
    }

    @Override
    public MemberDetails getAttributeMember() {
        return this.propertyMember;
    }

    @Override
    public ClassDetails getDeclaringClass() {
        return this.declaringClass;
    }
}

