/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumns;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchProfileOverride;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.FetchSecondPass;
import org.hibernate.boot.model.internal.ImplicitToOneJoinTableSecondPass;
import org.hibernate.boot.model.internal.OneToOneSecondPass;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.ToOneFkSecondPass;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class ToOneBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ToOneBinder.class);

    static void bindManyToOne(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, MemberDetails property, AnnotatedJoinColumns joinColumns, PropertyBinder propertyBinder) {
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getDirectAnnotationUsage(jakarta.persistence.ManyToOne.class);
        if (property.hasDirectAnnotationUsage(Column.class) || property.hasDirectAnnotationUsage(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@ManyToOne' association and may not use '@Column' to specify column mappings (use '@JoinColumn' instead)");
        }
        if (joinColumns.hasMappedBy() && ToOneBinder.isIdentifier(propertyHolder, propertyBinder, isIdentifierMapper)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the inverse side of a '@ManyToOne' association and cannot be used as identifier");
        }
        Cascade hibernateCascade = (Cascade)property.getDirectAnnotationUsage(Cascade.class);
        NotFound notFound = (NotFound)property.getDirectAnnotationUsage(NotFound.class);
        NotFoundAction notFoundAction = notFound == null ? null : notFound.action();
        ToOneBinder.matchIgnoreNotFoundWithFetchType(propertyHolder.getEntityName(), property.getName(), notFoundAction, manyToOne.fetch());
        OnDelete onDelete = (OnDelete)property.getDirectAnnotationUsage(OnDelete.class);
        JoinTable joinTable = propertyHolder.getJoinTable(property);
        ToOneBinder.bindManyToOne(BinderHelper.getCascadeStrategy(manyToOne.cascade(), hibernateCascade, false, context), joinColumns, joinTable, !ToOneBinder.isMandatory(manyToOne.optional(), property, notFoundAction), notFoundAction, onDelete == null ? null : onDelete.action(), ToOneBinder.getTargetEntity(inferredData, context), propertyHolder, inferredData, false, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static boolean isIdentifier(PropertyHolder propertyHolder, PropertyBinder propertyBinder, boolean isIdentifierMapper) {
        return propertyBinder.isId() || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass() || isIdentifierMapper;
    }

    private static boolean isMandatory(boolean optional, MemberDetails property, NotFoundAction notFoundAction) {
        return !optional || property.hasDirectAnnotationUsage(Id.class) || property.hasDirectAnnotationUsage(MapsId.class) && notFoundAction != NotFoundAction.IGNORE;
    }

    private static void bindManyToOne(String cascadeStrategy, AnnotatedJoinColumns joinColumns, JoinTable joinTable, boolean optional, NotFoundAction notFoundAction, OnDeleteAction onDeleteAction, ClassDetails targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        if (joinTable != null && !StringHelper.isEmpty(joinTable.name())) {
            Join join = propertyHolder.addJoin(joinTable, false);
            for (AnnotatedJoinColumn annotatedJoinColumn : joinColumns.getJoinColumns()) {
                annotatedJoinColumn.setExplicitTableName(join.getTable().getName());
            }
            if (notFoundAction != null) {
                join.disableForeignKeyCreation();
            }
        }
        ManyToOne value = new ManyToOne(context, joinColumns.getTable());
        if (joinTable != null && StringHelper.isEmpty(joinTable.name())) {
            context.getMetadataCollector().addSecondPass(new ImplicitToOneJoinTableSecondPass(propertyHolder, inferredData, context, joinColumns, joinTable, notFoundAction, value));
        }
        if (unique) {
            value.markAsLogicalOneToOne();
        }
        value.setReferencedEntityName(ToOneBinder.getReferenceEntityName(inferredData, targetEntity));
        MemberDetails property = inferredData.getAttributeMember();
        ToOneBinder.defineFetchingStrategy(value, property, inferredData, propertyHolder);
        value.setNotFoundAction(notFoundAction);
        value.setOnDeleteAction(onDeleteAction);
        if (!optional) {
            for (AnnotatedJoinColumn column : joinColumns.getJoinColumns()) {
                column.setNullable(false);
            }
        }
        if (property.hasDirectAnnotationUsage(MapsId.class)) {
            MapsId mapsId = (MapsId)property.getDirectAnnotationUsage(MapsId.class);
            List<AnnotatedJoinColumn> joinColumnList = joinColumns.getJoinColumns();
            for (AnnotatedJoinColumn column : joinColumnList) {
                column.setInsertable(false);
                column.setUpdatable(false);
            }
            joinColumns.setMapsId(mapsId.value());
        }
        boolean bl = ToOneBinder.handleSpecjSyntax(joinColumns, inferredData, context, property);
        value.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String fullPath = StringHelper.qualify(propertyHolder.getPath(), propertyName);
        ToOneBinder.bindForeignKeyNameAndDefinition(value, property, propertyHolder.getOverriddenForeignKey(fullPath), context);
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass(value, joinColumns, unique, ToOneBinder.isTargetAnnotatedEntity(targetEntity, property), propertyHolder.getPersistentClass(), fullPath, context);
        if (inSecondPass) {
            secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
        } else {
            context.getMetadataCollector().addSecondPass(secondPass);
        }
        ToOneBinder.processManyToOneProperty(cascadeStrategy, joinColumns, optional, inferredData, isIdentifierMapper, propertyBinder, value, property, bl, propertyName);
    }

    static boolean isTargetAnnotatedEntity(ClassDetails targetEntity, MemberDetails property) {
        ClassDetails target = BinderHelper.isDefault(targetEntity) ? property.getType().determineRawClass() : targetEntity;
        return target.hasDirectAnnotationUsage(Entity.class);
    }

    private static boolean handleSpecjSyntax(AnnotatedJoinColumns columns, PropertyData inferredData, MetadataBuildingContext context, MemberDetails property) {
        boolean hasSpecjManyToOne = false;
        if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled()) {
            JoinColumn joinColumn = (JoinColumn)property.getDirectAnnotationUsage(JoinColumn.class);
            String columnName = "";
            for (MemberDetails prop : inferredData.getDeclaringClass().getFields()) {
                String joinColumnName;
                if (prop.hasDirectAnnotationUsage(Id.class) && prop.hasDirectAnnotationUsage(Column.class)) {
                    columnName = ((Column)prop.getDirectAnnotationUsage(Column.class)).name();
                }
                if (!property.hasDirectAnnotationUsage(jakarta.persistence.ManyToOne.class) || joinColumn == null || !StringHelper.isNotEmpty(joinColumnName = joinColumn.name()) || !joinColumnName.equals(columnName) || property.hasDirectAnnotationUsage(MapsId.class)) continue;
                hasSpecjManyToOne = true;
                for (AnnotatedJoinColumn column : columns.getJoinColumns()) {
                    column.setInsertable(false);
                    column.setUpdatable(false);
                }
            }
        }
        return hasSpecjManyToOne;
    }

    private static void processManyToOneProperty(String cascadeStrategy, AnnotatedJoinColumns columns, boolean optional, PropertyData inferredData, boolean isIdentifierMapper, PropertyBinder propertyBinder, ManyToOne value, MemberDetails property, boolean hasSpecjManyToOne, String propertyName) {
        columns.checkPropertyConsistency();
        propertyBinder.setName(propertyName);
        propertyBinder.setValue(value);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        } else if (hasSpecjManyToOne) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setColumns(columns);
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setCascade(cascadeStrategy);
        propertyBinder.setMemberDetails(property);
        propertyBinder.setToMany(true);
        JoinColumn joinColumn = (JoinColumn)property.getDirectAnnotationUsage(JoinColumn.class);
        JoinColumns joinColumns = (JoinColumns)property.getDirectAnnotationUsage(JoinColumns.class);
        propertyBinder.makePropertyAndBind().setOptional(optional && ToOneBinder.isNullable(joinColumns, joinColumn));
    }

    private static boolean isNullable(JoinColumns joinColumns, JoinColumn joinColumn) {
        if (joinColumn != null) {
            return joinColumn.nullable();
        }
        if (joinColumns != null) {
            for (JoinColumn column : joinColumns.value()) {
                if (!column.nullable()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static void defineFetchingStrategy(ToOne toOne, MemberDetails property, PropertyData inferredData, PropertyHolder propertyHolder) {
        ToOneBinder.handleLazy(toOne, property, inferredData, propertyHolder);
        ToOneBinder.handleFetch(toOne, property);
        ToOneBinder.handleFetchProfileOverrides(toOne, property, propertyHolder, inferredData);
    }

    private static void handleLazy(ToOne toOne, MemberDetails property, PropertyData inferredData, PropertyHolder propertyHolder) {
        if (property.hasDirectAnnotationUsage(NotFound.class)) {
            toOne.setLazy(false);
            toOne.setUnwrapProxy(true);
        } else {
            boolean eager = ToOneBinder.isEager(property, inferredData, propertyHolder);
            toOne.setLazy(!eager);
            toOne.setUnwrapProxy(eager);
            toOne.setUnwrapProxyImplicit(true);
        }
    }

    private static void handleFetchProfileOverrides(ToOne toOne, MemberDetails property, PropertyHolder propertyHolder, PropertyData inferredData) {
        MetadataBuildingContext context = toOne.getBuildingContext();
        InFlightMetadataCollector collector = context.getMetadataCollector();
        SourceModelBuildingContext sourceModelContext = collector.getSourceModelBuildingContext();
        property.forEachAnnotationUsage(FetchProfileOverride.class, sourceModelContext, usage -> collector.addSecondPass(new FetchSecondPass((FetchProfileOverride)usage, propertyHolder, inferredData.getPropertyName(), context)));
    }

    private static void handleFetch(ToOne toOne, MemberDetails property) {
        Fetch fetchAnnotationUsage = (Fetch)property.getDirectAnnotationUsage(Fetch.class);
        if (fetchAnnotationUsage != null) {
            ToOneBinder.setHibernateFetchMode(toOne, property, fetchAnnotationUsage.value());
        } else {
            toOne.setFetchMode(BinderHelper.getFetchMode(ToOneBinder.getJpaFetchType(property)));
        }
    }

    private static void setHibernateFetchMode(ToOne toOne, MemberDetails property, org.hibernate.annotations.FetchMode fetchMode) {
        switch (fetchMode) {
            case JOIN: {
                toOne.setFetchMode(FetchMode.JOIN);
                toOne.setLazy(false);
                toOne.setUnwrapProxy(false);
                break;
            }
            case SELECT: {
                toOne.setFetchMode(FetchMode.SELECT);
                break;
            }
            case SUBSELECT: {
                throw new AnnotationException("Association '" + property.getName() + "' is annotated '@Fetch(SUBSELECT)' but is not many-valued");
            }
            default: {
                throw new AssertionFailure("unknown fetch type");
            }
        }
    }

    private static boolean isEager(MemberDetails property, PropertyData inferredData, PropertyHolder propertyHolder) {
        FetchType fetchType = ToOneBinder.getJpaFetchType(property);
        LazyToOne lazyToOneAnnotationUsage = (LazyToOne)property.getDirectAnnotationUsage(LazyToOne.class);
        if (lazyToOneAnnotationUsage != null) {
            boolean eager;
            LazyToOneOption option = lazyToOneAnnotationUsage.value();
            boolean bl = eager = option == LazyToOneOption.FALSE;
            if (eager && fetchType == FetchType.LAZY) {
                throw new AnnotationException("Association '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is marked 'fetch=LAZY' and '@LazyToOne(FALSE)'");
            }
            return eager;
        }
        return fetchType == FetchType.EAGER;
    }

    private static FetchType getJpaFetchType(MemberDetails property) {
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getDirectAnnotationUsage(jakarta.persistence.ManyToOne.class);
        OneToOne oneToOne = (OneToOne)property.getDirectAnnotationUsage(OneToOne.class);
        if (manyToOne != null) {
            return manyToOne.fetch();
        }
        if (oneToOne != null) {
            return oneToOne.fetch();
        }
        throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
    }

    static void bindOneToOne(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, boolean inSecondPass, MetadataBuildingContext context, MemberDetails property, AnnotatedJoinColumns joinColumns, PropertyBinder propertyBinder) {
        OneToOne oneToOne = (OneToOne)property.getDirectAnnotationUsage(OneToOne.class);
        if (property.hasDirectAnnotationUsage(Column.class) || property.hasDirectAnnotationUsage(Columns.class)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is a '@OneToOne' association and may not use '@Column' to specify column mappings (use '@PrimaryKeyJoinColumn' instead)");
        }
        if (joinColumns.hasMappedBy() && ToOneBinder.isIdentifier(propertyHolder, propertyBinder, isIdentifierMapper)) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is the inverse side of a '@OneToOne' association and cannot be used as identifier");
        }
        boolean trueOneToOne = property.hasDirectAnnotationUsage(PrimaryKeyJoinColumn.class) || property.hasDirectAnnotationUsage(PrimaryKeyJoinColumns.class);
        Cascade hibernateCascade = (Cascade)property.getDirectAnnotationUsage(Cascade.class);
        NotFound notFound = (NotFound)property.getDirectAnnotationUsage(NotFound.class);
        NotFoundAction notFoundAction = notFound == null ? null : notFound.action();
        ToOneBinder.matchIgnoreNotFoundWithFetchType(propertyHolder.getEntityName(), property.getName(), notFoundAction, oneToOne.fetch());
        OnDelete onDelete = (OnDelete)property.getDirectAnnotationUsage(OnDelete.class);
        JoinTable joinTable = propertyHolder.getJoinTable(property);
        ToOneBinder.bindOneToOne(BinderHelper.getCascadeStrategy(oneToOne.cascade(), hibernateCascade, oneToOne.orphanRemoval(), context), joinColumns, joinTable, !ToOneBinder.isMandatory(oneToOne.optional(), property, notFoundAction), BinderHelper.getFetchMode(oneToOne.fetch()), notFoundAction, onDelete == null ? null : onDelete.action(), ToOneBinder.getTargetEntity(inferredData, context), property, propertyHolder, inferredData, StringHelper.nullIfEmpty(oneToOne.mappedBy()), trueOneToOne, isIdentifierMapper, inSecondPass, propertyBinder, context);
    }

    private static void bindOneToOne(String cascadeStrategy, AnnotatedJoinColumns joinColumns, JoinTable joinTable, boolean optional, FetchMode fetchMode, NotFoundAction notFoundAction, OnDeleteAction cascadeOnDelete, ClassDetails targetEntity, MemberDetails annotatedProperty, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, PropertyBinder propertyBinder, MetadataBuildingContext context) {
        String propertyName = inferredData.getPropertyName();
        LOG.tracev("Fetching {0} with {1}", propertyName, (Object)fetchMode);
        if (ToOneBinder.isMapToPK(joinColumns, propertyHolder, trueOneToOne) || mappedBy != null) {
            OneToOneSecondPass secondPass = new OneToOneSecondPass(mappedBy, propertyHolder.getEntityName(), propertyHolder, inferredData, ToOneBinder.getReferenceEntityName(inferredData, targetEntity), ToOneBinder.isTargetAnnotatedEntity(targetEntity, annotatedProperty), notFoundAction, cascadeOnDelete, optional, cascadeStrategy, joinColumns, context);
            if (inSecondPass) {
                secondPass.doSecondPass(context.getMetadataCollector().getEntityBindingMap());
            } else {
                context.getMetadataCollector().addSecondPass(secondPass, mappedBy == null);
            }
        } else {
            ToOneBinder.bindManyToOne(cascadeStrategy, joinColumns, joinTable, optional, notFoundAction, cascadeOnDelete, targetEntity, propertyHolder, inferredData, true, isIdentifierMapper, inSecondPass, propertyBinder, context);
        }
    }

    private static boolean isMapToPK(AnnotatedJoinColumns joinColumns, PropertyHolder propertyHolder, boolean trueOneToOne) {
        if (trueOneToOne) {
            return true;
        }
        KeyValue identifier = propertyHolder.getIdentifier();
        if (identifier == null) {
            return false;
        }
        ArrayList<String> idColumnNames = new ArrayList<String>();
        List<AnnotatedJoinColumn> columns = joinColumns.getJoinColumns();
        if (identifier.getColumnSpan() != columns.size()) {
            return false;
        }
        for (org.hibernate.mapping.Column currentColumn : identifier.getColumns()) {
            idColumnNames.add(currentColumn.getName());
        }
        for (AnnotatedJoinColumn column : columns) {
            if (idColumnNames.contains(column.getMappingColumn().getName())) continue;
            return false;
        }
        return true;
    }

    public static void bindForeignKeyNameAndDefinition(SimpleValue value, MemberDetails property, ForeignKey foreignKey, MetadataBuildingContext context) {
        if (property.hasDirectAnnotationUsage(NotFound.class)) {
            value.disableForeignKey();
        } else {
            JoinColumn joinColumn = (JoinColumn)property.getDirectAnnotationUsage(JoinColumn.class);
            JoinColumns joinColumns = (JoinColumns)property.getDirectAnnotationUsage(JoinColumns.class);
            boolean noConstraintByDefault = context.getBuildingOptions().isNoConstraintByDefault();
            if (joinColumn != null && BinderHelper.noConstraint(joinColumn.foreignKey(), noConstraintByDefault) || joinColumns != null && BinderHelper.noConstraint(joinColumns.foreignKey(), noConstraintByDefault)) {
                value.disableForeignKey();
            } else {
                org.hibernate.annotations.ForeignKey fk = (org.hibernate.annotations.ForeignKey)property.getDirectAnnotationUsage(org.hibernate.annotations.ForeignKey.class);
                if (fk != null && StringHelper.isNotEmpty(fk.name())) {
                    value.setForeignKeyName(fk.name());
                } else if (BinderHelper.noConstraint(foreignKey, noConstraintByDefault)) {
                    value.disableForeignKey();
                } else if (foreignKey != null) {
                    value.setForeignKeyName(StringHelper.nullIfEmpty(foreignKey.name()));
                    value.setForeignKeyDefinition(StringHelper.nullIfEmpty(foreignKey.foreignKeyDefinition()));
                } else if (noConstraintByDefault) {
                    value.disableForeignKey();
                } else if (joinColumns != null) {
                    ForeignKey joinColumnsForeignKey = joinColumns.foreignKey();
                    value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumnsForeignKey.name()));
                    value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumnsForeignKey.foreignKeyDefinition()));
                } else if (joinColumn != null) {
                    ForeignKey joinColumnForeignKey = joinColumn.foreignKey();
                    value.setForeignKeyName(StringHelper.nullIfEmpty(joinColumnForeignKey.name()));
                    value.setForeignKeyDefinition(StringHelper.nullIfEmpty(joinColumnForeignKey.foreignKeyDefinition()));
                }
            }
        }
    }

    public static String getReferenceEntityName(PropertyData propertyData, ClassDetails targetEntity) {
        return BinderHelper.isDefault(targetEntity) ? propertyData.getClassOrElementName() : targetEntity.getName();
    }

    public static String getReferenceEntityName(PropertyData propertyData, MetadataBuildingContext context) {
        return ToOneBinder.getReferenceEntityName(propertyData, ToOneBinder.getTargetEntity(propertyData, context));
    }

    public static ClassDetails getTargetEntity(PropertyData propertyData, MetadataBuildingContext context) {
        return ToOneBinder.getTargetEntityClass(propertyData.getAttributeMember(), context);
    }

    private static ClassDetails getTargetEntityClass(MemberDetails property, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        jakarta.persistence.ManyToOne manyToOne = (jakarta.persistence.ManyToOne)property.getDirectAnnotationUsage(jakarta.persistence.ManyToOne.class);
        if (manyToOne != null) {
            return sourceModelContext.getClassDetailsRegistry().resolveClassDetails(manyToOne.targetEntity().getName());
        }
        OneToOne oneToOne = (OneToOne)property.getDirectAnnotationUsage(OneToOne.class);
        if (oneToOne != null) {
            return sourceModelContext.getClassDetailsRegistry().resolveClassDetails(oneToOne.targetEntity().getName());
        }
        throw new AssertionFailure("Unexpected discovery of a targetEntity: " + property.getName());
    }

    private static void matchIgnoreNotFoundWithFetchType(String entity, String association, NotFoundAction notFoundAction, FetchType fetchType) {
        if (notFoundAction != null && fetchType == FetchType.LAZY) {
            LOG.ignoreNotFoundWithFetchTypeLazy(entity, association);
        }
    }
}

