/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import jakarta.persistence.AttributeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.BootLogging;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.JaxbBindableMappingDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.internal.log.DeprecationLogger;

public class ManagedResourcesImpl
implements ManagedResources {
    private final Map<Class<? extends AttributeConverter>, ConverterDescriptor> attributeConverterDescriptorMap = new HashMap<Class<? extends AttributeConverter>, ConverterDescriptor>();
    private final Set<Class<?>> annotatedClassReferences = new LinkedHashSet();
    private final Set<String> annotatedClassNames = new LinkedHashSet<String>();
    private final Set<String> annotatedPackageNames = new LinkedHashSet<String>();
    private final List<Binding<JaxbBindableMappingDescriptor>> mappingFileBindings = new ArrayList<Binding<JaxbBindableMappingDescriptor>>();
    private Map<String, Class<?>> extraQueryImports;

    public static ManagedResourcesImpl baseline(MetadataSources sources, BootstrapContext bootstrapContext) {
        ManagedResourcesImpl impl = new ManagedResourcesImpl();
        bootstrapContext.getAttributeConverters().forEach(impl::addAttributeConverterDefinition);
        impl.annotatedClassReferences.addAll(sources.getAnnotatedClasses());
        impl.annotatedClassNames.addAll(sources.getAnnotatedClassNames());
        impl.annotatedPackageNames.addAll(sources.getAnnotatedPackages());
        ManagedResourcesImpl.handleXmlMappings(sources, impl, bootstrapContext);
        impl.extraQueryImports = sources.getExtraQueryImports();
        return impl;
    }

    private static void handleXmlMappings(MetadataSources sources, ManagedResourcesImpl impl, BootstrapContext bootstrapContext) {
        boolean transformHbm;
        impl.mappingFileBindings.addAll(sources.getMappingXmlBindings());
        if (!bootstrapContext.getMetadataBuildingOptions().isXmlMappingEnabled()) {
            BootLogging.BOOT_LOGGER.debugf("Ignoring %s XML mappings due to `%s`", sources.getMappingXmlBindings().size(), (Object)"hibernate.xml_mapping_enabled");
            return;
        }
        ConfigurationService configurationService = bootstrapContext.getServiceRegistry().getService(ConfigurationService.class);
        boolean bl = transformHbm = configurationService != null && configurationService.getSetting("hibernate.transform_hbm_xml.enabled", StandardConverters.BOOLEAN, Boolean.valueOf(false)) != false;
        if (!transformHbm) {
            impl.mappingFileBindings.addAll(sources.getHbmXmlBindings());
            for (Binding<JaxbHbmHibernateMapping> hbmXmlBinding : sources.getHbmXmlBindings()) {
                Origin origin = hbmXmlBinding.getOrigin();
                DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedHbmXmlProcessing(origin.getType(), origin.getName());
            }
        } else {
            List<Binding<JaxbEntityMappingsImpl>> transformed = HbmXmlTransformer.transform(sources.getHbmXmlBindings(), UnsupportedFeatureHandling.fromSetting(configurationService.getSettings().get("hibernate.transform_hbm_xml.unsupported_feature_handling"), UnsupportedFeatureHandling.ERROR));
            impl.mappingFileBindings.addAll(transformed);
        }
    }

    @Override
    public Collection<ConverterDescriptor> getAttributeConverterDescriptors() {
        return Collections.unmodifiableCollection(this.attributeConverterDescriptorMap.values());
    }

    @Override
    public Collection<Class<?>> getAnnotatedClassReferences() {
        return Collections.unmodifiableSet(this.annotatedClassReferences);
    }

    @Override
    public Collection<String> getAnnotatedClassNames() {
        return Collections.unmodifiableSet(this.annotatedClassNames);
    }

    @Override
    public Collection<String> getAnnotatedPackageNames() {
        return Collections.unmodifiableSet(this.annotatedPackageNames);
    }

    @Override
    public Collection<Binding<JaxbBindableMappingDescriptor>> getXmlMappingBindings() {
        return Collections.unmodifiableList(this.mappingFileBindings);
    }

    @Override
    public Map<String, Class<?>> getExtraQueryImports() {
        return this.extraQueryImports;
    }

    @Internal
    public void addAttributeConverterDefinition(ConverterDescriptor descriptor) {
        this.attributeConverterDescriptorMap.put(descriptor.getAttributeConverterClass(), descriptor);
    }

    @Internal
    public void addAnnotatedClassReference(Class<?> annotatedClassReference) {
        this.annotatedClassReferences.add(annotatedClassReference);
    }

    @Internal
    public void addAnnotatedClassName(String annotatedClassName) {
        this.annotatedClassNames.add(annotatedClassName);
    }

    @Internal
    public void addAnnotatedPackageName(String annotatedPackageName) {
        this.annotatedPackageNames.add(annotatedPackageName);
    }

    @Internal
    public void addXmlBinding(Binding<JaxbBindableMappingDescriptor> binding) {
        this.mappingFileBindings.add(binding);
    }
}

