/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.AttributeAccessor;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.jboss.jandex.AnnotationInstance;

public class AttributeAccessorAnnotation
implements AttributeAccessor {
    private String value;
    private Class<? extends PropertyAccessStrategy> strategy;

    public AttributeAccessorAnnotation(SourceModelBuildingContext modelContext) {
        this.value = "";
        this.strategy = PropertyAccessStrategy.class;
    }

    public AttributeAccessorAnnotation(AttributeAccessor annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
        this.strategy = annotation.strategy();
    }

    public AttributeAccessorAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.ATTRIBUTE_ACCESSOR, "value", modelContext);
        this.strategy = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.ATTRIBUTE_ACCESSOR, "strategy", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return AttributeAccessor.class;
    }

    @Override
    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
    }

    @Override
    public Class<? extends PropertyAccessStrategy> strategy() {
        return this.strategy;
    }

    public void strategy(Class<? extends PropertyAccessStrategy> value) {
        this.strategy = value;
    }
}

