/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.Cacheable;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class CacheableJpaAnnotation
implements Cacheable {
    private boolean value;

    public CacheableJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.value = true;
    }

    public CacheableJpaAnnotation(Cacheable annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
    }

    public CacheableJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CACHEABLE, "value", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return Cacheable.class;
    }

    public boolean value() {
        return this.value;
    }

    public void value(boolean value) {
        this.value = value;
    }
}

