/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.Column;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.CollectionId;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class CollectionIdAnnotation
implements CollectionId {
    private Column column;
    private Class<? extends IdentifierGenerator> generatorImplementation;
    private String generator;

    public CollectionIdAnnotation(SourceModelBuildingContext modelContext) {
        this.column = (Column)JpaAnnotations.COLUMN.createUsage(modelContext);
        this.generatorImplementation = IdentifierGenerator.class;
        this.generator = "";
    }

    public CollectionIdAnnotation(CollectionId annotation, SourceModelBuildingContext modelContext) {
        this.column = (Column)OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.COLLECTION_ID, "column", modelContext);
        this.generatorImplementation = annotation.generatorImplementation();
        this.generator = annotation.generator();
    }

    public CollectionIdAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.column = (Column)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.COLLECTION_ID, "column", modelContext);
        this.generatorImplementation = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.COLLECTION_ID, "generatorImplementation", modelContext);
        this.generator = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.COLLECTION_ID, "generator", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CollectionId.class;
    }

    @Override
    public Column column() {
        return this.column;
    }

    public void column(Column value) {
        this.column = value;
    }

    @Override
    public Class<? extends IdentifierGenerator> generatorImplementation() {
        return this.generatorImplementation;
    }

    public void generatorImplementation(Class<? extends IdentifierGenerator> value) {
        this.generatorImplementation = value;
    }

    @Override
    public String generator() {
        return this.generator;
    }

    public void generator(String value) {
        this.generator = value;
    }
}

