/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ColumnTransformerAnnotation
implements ColumnTransformer {
    private String forColumn;
    private String read;
    private String write;

    public ColumnTransformerAnnotation(SourceModelBuildingContext modelContext) {
        this.forColumn = "";
        this.read = "";
        this.write = "";
    }

    public ColumnTransformerAnnotation(ColumnTransformer annotation, SourceModelBuildingContext modelContext) {
        this.forColumn = annotation.forColumn();
        this.read = annotation.read();
        this.write = annotation.write();
    }

    public ColumnTransformerAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.forColumn = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.COLUMN_TRANSFORMER, "forColumn", modelContext);
        this.read = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.COLUMN_TRANSFORMER, "read", modelContext);
        this.write = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.COLUMN_TRANSFORMER, "write", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ColumnTransformer.class;
    }

    @Override
    public String forColumn() {
        return this.forColumn;
    }

    public void forColumn(String value) {
        this.forColumn = value;
    }

    @Override
    public String read() {
        return this.read;
    }

    public void read(String value) {
        this.read = value;
    }

    @Override
    public String write() {
        return this.write;
    }

    public void write(String value) {
        this.write = value;
    }
}

