/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Convert;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ConvertJpaAnnotation
implements Convert {
    private Class<? extends AttributeConverter> converter;
    private String attributeName;
    private boolean disableConversion;

    public ConvertJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.converter = AttributeConverter.class;
        this.attributeName = "";
        this.disableConversion = false;
    }

    public ConvertJpaAnnotation(Convert annotation, SourceModelBuildingContext modelContext) {
        this.converter = annotation.converter();
        this.attributeName = annotation.attributeName();
        this.disableConversion = annotation.disableConversion();
    }

    public ConvertJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.converter = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CONVERT, "converter", modelContext);
        this.attributeName = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CONVERT, "attributeName", modelContext);
        this.disableConversion = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.CONVERT, "disableConversion", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return Convert.class;
    }

    public Class<? extends AttributeConverter> converter() {
        return this.converter;
    }

    public void converter(Class<? extends AttributeConverter> value) {
        this.converter = value;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public void attributeName(String value) {
        this.attributeName = value;
    }

    public boolean disableConversion() {
        return this.disableConversion;
    }

    public void disableConversion(boolean value) {
        this.disableConversion = value;
    }
}

