/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.CurrentTimestamp;
import org.hibernate.annotations.SourceType;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.generator.EventType;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.tuple.GenerationTiming;
import org.jboss.jandex.AnnotationInstance;

public class CurrentTimestampAnnotation
implements CurrentTimestamp {
    private EventType[] event;
    private GenerationTiming timing;
    private SourceType source;

    public CurrentTimestampAnnotation(SourceModelBuildingContext modelContext) {
        this.event = new EventType[0];
        this.timing = GenerationTiming.ALWAYS;
        this.source = SourceType.DB;
    }

    public CurrentTimestampAnnotation(CurrentTimestamp annotation, SourceModelBuildingContext modelContext) {
        this.event = annotation.event();
        this.timing = annotation.timing();
        this.source = annotation.source();
    }

    public CurrentTimestampAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.event = (EventType[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.CURRENT_TIMESTAMP, "event", modelContext);
        this.timing = (GenerationTiming)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.CURRENT_TIMESTAMP, "timing", modelContext));
        this.source = (SourceType)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.CURRENT_TIMESTAMP, "source", modelContext));
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CurrentTimestamp.class;
    }

    @Override
    public EventType[] event() {
        return this.event;
    }

    public void event(EventType[] value) {
        this.event = value;
    }

    @Override
    public GenerationTiming timing() {
        return this.timing;
    }

    public void timing(GenerationTiming value) {
        this.timing = value;
    }

    @Override
    public SourceType source() {
        return this.source;
    }

    public void source(SourceType value) {
        this.source = value;
    }
}

