/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.DiscriminatorType;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class DiscriminatorFormulaAnnotation
implements DiscriminatorFormula {
    private String value;
    private DiscriminatorType discriminatorType;

    public DiscriminatorFormulaAnnotation(SourceModelBuildingContext modelContext) {
        this.discriminatorType = DiscriminatorType.STRING;
    }

    public DiscriminatorFormulaAnnotation(DiscriminatorFormula annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
        this.discriminatorType = annotation.discriminatorType();
    }

    public DiscriminatorFormulaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.DISCRIMINATOR_FORMULA, "value", modelContext);
        this.discriminatorType = (DiscriminatorType)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.DISCRIMINATOR_FORMULA, "discriminatorType", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return DiscriminatorFormula.class;
    }

    @Override
    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
    }

    @Override
    public DiscriminatorType discriminatorType() {
        return this.discriminatorType;
    }

    public void discriminatorType(DiscriminatorType value) {
        this.discriminatorType = value;
    }
}

