/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.DiscriminatorOptions;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class DiscriminatorOptionsAnnotation
implements DiscriminatorOptions {
    private boolean force;
    private boolean insert;

    public DiscriminatorOptionsAnnotation(SourceModelBuildingContext modelContext) {
        this.force = false;
        this.insert = true;
    }

    public DiscriminatorOptionsAnnotation(DiscriminatorOptions annotation, SourceModelBuildingContext modelContext) {
        this.force = annotation.force();
        this.insert = annotation.insert();
    }

    public DiscriminatorOptionsAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.force = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.DISCRIMINATOR_OPTIONS, "force", modelContext);
        this.insert = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.DISCRIMINATOR_OPTIONS, "insert", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return DiscriminatorOptions.class;
    }

    @Override
    public boolean force() {
        return this.force;
    }

    public void force(boolean value) {
        this.force = value;
    }

    @Override
    public boolean insert() {
        return this.insert;
    }

    public void insert(boolean value) {
        this.insert = value;
    }
}

