/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class DynamicInsertAnnotation
implements DynamicInsert {
    private boolean value;

    public DynamicInsertAnnotation(SourceModelBuildingContext modelContext) {
        this.value = true;
    }

    public DynamicInsertAnnotation(DynamicInsert annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
    }

    public DynamicInsertAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.DYNAMIC_INSERT, "value", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return DynamicInsert.class;
    }

    @Override
    public boolean value() {
        return this.value;
    }

    public void value(boolean value) {
        this.value = value;
    }
}

