/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class DynamicUpdateAnnotation
implements DynamicUpdate {
    private boolean value;

    public DynamicUpdateAnnotation(SourceModelBuildingContext modelContext) {
        this.value = true;
    }

    public DynamicUpdateAnnotation(DynamicUpdate annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
    }

    public DynamicUpdateAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.DYNAMIC_UPDATE, "value", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return DynamicUpdate.class;
    }

    @Override
    public boolean value() {
        return this.value;
    }

    public void value(boolean value) {
        this.value = value;
    }
}

