/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ElementCollection;
import jakarta.persistence.FetchType;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.spi.AttributeMarker;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ElementCollectionJpaAnnotation
implements ElementCollection,
AttributeMarker.Fetchable {
    private Class<?> targetClass;
    private FetchType fetch;

    public ElementCollectionJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.targetClass = Void.TYPE;
        this.fetch = FetchType.LAZY;
    }

    public ElementCollectionJpaAnnotation(ElementCollection annotation, SourceModelBuildingContext modelContext) {
        this.targetClass = annotation.targetClass();
        this.fetch = annotation.fetch();
    }

    public ElementCollectionJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.targetClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ELEMENT_COLLECTION, "targetClass", modelContext);
        this.fetch = (FetchType)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.ELEMENT_COLLECTION, "fetch", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ElementCollection.class;
    }

    public Class<?> targetClass() {
        return this.targetClass;
    }

    public void targetClass(Class<?> value) {
        this.targetClass = value;
    }

    @Override
    public FetchType fetch() {
        return this.fetch;
    }

    @Override
    public void fetch(FetchType value) {
        this.fetch = value;
    }
}

