/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ForeignKeyAnnotation
implements ForeignKey {
    private String name;
    private String inverseName;

    public ForeignKeyAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.inverseName = "";
    }

    public ForeignKeyAnnotation(ForeignKey annotation, SourceModelBuildingContext modelContext) {
        this.name(annotation.name());
        this.inverseName(annotation.inverseName());
    }

    public ForeignKeyAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name((String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.FOREIGN_KEY, "name", modelContext));
        this.inverseName((String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.FOREIGN_KEY, "inverseName", modelContext));
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ForeignKey.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String inverseName() {
        return this.inverseName;
    }

    public void inverseName(String value) {
        this.inverseName = value;
    }
}

