/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.annotations.GeneratorType;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.tuple.ValueGenerator;
import org.jboss.jandex.AnnotationInstance;

public class GeneratorTypeAnnotation
implements GeneratorType {
    private Class<? extends ValueGenerator<?>> type;
    private GenerationTime when;

    public GeneratorTypeAnnotation(SourceModelBuildingContext modelContext) {
        this.when = GenerationTime.ALWAYS;
    }

    public GeneratorTypeAnnotation(GeneratorType annotation, SourceModelBuildingContext modelContext) {
        this.type = annotation.type();
        this.when = annotation.when();
    }

    public GeneratorTypeAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.type = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERATOR_TYPE, "type", modelContext);
        this.when = (GenerationTime)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERATOR_TYPE, "when", modelContext));
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return GeneratorType.class;
    }

    @Override
    public Class<? extends ValueGenerator<?>> type() {
        return this.type;
    }

    public void type(Class<? extends ValueGenerator<?>> value) {
        this.type = value;
    }

    @Override
    public GenerationTime when() {
        return this.when;
    }

    public void when(GenerationTime value) {
        this.when = value;
    }
}

