/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.generator.Generator;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class GenericGeneratorAnnotation
implements GenericGenerator {
    private String name;
    private Class<? extends Generator> type;
    private String strategy;
    private Parameter[] parameters;

    public GenericGeneratorAnnotation(SourceModelBuildingContext modelContext) {
        this.type = Generator.class;
        this.strategy = "native";
        this.parameters = new Parameter[0];
    }

    public GenericGeneratorAnnotation(GenericGenerator annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.type = annotation.type();
        this.strategy = annotation.strategy();
        this.parameters = (Parameter[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.GENERIC_GENERATOR, "parameters", modelContext);
    }

    public GenericGeneratorAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERIC_GENERATOR, "name", modelContext);
        this.type = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERIC_GENERATOR, "type", modelContext);
        this.strategy = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERIC_GENERATOR, "strategy", modelContext);
        this.parameters = (Parameter[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.GENERIC_GENERATOR, "parameters", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return GenericGenerator.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public Class<? extends Generator> type() {
        return this.type;
    }

    public void type(Class<? extends Generator> value) {
        this.type = value;
    }

    @Override
    public String strategy() {
        return this.strategy;
    }

    public void strategy(String value) {
        this.strategy = value;
    }

    @Override
    public Parameter[] parameters() {
        return this.parameters;
    }

    public void parameters(Parameter[] value) {
        this.parameters = value;
    }
}

