/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class IndexColumnAnnotation
implements IndexColumn {
    private String name;
    private int base;
    private boolean nullable;
    private String columnDefinition;

    public IndexColumnAnnotation(SourceModelBuildingContext modelContext) {
        this.base = 0;
        this.nullable = true;
        this.columnDefinition = "";
    }

    public IndexColumnAnnotation(IndexColumn annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.base = annotation.base();
        this.nullable = annotation.nullable();
        this.columnDefinition = annotation.columnDefinition();
    }

    public IndexColumnAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.INDEX_COLUMN, "name", modelContext);
        this.base = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.INDEX_COLUMN, "base", modelContext);
        this.nullable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.INDEX_COLUMN, "nullable", modelContext);
        this.columnDefinition = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.INDEX_COLUMN, "columnDefinition", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return IndexColumn.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public int base() {
        return this.base;
    }

    public void base(int value) {
        this.base = value;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    public void nullable(boolean value) {
        this.nullable = value;
    }

    @Override
    public String columnDefinition() {
        return this.columnDefinition;
    }

    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }
}

