/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.JdbcTypeRegistration;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.jboss.jandex.AnnotationInstance;

public class JdbcTypeRegistrationAnnotation
implements JdbcTypeRegistration {
    private Class<? extends JdbcType> value;
    private int registrationCode;

    public JdbcTypeRegistrationAnnotation(SourceModelBuildingContext modelContext) {
        this.registrationCode = Integer.MIN_VALUE;
    }

    public JdbcTypeRegistrationAnnotation(JdbcTypeRegistration annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
        this.registrationCode = annotation.registrationCode();
    }

    public JdbcTypeRegistrationAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.JDBC_TYPE_REGISTRATION, "value", modelContext);
        this.registrationCode = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.JDBC_TYPE_REGISTRATION, "registrationCode", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JdbcTypeRegistration.class;
    }

    @Override
    public Class<? extends JdbcType> value() {
        return this.value;
    }

    public void value(Class<? extends JdbcType> value) {
        this.value = value;
    }

    @Override
    public int registrationCode() {
        return this.registrationCode;
    }

    public void registrationCode(int value) {
        this.registrationCode = value;
    }
}

