/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CheckConstraint;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKeyJoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class JoinColumnJpaAnnotation
implements JoinColumn {
    private String name;
    private String referencedColumnName;
    private boolean unique;
    private boolean nullable;
    private boolean insertable;
    private boolean updatable;
    private String columnDefinition;
    private String options;
    private String table;
    private ForeignKey foreignKey;
    private CheckConstraint[] check;
    private String comment;

    public JoinColumnJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.referencedColumnName = "";
        this.unique = false;
        this.nullable = true;
        this.insertable = true;
        this.updatable = true;
        this.columnDefinition = "";
        this.options = "";
        this.table = "";
        this.foreignKey = (ForeignKey)JpaAnnotations.FOREIGN_KEY.createUsage(modelContext);
        this.check = new CheckConstraint[0];
        this.comment = "";
    }

    public JoinColumnJpaAnnotation(JoinColumn annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.referencedColumnName = annotation.referencedColumnName();
        this.unique = annotation.unique();
        this.nullable = annotation.nullable();
        this.insertable = annotation.insertable();
        this.updatable = annotation.updatable();
        this.columnDefinition = annotation.columnDefinition();
        this.options = annotation.options();
        this.table = annotation.table();
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_COLUMN, "foreignKey", modelContext);
        this.check = (CheckConstraint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.JOIN_COLUMN, "check", modelContext);
        this.comment = annotation.comment();
    }

    public JoinColumnJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "name", modelContext);
        this.referencedColumnName = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "referencedColumnName", modelContext);
        this.unique = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "unique", modelContext);
        this.nullable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "nullable", modelContext);
        this.insertable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "insertable", modelContext);
        this.updatable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "updatable", modelContext);
        this.columnDefinition = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "columnDefinition", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "options", modelContext);
        this.table = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "table", modelContext);
        this.foreignKey = (ForeignKey)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "foreignKey", modelContext);
        this.check = (CheckConstraint[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "check", modelContext);
        this.comment = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.JOIN_COLUMN, "comment", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return JoinColumn.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String referencedColumnName() {
        return this.referencedColumnName;
    }

    public void referencedColumnName(String value) {
        this.referencedColumnName = value;
    }

    public boolean unique() {
        return this.unique;
    }

    public void unique(boolean value) {
        this.unique = value;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public void nullable(boolean value) {
        this.nullable = value;
    }

    public boolean insertable() {
        return this.insertable;
    }

    public void insertable(boolean value) {
        this.insertable = value;
    }

    public boolean updatable() {
        return this.updatable;
    }

    public void updatable(boolean value) {
        this.updatable = value;
    }

    public String columnDefinition() {
        return this.columnDefinition;
    }

    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }

    public String table() {
        return this.table;
    }

    public void table(String value) {
        this.table = value;
    }

    public ForeignKey foreignKey() {
        return this.foreignKey;
    }

    public void foreignKey(ForeignKey value) {
        this.foreignKey = value;
    }

    public CheckConstraint[] check() {
        return this.check;
    }

    public void check(CheckConstraint[] value) {
        this.check = value;
    }

    public String comment() {
        return this.comment;
    }

    public void comment(String value) {
        this.comment = value;
    }

    public void apply(JaxbJoinColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getTable())) {
            this.table(jaxbColumn.getTable());
        }
        if (jaxbColumn.isNullable() != null) {
            this.nullable(jaxbColumn.isNullable());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.insertable(jaxbColumn.isInsertable());
        }
        if (jaxbColumn.isUpdatable() != null) {
            this.updatable(jaxbColumn.isUpdatable());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
        if (jaxbColumn.isUnique() != null) {
            this.unique(jaxbColumn.isUnique());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getComment())) {
            this.comment(jaxbColumn.getComment());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getReferencedColumnName())) {
            this.referencedColumnName(jaxbColumn.getReferencedColumnName());
        }
        if (jaxbColumn.getForeignKey() != null) {
            this.foreignKey(ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbColumn.getForeignKey(), xmlDocumentContext));
        }
        this.check(XmlAnnotationHelper.collectCheckConstraints(jaxbColumn.getCheckConstraints(), xmlDocumentContext));
    }

    public void apply(JaxbColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getTable())) {
            this.table(jaxbColumn.getTable());
        }
        if (jaxbColumn.isNullable() != null) {
            this.nullable(jaxbColumn.isNullable());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.insertable(jaxbColumn.isInsertable());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.updatable(jaxbColumn.isUpdatable());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
        if (jaxbColumn.isUnique() != null) {
            this.unique(jaxbColumn.isUnique());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getComment())) {
            this.comment(jaxbColumn.getComment());
        }
        this.check(XmlAnnotationHelper.collectCheckConstraints(jaxbColumn.getCheckConstraints(), xmlDocumentContext));
    }

    public static JoinColumn toJoinColumn(PrimaryKeyJoinColumn pkJoinColumn, SourceModelBuildingContext sourceModelBuildingContext) {
        JoinColumnJpaAnnotation joinColumn = (JoinColumnJpaAnnotation)((Object)JpaAnnotations.JOIN_COLUMN.createUsage(sourceModelBuildingContext));
        joinColumn.name(pkJoinColumn.name());
        joinColumn.referencedColumnName(pkJoinColumn.referencedColumnName());
        joinColumn.columnDefinition(pkJoinColumn.columnDefinition());
        joinColumn.options(pkJoinColumn.options());
        joinColumn.foreignKey(pkJoinColumn.foreignKey());
        return joinColumn;
    }

    public static JoinColumn toJoinColumn(MapKeyJoinColumn mapKeyJoinColumn, SourceModelBuildingContext sourceModelBuildingContext) {
        JoinColumnJpaAnnotation joinColumn = (JoinColumnJpaAnnotation)((Object)JpaAnnotations.JOIN_COLUMN.createUsage(sourceModelBuildingContext));
        joinColumn.name(mapKeyJoinColumn.name());
        joinColumn.table(mapKeyJoinColumn.table());
        joinColumn.referencedColumnName(mapKeyJoinColumn.referencedColumnName());
        joinColumn.nullable(mapKeyJoinColumn.nullable());
        joinColumn.unique(mapKeyJoinColumn.unique());
        joinColumn.insertable(mapKeyJoinColumn.insertable());
        joinColumn.updatable(mapKeyJoinColumn.updatable());
        joinColumn.columnDefinition(mapKeyJoinColumn.columnDefinition());
        joinColumn.options(mapKeyJoinColumn.options());
        joinColumn.foreignKey(mapKeyJoinColumn.foreignKey());
        return joinColumn;
    }
}

