/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class JoinFormulaAnnotation
implements JoinFormula {
    private String value;
    private String referencedColumnName;

    public JoinFormulaAnnotation(SourceModelBuildingContext modelContext) {
        this.referencedColumnName = "";
    }

    public JoinFormulaAnnotation(JoinFormula annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
        this.referencedColumnName = annotation.referencedColumnName();
    }

    public JoinFormulaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.JOIN_FORMULA, "value", modelContext);
        this.referencedColumnName = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.JOIN_FORMULA, "referencedColumnName", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return JoinFormula.class;
    }

    @Override
    public String value() {
        return this.value;
    }

    public void value(String value) {
        this.value = value;
    }

    @Override
    public String referencedColumnName() {
        return this.referencedColumnName;
    }

    public void referencedColumnName(String value) {
        this.referencedColumnName = value;
    }
}

