/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.QueryHint;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class NamedNativeQueryJpaAnnotation
implements NamedNativeQuery {
    private String name;
    private String query;
    private QueryHint[] hints;
    private Class<?> resultClass;
    private String resultSetMapping;
    private EntityResult[] entities;
    private ConstructorResult[] classes;
    private ColumnResult[] columns;

    public NamedNativeQueryJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.hints = new QueryHint[0];
        this.resultClass = Void.TYPE;
        this.resultSetMapping = "";
        this.entities = new EntityResult[0];
        this.classes = new ConstructorResult[0];
        this.columns = new ColumnResult[0];
    }

    public NamedNativeQueryJpaAnnotation(NamedNativeQuery annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.query = annotation.query();
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "hints", modelContext);
        this.resultClass = annotation.resultClass();
        this.resultSetMapping = annotation.resultSetMapping();
        this.entities = (EntityResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "entities", modelContext);
        this.classes = (ConstructorResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "classes", modelContext);
        this.columns = (ColumnResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "columns", modelContext);
    }

    public NamedNativeQueryJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "name", modelContext);
        this.query = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "query", modelContext);
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "hints", modelContext);
        this.resultClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "resultClass", modelContext);
        this.resultSetMapping = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "resultSetMapping", modelContext);
        this.entities = (EntityResult[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "entities", modelContext);
        this.classes = (ConstructorResult[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "classes", modelContext);
        this.columns = (ColumnResult[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_NATIVE_QUERY, "columns", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return NamedNativeQuery.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String query() {
        return this.query;
    }

    public void query(String value) {
        this.query = value;
    }

    public QueryHint[] hints() {
        return this.hints;
    }

    public void hints(QueryHint[] value) {
        this.hints = value;
    }

    public Class<?> resultClass() {
        return this.resultClass;
    }

    public void resultClass(Class<?> value) {
        this.resultClass = value;
    }

    public String resultSetMapping() {
        return this.resultSetMapping;
    }

    public void resultSetMapping(String value) {
        this.resultSetMapping = value;
    }

    public EntityResult[] entities() {
        return this.entities;
    }

    public void entities(EntityResult[] value) {
        this.entities = value;
    }

    public ConstructorResult[] classes() {
        return this.classes;
    }

    public void classes(ConstructorResult[] value) {
        this.classes = value;
    }

    public ColumnResult[] columns() {
        return this.columns;
    }

    public void columns(ColumnResult[] value) {
        this.columns = value;
    }

    public void apply(JaxbNamedNativeQueryImpl jaxbNamedQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbNamedQuery.getName());
        this.query(jaxbNamedQuery.getQuery());
        this.hints(QueryProcessing.collectQueryHints(jaxbNamedQuery.getHints(), xmlDocumentContext));
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultClass())) {
            MutableClassDetails resultClassDetails = xmlDocumentContext.resolveJavaType(jaxbNamedQuery.getResultClass());
            this.resultClass(resultClassDetails.toJavaClass());
        }
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultSetMapping())) {
            this.resultSetMapping(jaxbNamedQuery.getResultSetMapping());
        }
        this.columns(QueryProcessing.extractColumnResults(jaxbNamedQuery.getColumnResult(), xmlDocumentContext));
        this.classes(QueryProcessing.extractConstructorResults(jaxbNamedQuery.getConstructorResult(), xmlDocumentContext));
        this.entities(QueryProcessing.extractEntityResults(jaxbNamedQuery.getEntityResult(), xmlDocumentContext));
    }
}

