/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import java.lang.annotation.Annotation;
import org.hibernate.CacheMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class NamedQueryAnnotation
implements NamedQuery {
    private String name;
    private String query;
    private Class<?> resultClass;
    private FlushModeType flushMode;
    boolean cacheable;
    String cacheRegion;
    int fetchSize;
    int timeout;
    String comment;
    CacheStoreMode cacheStoreMode;
    CacheRetrieveMode cacheRetrieveMode;
    CacheModeType cacheMode;
    boolean readOnly;

    public NamedQueryAnnotation(SourceModelBuildingContext modelContext) {
        this.resultClass = Void.TYPE;
        this.flushMode = FlushModeType.PERSISTENCE_CONTEXT;
        this.cacheable = false;
        this.cacheRegion = "";
        this.fetchSize = -1;
        this.timeout = -1;
        this.comment = "";
        this.cacheStoreMode = CacheStoreMode.USE;
        this.cacheRetrieveMode = CacheRetrieveMode.USE;
        this.cacheMode = CacheModeType.NORMAL;
        this.readOnly = false;
    }

    public NamedQueryAnnotation(NamedQuery annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.query = annotation.query();
        this.resultClass = annotation.resultClass();
        this.flushMode = annotation.flushMode();
        this.cacheable = annotation.cacheable();
        this.cacheRegion = annotation.cacheRegion();
        this.fetchSize = annotation.fetchSize();
        this.timeout = annotation.timeout();
        this.comment = annotation.comment();
        this.cacheStoreMode = annotation.cacheStoreMode();
        this.cacheRetrieveMode = annotation.cacheRetrieveMode();
        this.cacheMode = annotation.cacheMode();
        this.readOnly = annotation.readOnly();
    }

    public NamedQueryAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "name", modelContext);
        this.query = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "query", modelContext);
        this.resultClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "resultClass", modelContext);
        this.flushMode = (FlushModeType)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "flushMode", modelContext));
        this.cacheable = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "cacheable", modelContext);
        this.cacheRegion = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "cacheRegion", modelContext);
        this.fetchSize = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "fetchSize", modelContext);
        this.timeout = (Integer)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "timeout", modelContext);
        this.comment = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "comment", modelContext);
        this.cacheStoreMode = (CacheStoreMode)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "cacheStoreMode", modelContext);
        this.cacheRetrieveMode = (CacheRetrieveMode)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "cacheRetrieveMode", modelContext);
        this.cacheMode = (CacheModeType)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "cacheMode", modelContext));
        this.readOnly = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.NAMED_QUERY, "readOnly", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NamedQuery.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String query() {
        return this.query;
    }

    public void query(String value) {
        this.query = value;
    }

    @Override
    public Class<?> resultClass() {
        return this.resultClass;
    }

    public void resultClass(Class<?> value) {
        this.resultClass = value;
    }

    @Override
    public FlushModeType flushMode() {
        return this.flushMode;
    }

    public void flushMode(FlushModeType value) {
        this.flushMode = value;
    }

    @Override
    public boolean cacheable() {
        return this.cacheable;
    }

    public void cacheable(boolean value) {
        this.cacheable = value;
    }

    @Override
    public String cacheRegion() {
        return this.cacheRegion;
    }

    public void cacheRegion(String value) {
        this.cacheRegion = value;
    }

    @Override
    public int fetchSize() {
        return this.fetchSize;
    }

    public void fetchSize(int value) {
        this.fetchSize = value;
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    public void timeout(int value) {
        this.timeout = value;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public void comment(String value) {
        this.comment = value;
    }

    @Override
    public CacheStoreMode cacheStoreMode() {
        return this.cacheStoreMode;
    }

    public void cacheStoreMode(CacheStoreMode value) {
        this.cacheStoreMode = value;
    }

    @Override
    public CacheRetrieveMode cacheRetrieveMode() {
        return this.cacheRetrieveMode;
    }

    public void cacheRetrieveMode(CacheRetrieveMode value) {
        this.cacheRetrieveMode = value;
    }

    @Override
    public CacheModeType cacheMode() {
        return this.cacheMode;
    }

    public void cacheMode(CacheModeType value) {
        this.cacheMode = value;
    }

    @Override
    public boolean readOnly() {
        return this.readOnly;
    }

    public void readOnly(boolean value) {
        this.readOnly = value;
    }

    public void apply(JaxbNamedQueryImpl jaxbNamedQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbNamedQuery.getName());
        this.query(jaxbNamedQuery.getQuery());
        if (jaxbNamedQuery.isCacheable() != null) {
            boolean cacheable = jaxbNamedQuery.isCacheable();
            this.cacheable(cacheable);
            if (cacheable) {
                CacheMode cacheMode;
                if (StringHelper.isNotEmpty(jaxbNamedQuery.getCacheRegion())) {
                    this.cacheRegion(jaxbNamedQuery.getCacheRegion());
                }
                if ((cacheMode = jaxbNamedQuery.getCacheMode()) != null && cacheMode != CacheMode.IGNORE) {
                    this.cacheMode(CacheModeType.fromCacheMode(cacheMode));
                }
            }
        }
        if (jaxbNamedQuery.getFetchSize() != null) {
            this.fetchSize(jaxbNamedQuery.getFetchSize());
        }
        if (jaxbNamedQuery.getTimeout() != null) {
            this.timeout(jaxbNamedQuery.getTimeout());
        }
        if (StringHelper.isNotEmpty(jaxbNamedQuery.getComment())) {
            this.comment(jaxbNamedQuery.getComment());
        }
        if (jaxbNamedQuery.isReadOnly() != null) {
            this.readOnly(jaxbNamedQuery.isReadOnly());
        }
        if (jaxbNamedQuery.getFlushMode() != null) {
            this.flushMode(QueryProcessing.interpretFlushMode(jaxbNamedQuery.getFlushMode()));
        }
    }
}

