/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.LockModeType;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.QueryHint;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class NamedQueryJpaAnnotation
implements NamedQuery {
    private String name;
    private String query;
    private Class<?> resultClass;
    private LockModeType lockMode;
    private QueryHint[] hints;

    public NamedQueryJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.resultClass = Void.TYPE;
        this.lockMode = LockModeType.NONE;
        this.hints = new QueryHint[0];
    }

    public NamedQueryJpaAnnotation(NamedQuery annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.query = annotation.query();
        this.resultClass = annotation.resultClass();
        this.lockMode = annotation.lockMode();
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_QUERY, "hints", modelContext);
    }

    public NamedQueryJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_QUERY, "name", modelContext);
        this.query = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_QUERY, "query", modelContext);
        this.resultClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_QUERY, "resultClass", modelContext);
        this.lockMode = (LockModeType)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_QUERY, "lockMode", modelContext);
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_QUERY, "hints", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return NamedQuery.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String query() {
        return this.query;
    }

    public void query(String value) {
        this.query = value;
    }

    public Class<?> resultClass() {
        return this.resultClass;
    }

    public void resultClass(Class<?> value) {
        this.resultClass = value;
    }

    public LockModeType lockMode() {
        return this.lockMode;
    }

    public void lockMode(LockModeType value) {
        this.lockMode = value;
    }

    public QueryHint[] hints() {
        return this.hints;
    }

    public void hints(QueryHint[] value) {
        this.hints = value;
    }

    public void apply(JaxbNamedQueryImpl jaxbNamedQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbNamedQuery.getName());
        this.query(jaxbNamedQuery.getQuery());
        this.lockMode(NullnessHelper.coalesce(jaxbNamedQuery.getLockMode(), LockModeType.NONE));
        this.hints(QueryProcessing.collectQueryHints(jaxbNamedQuery.getHints(), xmlDocumentContext));
    }
}

