/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.QueryHint;
import jakarta.persistence.StoredProcedureParameter;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedStoredProcedureQueryImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class NamedStoredProcedureQueryJpaAnnotation
implements NamedStoredProcedureQuery {
    private String name;
    private String procedureName;
    private StoredProcedureParameter[] parameters;
    private Class[] resultClasses;
    private String[] resultSetMappings;
    private QueryHint[] hints;

    public NamedStoredProcedureQueryJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.parameters = new StoredProcedureParameter[0];
        this.resultClasses = new Class[0];
        this.resultSetMappings = new String[0];
        this.hints = new QueryHint[0];
    }

    public NamedStoredProcedureQueryJpaAnnotation(NamedStoredProcedureQuery annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.procedureName = annotation.procedureName();
        this.parameters = (StoredProcedureParameter[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "parameters", modelContext);
        this.resultClasses = annotation.resultClasses();
        this.resultSetMappings = annotation.resultSetMappings();
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "hints", modelContext);
    }

    public NamedStoredProcedureQueryJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "name", modelContext);
        this.procedureName = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "procedureName", modelContext);
        this.parameters = (StoredProcedureParameter[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "parameters", modelContext);
        this.resultClasses = (Class[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "resultClasses", modelContext);
        this.resultSetMappings = (String[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "resultSetMappings", modelContext);
        this.hints = (QueryHint[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, "hints", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return NamedStoredProcedureQuery.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String procedureName() {
        return this.procedureName;
    }

    public void procedureName(String value) {
        this.procedureName = value;
    }

    public StoredProcedureParameter[] parameters() {
        return this.parameters;
    }

    public void parameters(StoredProcedureParameter[] value) {
        this.parameters = value;
    }

    public Class[] resultClasses() {
        return this.resultClasses;
    }

    public void resultClasses(Class[] value) {
        this.resultClasses = value;
    }

    public String[] resultSetMappings() {
        return this.resultSetMappings;
    }

    public void resultSetMappings(String[] value) {
        this.resultSetMappings = value;
    }

    public QueryHint[] hints() {
        return this.hints;
    }

    public void hints(QueryHint[] value) {
        this.hints = value;
    }

    public void apply(JaxbNamedStoredProcedureQueryImpl jaxbQuery, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbQuery.getName());
        this.procedureName(jaxbQuery.getProcedureName());
        this.hints(QueryProcessing.collectQueryHints(jaxbQuery.getHints(), xmlDocumentContext));
        this.parameters(QueryProcessing.collectParameters(jaxbQuery.getProcedureParameters(), xmlDocumentContext));
        this.resultClasses(QueryProcessing.collectResultClasses(jaxbQuery.getResultClasses(), xmlDocumentContext));
        this.resultSetMappings(QueryProcessing.collectResultMappings(jaxbQuery.getResultClasses(), xmlDocumentContext));
    }
}

