/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedSubgraph;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class NamedSubgraphJpaAnnotation
implements NamedSubgraph {
    private String name;
    private Class<?> type;
    private NamedAttributeNode[] attributeNodes;

    public NamedSubgraphJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.type = Void.TYPE;
    }

    public NamedSubgraphJpaAnnotation(NamedSubgraph annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.type = annotation.type();
        this.attributeNodes = (NamedAttributeNode[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.NAMED_SUBGRAPH, "attributeNodes", modelContext);
    }

    public NamedSubgraphJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_SUBGRAPH, "name", modelContext);
        this.type = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_SUBGRAPH, "type", modelContext);
        this.attributeNodes = (NamedAttributeNode[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.NAMED_SUBGRAPH, "attributeNodes", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return NamedSubgraph.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public Class<?> type() {
        return this.type;
    }

    public void type(Class<?> value) {
        this.type = value;
    }

    public NamedAttributeNode[] attributeNodes() {
        return this.attributeNodes;
    }

    public void attributeNodes(NamedAttributeNode[] value) {
        this.attributeNodes = value;
    }
}

