/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.hibernate.annotations.ParamDef;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ParamDefAnnotation
implements ParamDef {
    private String name;
    private Class<?> type;
    private Class<? extends Supplier> resolver;

    public ParamDefAnnotation(SourceModelBuildingContext modelContext) {
        this.resolver = Supplier.class;
    }

    public ParamDefAnnotation(ParamDef annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.type = annotation.type();
        this.resolver = annotation.resolver();
    }

    public ParamDefAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.PARAM_DEF, "name", modelContext);
        this.type = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.PARAM_DEF, "type", modelContext);
        this.resolver = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.PARAM_DEF, "resolver", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ParamDef.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    public void type(Class<?> value) {
        this.type = value;
    }

    @Override
    public Class<? extends Supplier> resolver() {
        return this.resolver;
    }

    public void resolver(Class<? extends Supplier> value) {
        this.resolver = value;
    }
}

