/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.Proxy;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class ProxyAnnotation
implements Proxy {
    private boolean lazy;
    private Class<?> proxyClass;

    public ProxyAnnotation(SourceModelBuildingContext modelContext) {
        this.lazy = true;
        this.proxyClass = Void.TYPE;
    }

    public ProxyAnnotation(Proxy annotation, SourceModelBuildingContext modelContext) {
        this.lazy = annotation.lazy();
        this.proxyClass = annotation.proxyClass();
    }

    public ProxyAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.lazy = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.PROXY, "lazy", modelContext);
        this.proxyClass = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.PROXY, "proxyClass", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Proxy.class;
    }

    @Override
    public boolean lazy() {
        return this.lazy;
    }

    public void lazy(boolean value) {
        this.lazy = value;
    }

    @Override
    public Class<?> proxyClass() {
        return this.proxyClass;
    }

    public void proxyClass(Class<?> value) {
        this.proxyClass = value;
    }
}

