/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.AttributeConverter;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.SoftDelete;
import org.hibernate.annotations.SoftDeleteType;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class SoftDeleteAnnotation
implements SoftDelete {
    private String columnName;
    private SoftDeleteType strategy;
    private Class<? extends AttributeConverter<Boolean, ?>> converter;

    public SoftDeleteAnnotation(SourceModelBuildingContext modelContext) {
        this.columnName = "";
        this.strategy = SoftDeleteType.DELETED;
        this.converter = SoftDelete.UnspecifiedConversion.class;
    }

    public SoftDeleteAnnotation(SoftDelete annotation, SourceModelBuildingContext modelContext) {
        this.columnName = annotation.columnName();
        this.strategy = annotation.strategy();
        this.converter = annotation.converter();
    }

    public SoftDeleteAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.columnName = (String)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SOFT_DELETE, "columnName", modelContext);
        this.strategy = (SoftDeleteType)((Object)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SOFT_DELETE, "strategy", modelContext));
        this.converter = (Class)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SOFT_DELETE, "converter", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SoftDelete.class;
    }

    @Override
    public String columnName() {
        return this.columnName;
    }

    public void columnName(String value) {
        this.columnName = value;
    }

    @Override
    public SoftDeleteType strategy() {
        return this.strategy;
    }

    public void strategy(SoftDeleteType value) {
        this.strategy = value;
    }

    @Override
    public Class<? extends AttributeConverter<Boolean, ?>> converter() {
        return this.converter;
    }

    public void converter(Class<? extends AttributeConverter<Boolean, ?>> value) {
        this.converter = value;
    }
}

