/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureParameter;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbStoredProcedureParameterImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class StoredProcedureParameterJpaAnnotation
implements StoredProcedureParameter {
    private String name;
    private ParameterMode mode;
    private Class<?> type;

    public StoredProcedureParameterJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.mode = ParameterMode.IN;
    }

    public StoredProcedureParameterJpaAnnotation(StoredProcedureParameter annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.mode = annotation.mode();
        this.type = annotation.type();
    }

    public StoredProcedureParameterJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.STORED_PROCEDURE_PARAMETER, "name", modelContext);
        this.mode = (ParameterMode)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.STORED_PROCEDURE_PARAMETER, "mode", modelContext);
        this.type = (Class)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.STORED_PROCEDURE_PARAMETER, "type", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return StoredProcedureParameter.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public ParameterMode mode() {
        return this.mode;
    }

    public void mode(ParameterMode value) {
        this.mode = value;
    }

    public Class<?> type() {
        return this.type;
    }

    public void type(Class<?> value) {
        this.type = value;
    }

    public void apply(JaxbStoredProcedureParameterImpl jaxbParam, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbParam.getName())) {
            this.name(jaxbParam.getName());
        }
        if (jaxbParam.getMode() != null) {
            this.mode(jaxbParam.getMode());
        }
        if (StringHelper.isNotEmpty(jaxbParam.getClazz())) {
            this.type(xmlDocumentContext.resolveJavaType(jaxbParam.getClazz()).toJavaClass());
        }
    }
}

