/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import org.hibernate.annotations.Synchronize;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class SynchronizeAnnotation
implements Synchronize {
    private String[] value;
    private boolean logical;

    public SynchronizeAnnotation(SourceModelBuildingContext modelContext) {
        this.logical = true;
    }

    public SynchronizeAnnotation(Synchronize annotation, SourceModelBuildingContext modelContext) {
        this.value = annotation.value();
        this.logical = annotation.logical();
    }

    public SynchronizeAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.value = (String[])OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SYNCHRONIZE, "value", modelContext);
        this.logical = (Boolean)OrmAnnotationHelper.extractJandexValue(annotation, HibernateAnnotations.SYNCHRONIZE, "logical", modelContext);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Synchronize.class;
    }

    @Override
    public String[] value() {
        return this.value;
    }

    public void value(String[] value) {
        this.value = value;
    }

    @Override
    public boolean logical() {
        return this.logical;
    }

    public void logical(boolean value) {
        this.logical = value;
    }
}

